/*
 * Decompiled with CFR 0.152.
 */
package gui.sensitivity;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileFilterByExt
extends FileFilter {
    private String extFilter;

    public FileFilterByExt(String extension_) {
        this.extFilter = extension_.toLowerCase();
    }

    @Override
    public boolean accept(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String ext = FileFilterByExt.getExtension(file);
        return ext != null && ext.equals(this.extFilter);
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.extFilter) + " files";
    }

    public static String getExtension(File file) {
        String ext = null;
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

