/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.list;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.list.MutableListModel;
import org.jvnet.lafwidget.list.SmoothListDrop;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeTracker;

public class ListDragAndDropWidget
extends LafWidgetAdapter {
    protected JList list;
    protected SmoothListDrop.Listener smoothDropListener;

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.list = (JList)jcomp;
    }

    public void installListeners() {
        final ListModel listModel = this.list.getModel();
        if (listModel instanceof MutableListModel) {
            SmoothListDrop.DropSmoother smoother = new SmoothListDrop.DropSmoother(this.list){

                protected void move(int fromIndex, int toIndex) {
                    ((MutableListModel)((Object)listModel)).move(fromIndex, toIndex);
                    FadeConfigurationManager.getInstance().allowFades(FadeTracker.FadeKind.ROLLOVER, ListDragAndDropWidget.this.list);
                    ListDragAndDropWidget.this.list.revalidate();
                    ListDragAndDropWidget.this.list.repaint();
                }

                protected void init(int index) {
                    FadeConfigurationManager.getInstance().disallowFades(FadeTracker.FadeKind.ROLLOVER, ListDragAndDropWidget.this.list);
                }
            };
            this.smoothDropListener = new SmoothListDrop.Listener(smoother);
            this.list.addMouseListener(this.smoothDropListener);
            this.list.addMouseMotionListener(this.smoothDropListener);
        }
    }

    public void uninstallListeners() {
        if (this.smoothDropListener != null) {
            this.list.removeMouseListener(this.smoothDropListener);
            this.list.removeMouseMotionListener(this.smoothDropListener);
            this.smoothDropListener.stop();
            this.smoothDropListener = null;
        }
    }
}

