/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FadeStateListener {
    protected FadeTracker.FadeTrackerCallback callback;
    protected Component comp;
    protected ButtonModel buttonModel;
    protected Map<FadeTracker.FadeKind, Boolean> prevStateMap;
    protected ChangeListener modelListener;
    protected FocusListener focusListener;
    protected long focusLoopFadeInstanceId;
    protected Set<FadeTracker.FadeKind> toIgnore;

    public FadeStateListener(Component comp, ButtonModel buttonModel, FadeTracker.FadeTrackerCallback callback) {
        this(comp, buttonModel, callback, new HashSet<FadeTracker.FadeKind>());
    }

    public FadeStateListener(Component comp, ButtonModel buttonModel, FadeTracker.FadeTrackerCallback callback, Set<FadeTracker.FadeKind> toIgnore) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.callback = callback;
        this.toIgnore = toIgnore;
        this.prevStateMap = new HashMap<FadeTracker.FadeKind, Boolean>();
        if (buttonModel != null) {
            this.prevStateMap.put(FadeTracker.FadeKind.SELECTION, buttonModel.isSelected());
            this.prevStateMap.put(FadeTracker.FadeKind.ARM, buttonModel.isArmed());
            this.prevStateMap.put(FadeTracker.FadeKind.ROLLOVER, buttonModel.isRollover());
            this.prevStateMap.put(FadeTracker.FadeKind.PRESS, buttonModel.isPressed());
            this.prevStateMap.put(FadeTracker.FadeKind.ENABLE, buttonModel.isEnabled());
        }
        this.prevStateMap.put(FadeTracker.FadeKind.FOCUS, comp.hasFocus());
        this.focusLoopFadeInstanceId = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeTracker.FadeKind fadeKind, boolean newValue, boolean toRepaintParent) {
        if (LafWidgetRepository.getRepository().getFadeIgnoreManager().toIgnoreAnimations(this.comp)) {
            return;
        }
        if (this.toIgnore.contains(fadeKind)) {
            if (this.callback != null) {
                this.callback.fadeEnded(fadeKind);
            } else {
                this.comp.repaint();
            }
            return;
        }
        try {
            if (this.prevStateMap.containsKey(fadeKind)) {
                boolean prevValue = this.prevStateMap.get(fadeKind);
                if (prevValue == newValue) {
                    return;
                }
            } else {
                if (!newValue) {
                    return;
                }
                if (fadeKind == FadeTracker.FadeKind.SELECTION) {
                    if (this.callback != null) {
                        this.callback.fadeEnded(FadeTracker.FadeKind.SELECTION);
                    }
                    return;
                }
            }
            FadeTracker.getInstance().trackFade(this.comp, fadeKind, newValue, toRepaintParent, this.callback);
        }
        finally {
            this.prevStateMap.put(fadeKind, newValue);
        }
    }

    public void registerListeners() {
        this.registerListeners(false);
    }

    public void registerListeners(final boolean toRepaintParent) {
        this.modelListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (FadeStateListener.this.buttonModel == null) {
                    return;
                }
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.SELECTION, FadeStateListener.this.buttonModel.isSelected(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ARM, FadeStateListener.this.buttonModel.isArmed(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ROLLOVER, FadeStateListener.this.buttonModel.isRollover(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ENABLE, FadeStateListener.this.buttonModel.isEnabled(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.PRESS, FadeStateListener.this.buttonModel.isPressed(), toRepaintParent);
            }
        };
        if (this.buttonModel != null) {
            this.buttonModel.addChangeListener(this.modelListener);
        }
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.FOCUS, true, toRepaintParent);
                FadeStateListener.this.initiateFocusFadeLoop();
            }

            public void focusLost(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.FOCUS, false, toRepaintParent);
                if (FadeStateListener.this.focusLoopFadeInstanceId >= 0L) {
                    FadeTracker.getInstance().cancelFadeInstance(FadeStateListener.this.focusLoopFadeInstanceId);
                }
            }
        };
        this.comp.addFocusListener(this.focusListener);
        if (this.comp.hasFocus()) {
            this.initiateFocusFadeLoop();
        }
    }

    protected void initiateFocusFadeLoop() {
        FadeTracker.FadeTrackerCallback loopCallback;
        FadeTracker.FadeTrackerCallback fadeTrackerCallback = loopCallback = this.callback != null ? this.callback : new FadeTracker.FadeTrackerCallback(){

            public void fadeEnded(FadeTracker.FadeKind fadeKind) {
                FadeStateListener.this.comp.repaint();
            }

            public void fadePerformed(FadeTracker.FadeKind fadeKind, float fadeCycle10) {
                FadeStateListener.this.comp.repaint();
            }
        };
        if (FadeConfigurationManager.getInstance().fadeAllowed(FadeTracker.FadeKind.FOCUS_LOOP_ANIMATION, this.comp)) {
            this.focusLoopFadeInstanceId = FadeTracker.getInstance().trackFadeLooping(FadeTracker.FadeKind.FOCUS_LOOP_ANIMATION, LafWidgetUtilities.getAnimationKind(this.comp), this.comp, null, false, loopCallback, false);
        }
    }

    public void unregisterListeners() {
        if (this.buttonModel != null) {
            this.buttonModel.removeChangeListener(this.modelListener);
        }
        this.comp.removeFocusListener(this.focusListener);
    }
}

