/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeTracker;

public class GhostPaintingUtils {
    public static float MIN_ICON_GHOSTING_ALPHA = 0.15f;
    public static float MAX_ICON_GHOSTING_ALPHA = 0.5f;
    public static float MIN_PRESS_GHOSTING_ALPHA = 0.15f;
    public static float MAX_PRESS_GHOSTING_ALPHA = 0.3f;
    public static float DECAY_FACTOR = 1.0f;
    private static LinkedHashMap<String, BufferedImage> componentGhostCache = new LinkedHashMap<String, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
            return this.size() > 50;
        }
    };
    private static LinkedHashMap<String, BufferedImage> iconGhostCache = new LinkedHashMap<String, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
            return this.size() > 50;
        }
    };

    protected static synchronized BufferedImage getComponentGhostImage(Component comp, double scaleFactor) {
        FadeTracker ft = FadeTracker.getInstance();
        String key = ft.getCurrLoopId() + ":" + comp.hashCode() + ":" + scaleFactor;
        BufferedImage result = componentGhostCache.get(key);
        if (result == null) {
            Rectangle bounds = comp.getBounds();
            double iWidth = (double)bounds.width * scaleFactor;
            double iHeight = (double)bounds.height * scaleFactor;
            result = LafWidgetUtilities.getBlankImage((int)iWidth, (int)iHeight);
            Graphics2D iGraphics = result.createGraphics();
            iGraphics.scale(scaleFactor, scaleFactor);
            comp.paint(iGraphics);
            iGraphics.dispose();
            componentGhostCache.put(key, result);
        }
        return result;
    }

    protected static synchronized BufferedImage getIconGhostImage(Component comp, Icon icon, double scaleFactor) {
        FadeTracker ft = FadeTracker.getInstance();
        String key = ft.getCurrLoopId() + ":" + comp.hashCode() + ":" + icon.hashCode() + ":" + scaleFactor;
        BufferedImage result = componentGhostCache.get(key);
        if (result == null) {
            int oWidth = icon.getIconWidth();
            int oHeight = icon.getIconHeight();
            double iWidth = (double)oWidth * scaleFactor;
            double iHeight = (double)oHeight * scaleFactor;
            result = LafWidgetUtilities.getBlankImage((int)iWidth, (int)iHeight);
            Graphics2D iGraphics = result.createGraphics();
            iGraphics.scale(scaleFactor, scaleFactor);
            icon.paintIcon(comp, iGraphics, 0, 0);
            iGraphics.dispose();
            componentGhostCache.put(key, result);
        }
        return result;
    }

    public static void paintGhostImages(Component mainComponent, Graphics g) {
        float fade10;
        int dy;
        int dx;
        Rectangle compRect;
        Set<Component> animComps;
        if (!mainComponent.isShowing()) {
            return;
        }
        if (!mainComponent.isVisible()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle mainRect = mainComponent.getBounds();
        mainRect.setLocation(mainComponent.getLocationOnScreen());
        if (FadeConfigurationManager.getInstance().fadeAllowed(FadeTracker.FadeKind.GHOSTING_BUTTON_PRESS, mainComponent)) {
            animComps = FadeTracker.getInstance().getAllComponentsByFadeKind(FadeTracker.FadeKind.GHOSTING_BUTTON_PRESS);
            for (Component comp : animComps) {
                if (comp == mainComponent || !comp.isShowing() || !comp.isVisible()) continue;
                compRect = comp.getBounds();
                compRect.setLocation(comp.getLocationOnScreen());
                dx = compRect.x - mainRect.x;
                dy = compRect.y - mainRect.y;
                compRect.x -= compRect.width / 2;
                compRect.y -= compRect.height / 2;
                compRect.width *= 2;
                compRect.height *= 2;
                if (!mainRect.intersects(compRect)) continue;
                fade10 = FadeTracker.getInstance().getFade10(comp, null, FadeTracker.FadeKind.GHOSTING_BUTTON_PRESS);
                double start = (double)MAX_PRESS_GHOSTING_ALPHA - 0.0015 * compRect.getWidth();
                float coef = Math.max((float)start, MIN_PRESS_GHOSTING_ALPHA);
                float opFactor = coef * (1.0f - DECAY_FACTOR * fade10 / 10.0f);
                double iFactor = 1.0 + (double)fade10 / 10.0;
                graphics.setComposite(TransitionLayout.getAlphaComposite(mainComponent, opFactor));
                Rectangle bounds = comp.getBounds();
                BufferedImage ghost = GhostPaintingUtils.getComponentGhostImage(comp, iFactor);
                graphics.drawImage((Image)ghost, dx -= (ghost.getWidth() - bounds.width) / 2, dy -= (ghost.getHeight() - bounds.height) / 2, null);
            }
        }
        if (FadeConfigurationManager.getInstance().fadeAllowed(FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER, mainComponent)) {
            animComps = FadeTracker.getInstance().getAllComponentsByFadeKind(FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER);
            for (Component comp : animComps) {
                if (comp == mainComponent || !comp.isShowing() || !comp.isVisible()) continue;
                compRect = comp.getBounds();
                compRect.setLocation(comp.getLocationOnScreen());
                dx = compRect.x - mainRect.x;
                dy = compRect.y - mainRect.y;
                compRect.x -= compRect.width / 2;
                compRect.y -= compRect.height / 2;
                compRect.width *= 2;
                compRect.height *= 2;
                if (!mainRect.intersects(compRect)) continue;
                fade10 = FadeTracker.getInstance().getFade10(comp, null, FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER);
                Icon icon = null;
                Rectangle iconRect = null;
                if (comp instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)comp;
                    icon = LafWidgetUtilities.getIcon(button);
                    iconRect = (Rectangle)button.getClientProperty("icon.bounds");
                }
                if (icon == null || iconRect == null) continue;
                double iFactor = 1.0 + (double)fade10 / 10.0;
                BufferedImage iImage = GhostPaintingUtils.getIconGhostImage(comp, icon, iFactor);
                int iWidth = iImage.getWidth();
                int iHeight = iImage.getHeight();
                double start = MAX_ICON_GHOSTING_ALPHA - (MAX_ICON_GHOSTING_ALPHA - MIN_ICON_GHOSTING_ALPHA) * (float)(iWidth - 16) / 48.0f;
                float coef = Math.max((float)start, MIN_ICON_GHOSTING_ALPHA);
                float opFactor = coef * (1.0f - DECAY_FACTOR * fade10 / 10.0f);
                graphics.setComposite(TransitionLayout.getAlphaComposite(mainComponent, opFactor));
                graphics.drawImage((Image)iImage, (dx -= (iWidth - icon.getIconWidth()) / 2) + iconRect.x, (dy -= (iHeight - icon.getIconHeight()) / 2) + iconRect.y, null);
            }
        }
        graphics.dispose();
    }

    public static void paintGhostIcon(Graphics2D graphics, AbstractButton b, Icon icon) {
        GhostPaintingUtils.paintGhostIcon(graphics, b, icon, (Rectangle)b.getClientProperty("icon.bounds"));
    }

    public static void paintGhostIcon(Graphics2D graphics, AbstractButton b, Rectangle iconRectangle) {
        GhostPaintingUtils.paintGhostIcon(graphics, b, LafWidgetUtilities.getIcon(b), iconRectangle);
    }

    public static void paintGhostIcon(Graphics2D graphics, AbstractButton b, Icon icon, Rectangle iconRectangle) {
        if (!FadeConfigurationManager.getInstance().fadeAllowed(FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER, b)) {
            return;
        }
        if (FadeTracker.getInstance().isTracked(b, null, FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER, true)) {
            float fade10 = FadeTracker.getInstance().getFade10(b, FadeTracker.FadeKind.GHOSTING_ICON_ROLLOVER);
            if (icon != null && iconRectangle != null) {
                double iFactor = 1.0 + (double)fade10 / 10.0;
                BufferedImage iImage = GhostPaintingUtils.getIconGhostImage(b, icon, iFactor);
                int iWidth = iImage.getWidth();
                int iHeight = iImage.getHeight();
                int dx = (iWidth - icon.getIconWidth()) / 2;
                int dy = (iHeight - icon.getIconHeight()) / 2;
                double start = MAX_ICON_GHOSTING_ALPHA - (MAX_ICON_GHOSTING_ALPHA - MIN_ICON_GHOSTING_ALPHA) * (float)(iWidth - 16) / 48.0f;
                float coef = Math.max((float)start, MIN_ICON_GHOSTING_ALPHA);
                float opFactor = coef * (1.0f - DECAY_FACTOR * fade10 / 10.0f);
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, opFactor));
                graphics.drawImage((Image)iImage, iconRectangle.x - dx, iconRectangle.y - dy, null);
            }
        }
    }
}

