/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceHeaderPainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceFillBackgroundDelegate {
    private float alphaComposite;

    public SubstanceFillBackgroundDelegate() {
        this(1.0f);
    }

    public SubstanceFillBackgroundDelegate(float alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    public void update(Graphics g, Component c) {
        this.update(g, c, SubstanceCoreUtilities.isInHeader(c));
    }

    public void updateIfOpaque(Graphics g, Component c) {
        if (TransitionLayout.isOpaque(c)) {
            this.update(g, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, Component c, boolean useHeaderPainter) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        Component component = c;
        synchronized (component) {
            SubstanceHeaderPainter headerPainter;
            SubstanceTheme theme;
            boolean isSelected;
            Window window;
            graphics.setComposite(TransitionLayout.getAlphaComposite(c));
            JRootPane rootPane = SwingUtilities.getRootPane(c);
            SubstanceTitlePainter titlePainter = SubstanceCoreUtilities.getTitlePainter(rootPane);
            boolean shouldUseHeaderPainter = useHeaderPainter && titlePainter instanceof SubstanceHeaderPainter;
            boolean paintDropShadow = false;
            if (shouldUseHeaderPainter && c instanceof JToolBar) {
                SubstanceHeaderPainter headerPainter2 = (SubstanceHeaderPainter)titlePainter;
                shouldUseHeaderPainter = headerPainter2.isPaintingToolbars();
                paintDropShadow = shouldUseHeaderPainter ? false : headerPainter2.isPaintingToolbarDropShadows();
            }
            Container headerParent = SubstanceCoreUtilities.getHeaderParent(c);
            if (shouldUseHeaderPainter && headerParent instanceof JToolBar) {
                shouldUseHeaderPainter = ((SubstanceHeaderPainter)titlePainter).isPaintingToolbars();
            }
            if (shouldUseHeaderPainter) {
                window = SwingUtilities.windowForComponent(c);
                isSelected = window == null ? true : window.isActive();
                theme = isSelected ? SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme() : SubstanceLookAndFeel.getTheme().getDefaultTitlePaneTheme();
                headerPainter = (SubstanceHeaderPainter)titlePainter;
                headerPainter.paintExtraBackground(graphics, headerParent, c, c.getWidth(), c.getHeight(), theme, false);
            } else {
                if (c instanceof JMenu) {
                    ColorUIResource backgroundColor = new ColorUIResource(SubstanceColorUtilities.getBackgroundColor(SubstanceLookAndFeel.getTheme()));
                    ColorUIResource headerBackgroundColor = new ColorUIResource(SubstanceColorUtilities.getBackgroundColor(SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme()));
                    if (shouldUseHeaderPainter && c.getParent() instanceof JMenuBar) {
                        graphics.setColor(headerBackgroundColor);
                    } else {
                        graphics.setColor(backgroundColor);
                    }
                } else {
                    graphics.setColor(c.getBackground());
                }
                if (c instanceof JMenuItem) {
                    // empty if block
                }
                graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            if (paintDropShadow) {
                Color neg = SubstanceColorUtilities.getNegativeColor(c.getBackground());
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(neg, 150), 0.0f, 4.0f, SubstanceColorUtilities.getAlphaColor(neg, 16)));
                graphics.fillRect(0, 0, c.getWidth(), 4);
            }
            if (!isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
                if (shouldUseHeaderPainter) {
                    window = SwingUtilities.windowForComponent(c);
                    isSelected = window == null ? true : window.isActive();
                    theme = isSelected ? SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme() : SubstanceLookAndFeel.getTheme().getDefaultTitlePaneTheme();
                    headerPainter = (SubstanceHeaderPainter)titlePainter;
                    Composite oldComp = graphics.getComposite();
                    graphics.setComposite(TransitionLayout.getAlphaComposite(c, 0.5f));
                    headerPainter.paintExtraBackground(graphics, headerParent, c, c.getWidth(), c.getHeight(), theme, false);
                    graphics.setComposite(oldComp);
                }
            }
        }
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, JComponent c, Rectangle rect) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (TransitionLayout.isOpaque(c)) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(c));
                graphics.setColor(c.getBackground());
                graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, this.alphaComposite));
                if (!isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
                    SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
                }
            }
        }
        graphics.dispose();
    }

    public void setAlphaComposite(float alphaComposite) {
        this.alphaComposite = alphaComposite;
    }
}

