/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import cern.colt.matrix.DoubleMatrix2D;
import edu.uci.ics.jung.algorithms.GraphMatrixOperations;
import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import java.util.Iterator;

public class RandomWalkSTBetweenness
extends AbstractRanker {
    public static final String CENTRALITY = "centrality.RandomWalkSTBetweennessCentrality";
    private DoubleMatrix2D mVoltageMatrix;
    private Indexer mIndexer;
    Vertex mSource;
    Vertex mTarget;

    public RandomWalkSTBetweenness(UndirectedGraph g, Vertex s, Vertex t) {
        this.initialize(g, true, false);
        this.mSource = s;
        this.mTarget = t;
    }

    protected Indexer getIndexer() {
        return this.mIndexer;
    }

    protected DoubleMatrix2D getVoltageMatrix() {
        return this.mVoltageMatrix;
    }

    protected void setUp() {
        this.mVoltageMatrix = GraphMatrixOperations.computeVoltagePotentialMatrix((UndirectedGraph)this.getGraph());
        this.mIndexer = Indexer.getIndexer(this.getGraph());
    }

    protected void computeBetweenness() {
        this.setUp();
        Iterator iIt = this.getGraph().getVertices().iterator();
        while (iIt.hasNext()) {
            Vertex ithVertex = (Vertex)iIt.next();
            this.setRankScore(ithVertex, this.computeSTBetweenness(ithVertex, this.mSource, this.mTarget));
        }
    }

    public double computeSTBetweenness(Vertex ithVertex, Vertex source, Vertex target) {
        if (ithVertex == source || ithVertex == target) {
            return 1.0;
        }
        if (this.mVoltageMatrix == null) {
            this.setUp();
        }
        int i = this.mIndexer.getIndex(ithVertex);
        int s = this.mIndexer.getIndex(source);
        int t = this.mIndexer.getIndex(target);
        double betweenness = 0.0;
        Iterator vIt = ithVertex.getSuccessors().iterator();
        while (vIt.hasNext()) {
            Vertex jthVertex = (Vertex)vIt.next();
            int j = this.mIndexer.getIndex(jthVertex);
            double currentFlow = 0.0;
            currentFlow += this.mVoltageMatrix.get(i, s);
            currentFlow -= this.mVoltageMatrix.get(i, t);
            currentFlow -= this.mVoltageMatrix.get(j, s);
            betweenness += Math.abs(currentFlow += this.mVoltageMatrix.get(j, t));
        }
        return betweenness / 2.0;
    }

    public String getRankScoreKey() {
        return CENTRALITY;
    }

    protected double evaluateIteration() {
        this.computeBetweenness();
        return 0.0;
    }
}

