/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters.impl;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.filters.EfficientFilter;
import edu.uci.ics.jung.graph.filters.GeneralVertexAcceptFilter;

public class AlphabeticVertexFilter
extends GeneralVertexAcceptFilter
implements EfficientFilter {
    private StringLabeller stringLabeller;
    private String threshhold;
    private boolean acceptThoseAboveThreshhold;

    public AlphabeticVertexFilter(String threshhold, StringLabeller sl, boolean acceptAboveThreshold) {
        this.stringLabeller = sl;
        this.threshhold = threshhold;
        this.acceptThoseAboveThreshhold = acceptAboveThreshold;
    }

    public boolean acceptVertex(Vertex vert) {
        String comp = this.stringLabeller.getLabel(vert);
        return comp.compareTo(this.threshhold) > 0 && this.acceptThoseAboveThreshhold;
    }

    public String getName() {
        String label = this.acceptThoseAboveThreshhold ? ">" : "<=";
        return "Alphabetic filter(" + label + "\"" + this.threshhold + "\")";
    }

    public boolean isAcceptThoseAboveThreshhold() {
        return this.acceptThoseAboveThreshhold;
    }

    public String getThreshhold() {
        return this.threshhold;
    }

    public void setAcceptThoseAboveThreshhold(boolean acceptThoseAboveThreshhold) {
        this.acceptThoseAboveThreshhold = acceptThoseAboveThreshhold;
    }

    public void setThreshhold(String threshhold) {
        this.threshhold = threshhold;
    }

    public StringLabeller getStringLabeller() {
        return this.stringLabeller;
    }

    public void setStringLabeller(StringLabeller stringLabeller) {
        this.stringLabeller = stringLabeller;
    }
}

