/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.transform;

import java.awt.Dimension;
import java.util.Iterator;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.transform.LayoutTransformer;

public class SlightMarginTransformer
implements LayoutTransformer {
    private Dimension d;
    double percentage = 0.9;

    public SlightMarginTransformer() {
    }

    public SlightMarginTransformer(double percentage) {
        this.percentage = percentage;
    }

    public EmittedLayout transform(EmittedLayout el) {
        Iterator iter = el.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vv = (VisVertex)iter.next();
            vv.x += (1.0 - this.percentage) / 2.0 * this.d.getWidth();
            vv.y += (1.0 - this.percentage) / 2.0 * this.d.getHeight();
        }
        return el;
    }

    public void adjustSize(Dimension d) {
        d.setSize(d.getWidth() * this.percentage, d.getHeight() * this.percentage);
        this.d = d;
    }

    public boolean supportsInvert() {
        return true;
    }

    public Coordinates invert(Coordinates in) {
        in.x -= (1.0 - this.percentage) / 2.0 * this.d.getWidth();
        in.y -= (1.0 - this.percentage) / 2.0 * this.d.getHeight();
        return in;
    }
}

