/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceBorder
implements Border,
UIResource {
    protected Insets myInsets;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate(0.6f);

    public SubstanceBorder(int insetSize) {
        this.myInsets = new Insets(insetSize, insetSize, insetSize, insetSize);
    }

    public SubstanceBorder(Insets insets) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public SubstanceBorder() {
        this(2);
    }

    private static void paintBorder(Component c, Graphics g, int x, int y, int width, int height, boolean isEnabled, boolean hasFocus) {
        Border b;
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(c));
        if (SubstanceCoreUtilities.toBleedWatermark(c) && c instanceof JComponent && (b = ((JComponent)c).getBorder()) != null) {
            Graphics2D graphics2 = (Graphics2D)graphics.create();
            Shape clip = graphics2.getClip();
            Insets ins = b.getBorderInsets(c);
            graphics2.clipRect(x, y, ins.left, height);
            bgDelegate.updateIfOpaque(graphics2, c);
            graphics2.setClip(clip);
            graphics2.clipRect(x, y, width, ins.top);
            bgDelegate.updateIfOpaque(graphics2, c);
            graphics2.setClip(clip);
            graphics2.clipRect(x + width - ins.right, y, ins.right, height);
            bgDelegate.updateIfOpaque(graphics2, c);
            graphics2.setClip(clip);
            graphics2.clipRect(x, y + height - ins.bottom, width, ins.bottom);
            bgDelegate.updateIfOpaque(graphics2, c);
            graphics2.dispose();
        }
        SubstanceTheme theme1 = null;
        SubstanceTheme theme2 = null;
        float cyclePos = 1.0f;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        boolean isFocusAnimated = fadeTracker.isTracked(c, FadeTracker.FadeKind.FOCUS);
        boolean isBorderAnimated = fadeTracker.isTracked(c, SubstanceLookAndFeel.BORDER_ANIMATION_KIND);
        if (isFocusAnimated || isBorderAnimated || c.hasFocus()) {
            SubstanceTheme controlDefaultTheme;
            SubstanceTheme controlActiveTheme = SubstanceCoreUtilities.getActiveTheme((JComponent)c, true);
            theme1 = controlDefaultTheme = SubstanceCoreUtilities.getDefaultTheme((JComponent)c, true);
            theme2 = controlActiveTheme;
            cyclePos = isFocusAnimated ? fadeTracker.getFade10(c, FadeTracker.FadeKind.FOCUS) / 10.0f : (isBorderAnimated ? fadeTracker.getFade10(c, SubstanceLookAndFeel.BORDER_ANIMATION_KIND) / 10.0f : 1.0f);
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, theme1);
            graphics.setComposite(TransitionLayout.getAlphaComposite(c, cyclePos));
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, theme2);
        } else if (isEnabled) {
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, SubstanceCoreUtilities.getDefaultTheme((JComponent)c, true));
        } else {
            SubstanceTheme controlDisabledTheme = SubstanceCoreUtilities.getDisabledTheme((JComponent)c, true);
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, controlDisabledTheme);
        }
        if (fadeTracker.isTracked(c, FadeTracker.FadeKind.FOCUS_LOOP_ANIMATION)) {
            float coef = 0.4f;
            if (fadeTracker.isTracked(c, FadeTracker.FadeKind.FOCUS)) {
                coef = 0.4f * fadeTracker.getFade10(c, FadeTracker.FadeKind.FOCUS) / 10.0f;
            }
            graphics.setComposite(TransitionLayout.getAlphaComposite(c, coef));
            int extraPadding = 2 + SubstanceSizeUtils.getExtraPadding();
            SubstanceCoreUtilities.paintFocus(graphics, c, c, new Rectangle(1, 1, c.getWidth() - 1, c.getHeight() - 1), coef, extraPadding);
        }
        graphics.dispose();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        SubstanceBorder.paintBorder(c, g, x, y, width, height, c.isEnabled(), c.hasFocus());
    }

    public Insets getBorderInsets(Component c) {
        JTextComponent textComp;
        Insets margin;
        if (c instanceof JTextComponent && (margin = (textComp = (JTextComponent)c).getMargin()) != null) {
            return new Insets(this.myInsets.top + margin.top, this.myInsets.left + margin.left, this.myInsets.bottom + margin.bottom, this.myInsets.right + margin.right);
        }
        return this.myInsets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

