/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.params.ParamReader;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceImageWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;
    private static SubstanceConstants.ImageWatermarkKind kind = SubstanceConstants.ImageWatermarkKind.SCREEN_CENTER_SCALE;
    private static float opacity = 0.2f;
    protected BufferedImage origImage;
    protected String origImageLocation;

    public SubstanceImageWatermark(ParamReader paramReader) throws AccessControlException {
        this(paramReader.getWatermarkImageProperty());
    }

    public SubstanceImageWatermark(String imageLocation) {
        if (imageLocation != null) {
            try {
                if (imageLocation.startsWith("http")) {
                    URL url = new URL(imageLocation);
                    BufferedImage tempImage = ImageIO.read(url);
                    this.origImage = SubstanceCoreUtilities.createCompatibleImage(tempImage);
                } else {
                    try {
                        this.origImage = SubstanceCoreUtilities.createCompatibleImage(ImageIO.read(new File(imageLocation)));
                    }
                    catch (IIOException iioe) {
                        this.origImage = SubstanceCoreUtilities.createCompatibleImage(ImageIO.read(SubstanceImageWatermark.class.getClassLoader().getResource(imageLocation)));
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.origImageLocation = imageLocation;
    }

    public SubstanceImageWatermark(InputStream inputStream) {
        if (inputStream != null) {
            try {
                BufferedImage tempImage = ImageIO.read(inputStream);
                this.origImage = SubstanceCoreUtilities.createCompatibleImage(tempImage);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.origImageLocation = null;
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = 0;
        int dy = 0;
        Component topParent = null;
        switch (SubstanceImageWatermark.getKind()) {
            case SCREEN_CENTER_SCALE: 
            case SCREEN_TILE: {
                dx = c.getLocationOnScreen().x;
                dy = c.getLocationOnScreen().y;
                break;
            }
            case APP_ANCHOR: 
            case APP_TILE: {
                if (c instanceof JComponent) {
                    topParent = ((JComponent)c).getTopLevelAncestor();
                } else {
                    Component comp = c;
                    while (comp.getParent() != null) {
                        comp = comp.getParent();
                    }
                    topParent = comp;
                }
                dx = c.getLocationOnScreen().x - topParent.getLocationOnScreen().x;
                dy = c.getLocationOnScreen().y - topParent.getLocationOnScreen().y;
                break;
            }
            case APP_CENTER: {
                if (c instanceof JComponent) {
                    topParent = ((JComponent)c).getTopLevelAncestor();
                } else {
                    Component comp = c;
                    while (comp.getParent() != null) {
                        comp = comp.getParent();
                    }
                    topParent = comp;
                }
                dx = c.getLocationOnScreen().x - topParent.getLocationOnScreen().x;
                dy = c.getLocationOnScreen().y - topParent.getLocationOnScreen().y;
                dx -= topParent.getWidth() / 2 - this.origImage.getWidth() / 2;
                dy -= topParent.getHeight() / 2 - this.origImage.getHeight() / 2;
            }
        }
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
    }

    public boolean updateWatermarkImage() {
        Graphics2D graphics;
        GraphicsDevice[] gds;
        if (this.origImage == null) {
            return false;
        }
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        int origImageWidth = this.origImage.getWidth();
        int origImageHeight = this.origImage.getHeight();
        if (SubstanceImageWatermark.getKind() == SubstanceConstants.ImageWatermarkKind.SCREEN_CENTER_SCALE) {
            boolean isHeightFits;
            watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
            graphics = (Graphics2D)watermarkImage.getGraphics().create();
            AlphaComposite comp = AlphaComposite.getInstance(3, opacity);
            graphics.setComposite(comp);
            boolean isWidthFits = origImageWidth <= screenWidth;
            boolean bl = isHeightFits = origImageHeight <= screenHeight;
            if (isWidthFits && isHeightFits) {
                graphics.drawImage((Image)this.origImage, (screenWidth - origImageWidth) / 2, (screenHeight - origImageHeight) / 2, null);
                graphics.dispose();
                return true;
            }
            if (isWidthFits) {
                double scaleFact = (double)screenHeight / (double)origImageHeight;
                int dx = (int)((double)screenWidth - scaleFact * (double)origImageWidth) / 2;
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics.drawImage(this.origImage, dx, 0, screenWidth - dx, screenHeight, 0, 0, origImageWidth, origImageHeight, null);
                graphics.dispose();
                return true;
            }
            if (isHeightFits) {
                double scaleFact = (double)screenWidth / (double)origImageWidth;
                int dy = (int)((double)screenHeight - scaleFact * (double)origImageHeight) / 2;
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics.drawImage(this.origImage, 0, dy, screenWidth, screenHeight - dy, 0, 0, origImageWidth, origImageHeight, null);
                graphics.dispose();
                return true;
            }
            double scaleFactY = (double)screenHeight / (double)origImageHeight;
            double scaleFactX = (double)screenWidth / (double)origImageWidth;
            double scaleFact = Math.min(scaleFactX, scaleFactY);
            int dx = Math.max(0, (int)((double)screenWidth - scaleFact * (double)origImageWidth) / 2);
            int dy = Math.max(0, (int)((double)screenHeight - scaleFact * (double)origImageHeight) / 2);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics.drawImage(this.origImage, dx, dy, screenWidth - dx, screenHeight - dy, 0, 0, origImageWidth, origImageHeight, null);
            graphics.dispose();
            return true;
        }
        if (SubstanceImageWatermark.getKind() == SubstanceConstants.ImageWatermarkKind.SCREEN_TILE || SubstanceImageWatermark.getKind() == SubstanceConstants.ImageWatermarkKind.APP_TILE) {
            watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
            graphics = (Graphics2D)watermarkImage.getGraphics().create();
            AlphaComposite comp = AlphaComposite.getInstance(3, opacity);
            graphics.setComposite(comp);
            int replicateX = 1 + screenWidth / origImageWidth;
            int replicateY = 1 + screenHeight / origImageHeight;
            for (int i = 0; i < replicateX; ++i) {
                for (int j = 0; j < replicateY; ++j) {
                    graphics.drawImage((Image)this.origImage, i * origImageWidth, j * origImageHeight, null);
                }
            }
            graphics.dispose();
            return true;
        }
        if (SubstanceImageWatermark.getKind() == SubstanceConstants.ImageWatermarkKind.APP_ANCHOR || SubstanceImageWatermark.getKind() == SubstanceConstants.ImageWatermarkKind.APP_CENTER) {
            watermarkImage = SubstanceCoreUtilities.getBlankImage(origImageWidth, origImageHeight);
            graphics = (Graphics2D)watermarkImage.getGraphics().create();
            AlphaComposite comp = AlphaComposite.getInstance(3, opacity);
            graphics.setComposite(comp);
            graphics.drawImage((Image)this.origImage, 0, 0, null);
            graphics.dispose();
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return SubstanceImageWatermark.getName();
    }

    public static String getName() {
        return "Image";
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void dispose() {
        watermarkImage = null;
    }

    public String getOrigImageLocation() {
        return this.origImageLocation;
    }

    public static void setKind(SubstanceConstants.ImageWatermarkKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException("Can't pass null to SubstanceImageWatermark.setKind()");
        }
        SubstanceImageWatermark.kind = kind;
    }

    public static SubstanceConstants.ImageWatermarkKind getKind() {
        return kind;
    }

    public static float getOpacity() {
        return opacity;
    }

    public static void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("SubstanceImageWatermark.setOpacity() can get value in 0.0-1.0 range, was passed value " + opacity);
        }
        SubstanceImageWatermark.opacity = opacity;
    }
}

