/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class InputStreamWrapper {
    private static final int BUFFER_SIZE = 2048;
    private String m_encodingName;
    private InputStream m_stream;
    private boolean m_isEnd;
    private byte[] m_buffer = new byte[2048];
    private int m_endOffset;
    private int m_emptyOffset;
    private int m_scanOffset;

    public void setInput(InputStream ins) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_stream = ins;
        this.reset();
    }

    public void setInput(InputStream ins, String enc) throws IOException {
        this.setInput(ins);
        this.setEncoding(enc);
    }

    public void setEncoding(String enc) throws IOException {
        if (this.m_encodingName != null) {
            throw new IOException("Encoding has already been set for stream");
        }
        this.m_encodingName = enc;
    }

    private boolean fillBuffer() throws IOException {
        if (this.m_isEnd) {
            return false;
        }
        int rem = this.m_endOffset - this.m_emptyOffset;
        if (rem > 0) {
            System.arraycopy(this.m_buffer, this.m_emptyOffset, this.m_buffer, 0, rem);
        }
        this.m_emptyOffset = 0;
        int max = this.m_buffer.length - rem;
        int actual = this.m_stream.read(this.m_buffer, rem, max);
        if (actual >= 0) {
            this.m_endOffset = rem + actual;
            return true;
        }
        this.m_endOffset = rem;
        this.m_isEnd = true;
        return false;
    }

    private boolean require(int min) throws IOException {
        while (this.m_endOffset - this.m_emptyOffset < min) {
            if (this.fillBuffer()) continue;
            return false;
        }
        return true;
    }

    private boolean isWhite(int chr) {
        return chr == 32 || chr == 9 || chr == 10 || chr == 13;
    }

    private String scanToken() throws IOException {
        boolean skipping = true;
        StringBuffer buff = new StringBuffer();
        while (this.require(this.m_scanOffset + 1)) {
            char chr = (char)this.m_buffer[this.m_scanOffset++];
            if (skipping) {
                if (this.isWhite(chr)) continue;
                skipping = false;
                buff.append(chr);
                if (chr != '=') continue;
                return buff.toString();
            }
            if (this.isWhite(chr) || chr == '=') {
                --this.m_scanOffset;
                return buff.toString();
            }
            buff.append(chr);
            if (chr != '>') continue;
            return buff.toString();
        }
        return null;
    }

    private String scanQuoted() throws IOException {
        boolean skipping = true;
        char quot = '\u0000';
        StringBuffer buff = new StringBuffer();
        while (this.require(this.m_scanOffset + 1)) {
            char chr = (char)this.m_buffer[this.m_scanOffset++];
            if (skipping) {
                if (this.isWhite(chr)) continue;
                if (chr != '\"' && chr != '\'') break;
                skipping = false;
                quot = chr;
                continue;
            }
            if (chr == quot) {
                return buff.toString();
            }
            buff.append(chr);
        }
        return null;
    }

    public Reader getReader() throws IOException {
        if (this.m_encodingName == null) {
            this.m_encodingName = "UTF-8";
            if (this.require(4)) {
                int bom = (((this.m_buffer[0] << 8) + (this.m_buffer[1] & 0xFF) << 8) + (this.m_buffer[2] & 0xFF) << 8) + (this.m_buffer[3] & 0xFF);
                if (bom == 1010792557) {
                    this.m_scanOffset = 2;
                    String token = this.scanToken();
                    if ("xml".equals(token)) {
                        while ((token = this.scanToken()) != null && !"?>".equals(token)) {
                            if ("encoding".equals(token)) {
                                if (!"=".equals(this.scanToken()) || (token = this.scanQuoted()) == null) continue;
                                this.m_encodingName = token;
                                break;
                            }
                            if (!"=".equals(token)) continue;
                            this.scanQuoted();
                        }
                    }
                } else if (bom == 65279 || bom == -131072 || bom == 65534 || bom == -16842752) {
                    this.m_encodingName = "UCS-4";
                } else if ((bom & 0xFFFFFF00) == -272908544) {
                    this.m_encodingName = "UTF-8";
                } else {
                    int upper = bom & 0xFFFF0000;
                    if (upper == -16842752 || bom == 3932223) {
                        this.m_encodingName = "UTF-16BE";
                    } else if (upper == -131072 || bom == 1006649088) {
                        this.m_encodingName = "UTF-16LE";
                    } else if (bom == 1282385812) {
                        this.m_encodingName = "EBCDIC";
                    }
                }
            }
        }
        if (this.m_encodingName.equalsIgnoreCase("UTF-8")) {
            return new WrappedStreamUTF8Reader();
        }
        if (this.m_encodingName.equalsIgnoreCase("ISO-8859-1") || this.m_encodingName.equalsIgnoreCase("ASCII")) {
            return new WrappedStreamISO88591Reader();
        }
        return new InputStreamReader((InputStream)new WrappedStream(), this.m_encodingName);
    }

    public String getEncoding() {
        return this.m_encodingName;
    }

    public void close() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.close();
            this.m_stream = null;
        }
        this.reset();
    }

    public void reset() {
        this.m_isEnd = false;
        this.m_endOffset = 0;
        this.m_emptyOffset = 0;
        this.m_encodingName = null;
    }

    private class WrappedStreamISO88591Reader
    extends Reader {
        private WrappedStreamISO88591Reader() {
        }

        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        public int read(char[] b, int off, int len) throws IOException {
            int end = off + len;
            int empty = InputStreamWrapper.this.m_emptyOffset;
            byte[] buff = InputStreamWrapper.this.m_buffer;
            while (off < end) {
                int use;
                int avail = InputStreamWrapper.this.m_endOffset - empty;
                if (avail == 0) {
                    InputStreamWrapper.this.m_emptyOffset = empty;
                    if (InputStreamWrapper.this.fillBuffer()) {
                        empty = InputStreamWrapper.this.m_emptyOffset;
                        avail = InputStreamWrapper.this.m_endOffset - empty;
                    } else {
                        int actual = len + off - end;
                        return actual > 0 ? actual : -1;
                    }
                }
                if ((use = end - off) > avail) {
                    use = avail;
                }
                int limit = empty + use;
                while (empty < limit) {
                    b[off++] = (char)(buff[empty++] & 0xFF);
                }
            }
            InputStreamWrapper.this.m_emptyOffset = empty;
            return len;
        }

        public int read(char[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset && !InputStreamWrapper.this.fillBuffer()) {
                return -1;
            }
            return InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0xFF;
        }

        public boolean ready() throws IOException {
            return InputStreamWrapper.this.m_emptyOffset < InputStreamWrapper.this.m_endOffset;
        }
    }

    private class WrappedStreamUTF8Reader
    extends Reader {
        private WrappedStreamUTF8Reader() {
        }

        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        public int read(char[] b, int off, int len) throws IOException {
            int end = off + len;
            int empty = InputStreamWrapper.this.m_emptyOffset;
            byte[] buff = InputStreamWrapper.this.m_buffer;
            while (off < end) {
                byte byt;
                if (empty + 3 > InputStreamWrapper.this.m_endOffset) {
                    InputStreamWrapper.this.m_emptyOffset = empty;
                    InputStreamWrapper.this.fillBuffer();
                    empty = InputStreamWrapper.this.m_emptyOffset;
                    if (empty == InputStreamWrapper.this.m_endOffset) {
                        int actual = len + off - end;
                        return actual > 0 ? actual : -1;
                    }
                }
                if ((byt = buff[empty++]) >= 0) {
                    b[off++] = (char)byt;
                    if (byt != 0) continue;
                    System.err.println("Wrote null");
                    continue;
                }
                if ((byt & 0xE0) == 192) {
                    if (empty < InputStreamWrapper.this.m_endOffset) {
                        b[off++] = (char)(((byt & 0x1F) << 6) + (buff[empty++] & 0x3F));
                        if (b[off - 1] != '\u0000') continue;
                        System.err.println("Wrote null");
                        continue;
                    }
                    throw new IOException("UTF-8 conversion error");
                }
                if (empty + 1 < InputStreamWrapper.this.m_endOffset) {
                    int byt2 = buff[empty++] & 0x3F;
                    b[off++] = (char)((((byt & 0xF) << 6) + byt2 << 6) + (buff[empty++] & 0x3F));
                    if (b[off - 1] != '\u0000') continue;
                    System.err.println("Wrote null");
                    continue;
                }
                throw new IOException("UTF-8 conversion error");
            }
            InputStreamWrapper.this.m_emptyOffset = empty;
            return len;
        }

        public int read(char[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read() throws IOException {
            byte byt;
            if (InputStreamWrapper.this.m_emptyOffset + 3 > InputStreamWrapper.this.m_endOffset) {
                InputStreamWrapper.this.fillBuffer();
                if (InputStreamWrapper.this.m_emptyOffset == InputStreamWrapper.this.m_endOffset) {
                    return -1;
                }
            }
            if ((byt = InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++]) >= 0) {
                return byt & 0xFF;
            }
            if ((byt & 0xE0) == 192) {
                if (InputStreamWrapper.this.m_emptyOffset < InputStreamWrapper.this.m_endOffset) {
                    return ((byt & 0x1F) << 6) + (InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0x3F);
                }
                throw new IOException("UTF-8 conversion error");
            }
            if (InputStreamWrapper.this.m_emptyOffset + 1 < InputStreamWrapper.this.m_endOffset) {
                int byt2 = InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0xFF;
                return (((byt & 0xF) << 6) + byt2 << 6) + (InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++] & 0x3F);
            }
            throw new IOException("UTF-8 conversion error");
        }

        public boolean ready() throws IOException {
            return InputStreamWrapper.this.m_emptyOffset + 2 < InputStreamWrapper.this.m_endOffset;
        }
    }

    private class WrappedStream
    extends InputStream {
        private WrappedStream() {
        }

        public int available() throws IOException {
            return InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset + InputStreamWrapper.this.m_stream.available();
        }

        public void close() throws IOException {
            InputStreamWrapper.this.close();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int avail;
            int actual = 0;
            while (len > (avail = InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset)) {
                System.arraycopy(InputStreamWrapper.this.m_buffer, InputStreamWrapper.this.m_emptyOffset, b, off, avail);
                off += avail;
                len -= avail;
                actual += avail;
                InputStreamWrapper.this.m_emptyOffset = (InputStreamWrapper.this.m_endOffset = 0);
                if (InputStreamWrapper.this.fillBuffer()) continue;
                return actual == 0 ? -1 : actual;
            }
            System.arraycopy(InputStreamWrapper.this.m_buffer, InputStreamWrapper.this.m_emptyOffset, b, off, len);
            InputStreamWrapper.this.m_emptyOffset += len;
            return actual + len;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public long skip(long n) throws IOException {
            int avail = InputStreamWrapper.this.m_endOffset - InputStreamWrapper.this.m_emptyOffset;
            if (n >= (long)avail) {
                return (long)avail + InputStreamWrapper.this.m_stream.skip(n - (long)avail);
            }
            InputStreamWrapper.this.m_emptyOffset += (int)n;
            return n;
        }

        public int read() throws IOException {
            if (InputStreamWrapper.this.m_emptyOffset >= InputStreamWrapper.this.m_endOffset && !InputStreamWrapper.this.fillBuffer()) {
                return -1;
            }
            return InputStreamWrapper.this.m_buffer[InputStreamWrapper.this.m_emptyOffset++];
        }
    }
}

