/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.CompilationException;
import com.eteks.parser.CompiledFunction;
import com.eteks.parser.DefaultSyntax;
import com.eteks.parser.Function;
import com.eteks.parser.Parser;
import com.eteks.parser.Syntax;
import com.eteks.parser.node.BinaryOperatorNode;
import com.eteks.parser.node.CommonFunctionNode;
import com.eteks.parser.node.ConditionNode;
import com.eteks.parser.node.ConstantNode;
import com.eteks.parser.node.ExpressionNode;
import com.eteks.parser.node.FunctionNode;
import com.eteks.parser.node.FunctionParameterNode;
import com.eteks.parser.node.LiteralNode;
import com.eteks.parser.node.ParameterizedNode;
import com.eteks.parser.node.UnaryOperatorNode;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class FunctionParser
extends Parser {
    private static Syntax defaultSyntax;
    private Syntax syntax;
    protected static final int LEXICAL_VOID = 0;
    protected static final int LEXICAL_WHITE_SPACE = 1;
    protected static final int LEXICAL_LITERAL = 2;
    protected static final int LEXICAL_UNARY_OPERATOR = 3;
    protected static final int LEXICAL_BINARY_OPERATOR = 4;
    protected static final int LEXICAL_COMMON_FUNCTION = 5;
    protected static final int LEXICAL_OPENING_BRACKET = 6;
    protected static final int LEXICAL_CLOSING_BRACKET = 7;
    protected static final int LEXICAL_SYNONYMOUS_OPERATOR = 8;
    protected static final int LEXICAL_CONSTANT = 9;
    protected static final int LEXICAL_PARAMETER = 10;
    protected static final int LEXICAL_FUNCTION = 11;
    protected static final int LEXICAL_PARAMETER_SEPARATOR = 12;
    protected static final int LEXICAL_IF = 13;
    protected static final int LEXICAL_THEN = 14;
    protected static final int LEXICAL_ELSE = 15;
    private static final byte N_START = 0;
    private static final byte N_CL_BR = 1;
    private static final byte N_C_FCT = 2;
    private static final byte N_OP_IF = 3;
    private static final byte N_U_FCT = 4;
    private static final byte N_OP_BR = 5;
    private static final byte N_UN_OP = 6;
    private static final byte N_MULT = 7;
    private static final byte N_END = 8;
    private static final byte ADD_BINARY_OP = 1;
    private static final byte ADD_LITERAL = 2;
    private static final byte ADD_TERNARY_IF_LITERAL = 3;
    private static final byte ADD_MULT_LITERAL = 4;
    private static final byte ADD_COMMON_FCT = 5;
    private static final byte ADD_TERNARY_IF_COMMON_FCT = 6;
    private static final byte ADD_MULT_COMMON_FCT = 7;
    private static final byte ADD_CONSTANT = 8;
    private static final byte ADD_TERNARY_IF_CONSTANT = 9;
    private static final byte ADD_MULT_CONSTANT = 10;
    private static final byte ADD_PARAMETER = 11;
    private static final byte ADD_TERNARY_IF_PARAMETER = 12;
    private static final byte ADD_MULT_PARAMETER = 13;
    private static final byte ADD_USER_FCT = 14;
    private static final byte ADD_TERNARY_IF_USER_FCT = 15;
    private static final byte ADD_MULT_USER_FCT = 16;
    private static final byte ADD_OPEN_BRACKET = 17;
    private static final byte ADD_TERNARY_IF_OPEN_BRACKET = 18;
    private static final byte ADD_MULT_OPEN_BRACKET = 19;
    private static final byte CHECK_CLOSE_BRACKET = 20;
    private static final byte CHECK_OPEN_CLOSE_BRACKETS = 21;
    private static final byte CHECK_PARAMETER_SEPARATOR = 22;
    private static final byte ADD_UNARY_OP = 23;
    private static final byte ADD_TERNARY_IF_UNARY_OP = 24;
    private static final byte ADD_MULT_UNARY_OP = 25;
    private static final byte ADD_IF = 26;
    private static final byte CHECK_THEN = 27;
    private static final byte CHECK_ELSE = 28;
    private static final byte CHECK_END = 29;
    private static final byte[][] shortSyntaxGraph;
    private static final byte[][] syntaxGraph;
    private static final byte[][] transitionGraph;
    private static final int PRIORITY_USER_FUNCTION = -6;
    private static final int PRIORITY_OPENING_BRACKET = -5;
    private static final int PRIORITY_ELSE = -4;
    private static final int PRIORITY_THEN = -3;
    private static final int PRIORITY_IF = -2;
    private static final int PRIORITY_TERNARY_IF = -1;
    private static final int PRIORITY_COMMON_FUNCTION = 0x7FFFFFFD;
    private static final int PRIORITY_CLOSING_BRACKET = 0x7FFFFFFE;
    private static final int PRIORITY_OPERAND = Integer.MAX_VALUE;

    public FunctionParser() {
        if (defaultSyntax == null) {
            defaultSyntax = new DefaultSyntax();
        }
        this.syntax = defaultSyntax;
    }

    public FunctionParser(Syntax syntax) {
        this.syntax = syntax;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public CompiledFunction compileFunction(String string) throws CompilationException {
        if (this.syntax.getAssignmentOperator() == null || this.syntax.getAssignmentOperator().length() == 0) {
            throw new IllegalArgumentException("No assignment operator in syntax");
        }
        String string2 = this.parseFunctionName(string);
        String[] stringArray = this.parseFunctionParametersName(string, string2);
        CompiledFunction compiledFunction = new CompiledFunction(string, string2, stringArray, null);
        int n = string.indexOf(this.syntax.getAssignmentOperator());
        ExpressionNode expressionNode = (ExpressionNode)this.parseExpression(string, n + this.syntax.getAssignmentOperator().length(), compiledFunction);
        compiledFunction.setExpressionTree(expressionNode);
        return compiledFunction;
    }

    private String parseFunctionName(String string) throws CompilationException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(this.syntax.getWhiteSpaceCharacters() != null ? this.syntax.getWhiteSpaceCharacters() : "") + String.valueOf(this.syntax.getOpeningBracket()));
        if (!stringTokenizer.hasMoreTokens()) {
            throw new CompilationException(1, 0);
        }
        String string2 = stringTokenizer.nextToken();
        if (!this.syntax.isValidIdentifier(string2)) {
            throw new CompilationException(1, 0, string2);
        }
        if (this.isReservedWord(string2)) {
            throw new CompilationException(2, 0, string2);
        }
        if (this.syntax.getFunction(string2) != null) {
            throw new CompilationException(3, 0, string2);
        }
        return string2;
    }

    private String[] parseFunctionParametersName(String string, String string2) throws CompilationException {
        Vector<String> vector;
        String string3 = this.syntax.getWhiteSpaceCharacters() != null ? this.syntax.getWhiteSpaceCharacters() : "";
        int n = string.indexOf(string2) + string2.length();
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n), string3);
        if (!stringTokenizer.hasMoreTokens() || stringTokenizer.nextToken().indexOf(this.syntax.getOpeningBracket()) != 0) {
            throw new CompilationException(0, n);
        }
        int n2 = string.indexOf(this.syntax.getOpeningBracket());
        int n3 = string.indexOf(this.syntax.getClosingBracket(), n2 + 1);
        if (n3 == -1) {
            throw new CompilationException(4, n2 + 1);
        }
        stringTokenizer = new StringTokenizer(string.substring(n3 + 1), string3);
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().startsWith(this.syntax.getAssignmentOperator())) {
            throw new CompilationException(5, n3 + 1);
        }
        if (n2 + 1 == n3) {
            vector = new Vector<String>(0);
        } else {
            stringTokenizer = new StringTokenizer(string.substring(n2 + 1, n3), String.valueOf(string3) + (this.syntax.getParameterSeparator() != '\u0000' ? String.valueOf(this.syntax.getParameterSeparator()) : ""));
            if (!stringTokenizer.hasMoreTokens()) {
                vector = new Vector(0);
            } else {
                vector = new Vector(stringTokenizer.countTokens());
                int n4 = n2 + 1;
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!this.syntax.isValidIdentifier(string4)) {
                        throw new CompilationException(6, n4, string4);
                    }
                    if (this.isReservedWord(string4) || this.syntax.isShortSyntax() && (this.syntax.getFunction(string4) != null || FunctionParser.compare(string4, string2, this.syntax.isCaseSensitive()))) {
                        throw new CompilationException(2, n4, string4);
                    }
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        if (FunctionParser.compare(string4, (String)vector.elementAt(n6), this.syntax.isCaseSensitive())) {
                            throw new CompilationException(7, n4, string4);
                        }
                        ++n6;
                    }
                    vector.addElement(string4);
                    n4 = string.indexOf(this.syntax.getParameterSeparator(), n4) + 1;
                    ++n5;
                }
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Object parseExpression(String string, int n, Object object) throws CompilationException {
        ElemFct elemFct = (ElemFct)this.parseExpression(string, n, new StackFct(), object);
        return elemFct.expression;
    }

    protected boolean isReservedWord(String string) {
        return this.syntax.getLiteral(string, new StringBuffer()) != null || this.syntax.getConstantKey(string) != null || this.syntax.getUnaryOperatorKey(string) != null || this.syntax.getBinaryOperatorKey(string) != null || this.syntax.getConditionPartKey(string) != null || this.syntax.getCommonFunctionKey(string) != null;
    }

    protected static boolean compare(String string, String string2, boolean bl) {
        if (bl) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    protected Parser.Lexical getLexical(String string, int n, Object object) throws CompilationException {
        Object object2;
        Object object3;
        if (n >= string.length()) {
            return new Parser.Lexical(0, "", null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length() && this.syntax.getWhiteSpaceCharacters() != null && this.syntax.getWhiteSpaceCharacters().indexOf(string.charAt(n)) != -1) {
            stringBuffer.append(string.charAt(n++));
        }
        if (stringBuffer.length() > 0) {
            return new Parser.Lexical(1, stringBuffer.toString(), null);
        }
        char c = string.charAt(n);
        if (c == this.syntax.getOpeningBracket()) {
            return new Parser.Lexical(6, String.valueOf(c), null);
        }
        if (c == this.syntax.getClosingBracket()) {
            return new Parser.Lexical(7, String.valueOf(c), null);
        }
        if (c == this.syntax.getParameterSeparator()) {
            return new Parser.Lexical(12, String.valueOf(c), null);
        }
        String string2 = string.substring(n);
        Object object4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.syntax.getDelimiters());
        if (stringTokenizer.hasMoreTokens()) {
            object4 = stringTokenizer.nextToken();
        }
        if (object4 == null || !string2.startsWith((String)object4)) {
            object4 = null;
            int n2 = 0;
            while (n2 < string2.length()) {
                object3 = string2.substring(0, n2 + 1);
                if (this.syntax.getUnaryOperatorKey((String)object3) != null || this.syntax.getBinaryOperatorKey((String)object3) != null || this.syntax.getConditionPartKey((String)object3) != null) {
                    object4 = object3;
                }
                ++n2;
            }
            if (object4 == null) {
                throw new CompilationException(8, n);
            }
        } else {
            Object object5;
            if (object instanceof CompiledFunction) {
                object5 = ((CompiledFunction)object).getParameters();
                int n3 = 0;
                while (n3 < ((String[])object5).length) {
                    if (FunctionParser.compare((String)object4, object5[n3], this.syntax.isCaseSensitive())) {
                        return new Parser.Lexical(10, (String)object4, new Integer(n3));
                    }
                    ++n3;
                }
            }
            if ((object5 = this.syntax.getConstantKey((String)object4)) != null) {
                return new Parser.Lexical(9, (String)object4, object5);
            }
            object3 = this.syntax.getFunction((String)object4);
            if (object3 != null) {
                return new Parser.Lexical(11, (String)object4, object3);
            }
            if (object instanceof CompiledFunction && FunctionParser.compare((String)object4, ((CompiledFunction)object).getName(), this.syntax.isCaseSensitive())) {
                return new Parser.Lexical(11, (String)object4, object);
            }
            object5 = this.syntax.getCommonFunctionKey((String)object4);
            if (object5 != null) {
                return new Parser.Lexical(5, (String)object4, object5);
            }
        }
        if ((object2 = this.syntax.getUnaryOperatorKey((String)object4)) != null) {
            if (this.syntax.getBinaryOperatorKey((String)object4) != null) {
                return new Parser.Lexical(8, (String)object4, null);
            }
            return new Parser.Lexical(3, (String)object4, object2);
        }
        object2 = this.syntax.getBinaryOperatorKey((String)object4);
        if (object2 != null) {
            return new Parser.Lexical(4, (String)object4, object2);
        }
        object2 = this.syntax.getConditionPartKey((String)object4);
        if (object2 != null) {
            if (Syntax.CONDITION_IF.equals(object2)) {
                return new Parser.Lexical(13, (String)object4, object2);
            }
            if (Syntax.CONDITION_THEN.equals(object2)) {
                return new Parser.Lexical(14, (String)object4, object2);
            }
            if (Syntax.CONDITION_ELSE.equals(object2)) {
                return new Parser.Lexical(15, (String)object4, object2);
            }
        }
        if ((object3 = this.syntax.getLiteral(string2, stringBuffer)) != null) {
            return new Parser.Lexical(2, stringBuffer.toString(), object3);
        }
        throw new CompilationException(this.syntax.isValidIdentifier((String)object4) ? 10 : 8, n, (String)object4);
    }

    protected int getBoundNode(int n, Parser.Lexical lexical, int n2, Stack stack, Object object) throws CompilationException {
        int n3 = (this.syntax.isShortSyntax() ? shortSyntaxGraph : syntaxGraph)[lexical.getCode()][n];
        if (n3 == -1) {
            throw new CompilationException(8, n2);
        }
        this.executeTransition(transitionGraph[lexical.getCode()][n], n2, lexical, stack, object);
        return n3 == 8 ? Integer.MAX_VALUE : n3;
    }

    private void executeTransition(byte by, int n, Parser.Lexical lexical, Stack stack, Object object) throws CompilationException {
        switch (by) {
            case 1: {
                this.addBinaryOperator(lexical, stack);
                break;
            }
            case 2: {
                this.addLiteral(lexical, stack);
                break;
            }
            case 3: {
                this.addTernaryIf(stack);
                this.addLiteral(lexical, stack);
                break;
            }
            case 4: {
                this.addMultiply(stack);
                this.addLiteral(lexical, stack);
                break;
            }
            case 5: {
                this.addCommonFunction(lexical, stack);
                break;
            }
            case 6: {
                this.addTernaryIf(stack);
                this.addCommonFunction(lexical, stack);
                break;
            }
            case 7: {
                this.addMultiply(stack);
                this.addCommonFunction(lexical, stack);
                break;
            }
            case 8: {
                this.addConstant(lexical, stack);
                break;
            }
            case 9: {
                this.addTernaryIf(stack);
                this.addConstant(lexical, stack);
                break;
            }
            case 10: {
                this.addMultiply(stack);
                this.addConstant(lexical, stack);
                break;
            }
            case 11: {
                this.addParameter(n, lexical, stack, object);
                break;
            }
            case 12: {
                this.addTernaryIf(stack);
                this.addParameter(n, lexical, stack, object);
                break;
            }
            case 13: {
                this.addMultiply(stack);
                this.addParameter(n, lexical, stack, object);
                break;
            }
            case 14: {
                this.addFunction(lexical, stack, object);
                break;
            }
            case 15: {
                this.addTernaryIf(stack);
                this.addFunction(lexical, stack, object);
                break;
            }
            case 16: {
                this.addMultiply(stack);
                this.addFunction(lexical, stack, object);
                break;
            }
            case 17: {
                this.addOpeningBracket(stack);
                break;
            }
            case 18: {
                this.addTernaryIf(stack);
                this.addOpeningBracket(stack);
                break;
            }
            case 19: {
                this.addMultiply(stack);
                this.addOpeningBracket(stack);
                break;
            }
            case 20: {
                this.checkClosingBracket(n, stack);
                break;
            }
            case 21: {
                this.checkOpeningClosingBrackets(n, stack);
                break;
            }
            case 22: {
                this.checkParameterSeparator(n, stack);
                break;
            }
            case 23: {
                this.addUnaryOperator(lexical, stack);
                break;
            }
            case 25: {
                this.addMultiply(stack);
                this.addUnaryOperator(lexical, stack);
                break;
            }
            case 24: {
                this.addTernaryIf(stack);
                this.addUnaryOperator(lexical, stack);
                break;
            }
            case 26: {
                this.addIf(stack);
                break;
            }
            case 27: {
                this.checkThen(n, stack);
                break;
            }
            case 28: {
                this.checkElse(n, stack);
                break;
            }
            case 29: {
                this.checkEnd(n, stack);
                break;
            }
        }
    }

    private void addBinaryOperator(Parser.Lexical lexical, Stack stack) {
        Object object = lexical.getValue() != null ? lexical.getValue() : this.syntax.getBinaryOperatorKey(lexical.getExtractedString());
        this.addBinaryOperator(object, stack);
    }

    private void addBinaryOperator(Object object, Stack stack) {
        int n = this.syntax.getBinaryOperatorPriority(object);
        while (stack.size() > 1 && ((ElemFct)stack.elementAt((int)(stack.size() - 2))).priority >= n) {
            stack.pop();
        }
        ElemFct elemFct = (ElemFct)stack.peek();
        BinaryOperatorNode binaryOperatorNode = new BinaryOperatorNode(object);
        binaryOperatorNode.addParameter(elemFct.expression);
        elemFct.priority = n;
        elemFct.expression = binaryOperatorNode;
    }

    private void addLiteral(Parser.Lexical lexical, Stack stack) {
        LiteralNode literalNode = new LiteralNode(lexical.getValue());
        stack.push(new ElemFct(Integer.MAX_VALUE, literalNode));
    }

    private void addConstant(Parser.Lexical lexical, Stack stack) {
        ConstantNode constantNode = new ConstantNode(lexical.getValue());
        stack.push(new ElemFct(Integer.MAX_VALUE, constantNode));
    }

    private void addParameter(int n, Parser.Lexical lexical, Stack stack, Object object) throws CompilationException {
        ExpressionNode expressionNode = this.getParameterNode(lexical, object);
        if (expressionNode == null) {
            throw new CompilationException(10, n, lexical.getExtractedString());
        }
        stack.push(new ElemFct(Integer.MAX_VALUE, expressionNode));
    }

    protected ExpressionNode getParameterNode(Parser.Lexical lexical, Object object) {
        if (object instanceof CompiledFunction) {
            return new FunctionParameterNode((Integer)lexical.getValue());
        }
        return null;
    }

    private void addCommonFunction(Parser.Lexical lexical, Stack stack) {
        CommonFunctionNode commonFunctionNode = new CommonFunctionNode(lexical.getValue());
        stack.push(new ElemFct(0x7FFFFFFD, commonFunctionNode));
    }

    private void addOpeningBracket(Stack stack) {
        stack.push(new ElemFct(-5, null));
    }

    private void addUnaryOperator(Parser.Lexical lexical, Stack stack) {
        Object object = lexical.getValue() != null ? lexical.getValue() : this.syntax.getUnaryOperatorKey(lexical.getExtractedString());
        UnaryOperatorNode unaryOperatorNode = new UnaryOperatorNode(object);
        stack.push(new ElemFct(0x7FFFFFFD, unaryOperatorNode));
    }

    private void addMultiply(Stack stack) {
        if (!(stack.peek() instanceof BinaryOperatorNode)) {
            this.addBinaryOperator(Syntax.OPERATOR_MULTIPLY, stack);
        }
    }

    private void addFunction(Parser.Lexical lexical, Stack stack, Object object) {
        Function function;
        FunctionNode functionNode = new FunctionNode(function, (function = (Function)lexical.getValue()) == object);
        stack.push(new ElemFct(-6, functionNode));
    }

    /*
     * Unable to fully structure code
     */
    private void checkClosingBracket(int var1_1, Stack var2_2) throws CompilationException {
        var3_3 = null;
        if (true) ** GOTO lbl10
        do {
            if (var3_3.priority == -2) {
                throw new CompilationException(13, var1_1);
            }
            if (var3_3.priority == -3) {
                throw new CompilationException(14, var1_1);
            }
            var2_2.pop();
lbl10:
            // 2 sources

            if (var2_2.empty()) break;
            var3_3 = (ElemFct)var2_2.peek();
        } while (var3_3.priority > -5);
        if (var2_2.empty()) {
            throw new CompilationException(9, var1_1);
        }
        if (var3_3.priority == -6 && !(var4_4 = (FunctionNode)var3_3.expression).getFunction().isValidParameterCount(var4_4.getParameterCount())) {
            throw new CompilationException(11, var1_1);
        }
        var3_3.priority = 0x7FFFFFFE;
    }

    private void checkOpeningClosingBrackets(int n, Stack stack) throws CompilationException {
        ElemFct elemFct = (ElemFct)stack.peek();
        if (elemFct.priority != -6) {
            throw new CompilationException(8, n);
        }
        FunctionNode functionNode = (FunctionNode)elemFct.expression;
        if (!functionNode.getFunction().isValidParameterCount(functionNode.getParameterCount())) {
            throw new CompilationException(11, n);
        }
        elemFct.priority = 0x7FFFFFFE;
    }

    /*
     * Unable to fully structure code
     */
    private void checkParameterSeparator(int var1_1, Stack var2_2) throws CompilationException {
        var3_3 = null;
        if (true) ** GOTO lbl12
        do {
            if (var3_3.priority == -5) {
                throw new CompilationException(8, var1_1);
            }
            if (var3_3.priority == -2) {
                throw new CompilationException(13, var1_1);
            }
            if (var3_3.priority == -3) {
                throw new CompilationException(14, var1_1);
            }
            var2_2.pop();
lbl12:
            // 2 sources

            if (var2_2.empty()) break;
            var3_3 = (ElemFct)var2_2.peek();
        } while (var3_3.priority != -6);
        if (var2_2.empty()) {
            throw new CompilationException(8, var1_1);
        }
        var4_4 = (FunctionNode)var3_3.expression;
        if (var4_4.getFunction() instanceof CompiledFunction && ((CompiledFunction)var4_4.getFunction()).getParameterCount() <= var4_4.getParameterCount()) {
            throw new CompilationException(4, var1_1);
        }
    }

    private void addIf(Stack stack) {
        stack.push(new ElemFct(-2, new ConditionNode()));
    }

    /*
     * Unable to fully structure code
     */
    private void checkThen(int var1_1, Stack var2_2) throws CompilationException {
        var3_3 = null;
        if (true) ** GOTO lbl10
        do {
            if (var3_3.priority <= -5) {
                throw new CompilationException(8, var1_1);
            }
            if (var3_3.priority == -3) {
                throw new CompilationException(14, var1_1);
            }
            var2_2.pop();
lbl10:
            // 2 sources

            if (var2_2.empty()) break;
            var3_3 = (ElemFct)var2_2.peek();
        } while (var3_3.priority != -2 && var3_3.priority != -1);
        if (var2_2.empty()) {
            throw new CompilationException(15, var1_1);
        }
        if (var3_3.priority == -1) {
            var4_4 = new ConditionNode();
            var4_4.addParameter(var3_3.expression);
            var3_3.expression = var4_4;
        }
        var3_3.priority = -3;
    }

    /*
     * Unable to fully structure code
     */
    private void checkElse(int var1_1, Stack var2_2) throws CompilationException {
        var3_3 = null;
        if (true) ** GOTO lbl10
        do {
            if (var3_3.priority <= -5) {
                throw new CompilationException(8, var1_1);
            }
            if (var3_3.priority == -2) {
                throw new CompilationException(13, var1_1);
            }
            var2_2.pop();
lbl10:
            // 2 sources

            if (var2_2.empty()) break;
            var3_3 = (ElemFct)var2_2.peek();
        } while (var3_3.priority != -3);
        if (var2_2.empty()) {
            throw new CompilationException(16, var1_1);
        }
        var3_3.priority = -4;
    }

    /*
     * Unable to fully structure code
     */
    private void checkEnd(int var1_1, Stack var2_2) throws CompilationException {
        var3_3 = null;
        if (true) ** GOTO lbl10
        do {
            if (var3_3.priority == -2) {
                throw new CompilationException(13, var1_1);
            }
            if (var3_3.priority == -3) {
                throw new CompilationException(14, var1_1);
            }
            var2_2.pop();
lbl10:
            // 2 sources

            if (var2_2.empty()) break;
            var3_3 = (ElemFct)var2_2.peek();
        } while (var3_3.priority > -5);
        if (!var2_2.empty()) {
            throw new CompilationException(8, var1_1);
        }
        var2_2.push(var3_3);
    }

    private void addTernaryIf(Stack stack) {
        if (this.syntax.getConditionPartCount() == 2) {
            stack.push(new ElemFct(-1, null));
        }
    }

    static {
        byte[][] byArrayArray = new byte[16][];
        byArrayArray[0] = new byte[]{-1, 8, -1, -1, -1, -1, -1, 8};
        byte[] byArray = new byte[8];
        byArray[1] = 7;
        byArray[2] = 5;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArrayArray[1] = byArray;
        byArrayArray[2] = new byte[]{1, 1, -1, 1, -1, 1, 1, 1};
        byArrayArray[3] = new byte[]{6, -1, 6, 6, -1, 6, 6, 6};
        byArrayArray[4] = new byte[]{-1, 3, -1, -1, -1, -1, -1, 3};
        byArrayArray[5] = new byte[]{2, 2, -1, 2, -1, 2, 2, 2};
        byArrayArray[6] = new byte[]{5, 5, 5, 5, 5, 5, 5, 5};
        byArrayArray[7] = new byte[]{-1, 1, -1, -1, -1, 1, -1, 1};
        byArrayArray[8] = new byte[]{6, 3, 6, 6, -1, 6, 6, 3};
        byArrayArray[9] = new byte[]{1, 1, -1, 1, -1, 1, 1, 1};
        byArrayArray[10] = new byte[]{1, 1, -1, 1, -1, 1, 1, 1};
        byArrayArray[11] = new byte[]{4, 4, -1, 4, -1, 4, 4, 4};
        byte[] byArray2 = new byte[8];
        byArray2[0] = -1;
        byArray2[2] = -1;
        byArray2[3] = -1;
        byArray2[4] = -1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArrayArray[12] = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[1] = -1;
        byArray3[2] = -1;
        byArray3[3] = -1;
        byArray3[4] = -1;
        byArray3[6] = -1;
        byArray3[7] = -1;
        byArrayArray[13] = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = -1;
        byArray4[2] = -1;
        byArray4[3] = -1;
        byArray4[4] = -1;
        byArray4[5] = -1;
        byArray4[6] = -1;
        byArrayArray[14] = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = -1;
        byArray5[2] = -1;
        byArray5[3] = -1;
        byArray5[4] = -1;
        byArray5[5] = -1;
        byArray5[6] = -1;
        byArrayArray[15] = byArray5;
        shortSyntaxGraph = byArrayArray;
        byte[][] byArrayArray2 = new byte[16][];
        byArrayArray2[0] = new byte[]{-1, 8, -1, -1, -1, -1, -1};
        byte[] byArray6 = new byte[7];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[3] = 3;
        byArray6[4] = 4;
        byArray6[5] = 5;
        byArray6[6] = 6;
        byArrayArray2[1] = byArray6;
        byArrayArray2[2] = new byte[]{1, -1, -1, 1, -1, 1, 1};
        byArrayArray2[3] = new byte[]{6, -1, -1, 6, -1, 6, 6};
        byArrayArray2[4] = new byte[]{-1, 3, -1, -1, -1, -1, -1};
        byArrayArray2[5] = new byte[]{2, -1, -1, 2, -1, 2, 2};
        byArrayArray2[6] = new byte[]{5, -1, 5, 5, 5, 5, 5};
        byArrayArray2[7] = new byte[]{-1, 1, -1, -1, -1, 1, -1};
        byArrayArray2[8] = new byte[]{6, 3, -1, 6, -1, 6, 6};
        byArrayArray2[9] = new byte[]{1, -1, -1, 1, -1, 1, 1};
        byArrayArray2[10] = new byte[]{1, -1, -1, 1, -1, 1, 1};
        byArrayArray2[11] = new byte[]{4, -1, -1, 4, -1, 4, 4};
        byte[] byArray7 = new byte[7];
        byArray7[0] = -1;
        byArray7[2] = -1;
        byArray7[3] = -1;
        byArray7[4] = -1;
        byArray7[5] = -1;
        byArray7[6] = -1;
        byArrayArray2[12] = byArray7;
        byte[] byArray8 = new byte[7];
        byArray8[1] = -1;
        byArray8[2] = -1;
        byArray8[3] = -1;
        byArray8[4] = -1;
        byArray8[6] = -1;
        byArrayArray2[13] = byArray8;
        byte[] byArray9 = new byte[7];
        byArray9[0] = -1;
        byArray9[2] = -1;
        byArray9[3] = -1;
        byArray9[4] = -1;
        byArray9[5] = -1;
        byArray9[6] = -1;
        byArrayArray2[14] = byArray9;
        byte[] byArray10 = new byte[7];
        byArray10[0] = -1;
        byArray10[2] = -1;
        byArray10[3] = -1;
        byArray10[4] = -1;
        byArray10[5] = -1;
        byArray10[6] = -1;
        byArrayArray2[15] = byArray10;
        syntaxGraph = byArrayArray2;
        byte[][] byArrayArray3 = new byte[16][];
        byte[] byArray11 = new byte[8];
        byArray11[1] = 29;
        byArray11[7] = 29;
        byArrayArray3[0] = byArray11;
        byArrayArray3[1] = new byte[8];
        byte[] byArray12 = new byte[8];
        byArray12[0] = 3;
        byArray12[1] = 4;
        byArray12[2] = 2;
        byArray12[3] = 2;
        byArray12[5] = 3;
        byArray12[6] = 2;
        byArray12[7] = 4;
        byArrayArray3[2] = byArray12;
        byte[] byArray13 = new byte[8];
        byArray13[0] = 24;
        byArray13[2] = 23;
        byArray13[3] = 23;
        byArray13[5] = 24;
        byArray13[6] = 23;
        byArray13[7] = 25;
        byArrayArray3[3] = byArray13;
        byte[] byArray14 = new byte[8];
        byArray14[1] = 1;
        byArray14[7] = 1;
        byArrayArray3[4] = byArray14;
        byte[] byArray15 = new byte[8];
        byArray15[0] = 6;
        byArray15[1] = 7;
        byArray15[2] = 5;
        byArray15[3] = 5;
        byArray15[5] = 6;
        byArray15[6] = 5;
        byArray15[7] = 7;
        byArrayArray3[5] = byArray15;
        byte[] byArray16 = new byte[8];
        byArray16[0] = 18;
        byArray16[1] = 19;
        byArray16[2] = 17;
        byArray16[3] = 17;
        byArray16[5] = 18;
        byArray16[6] = 17;
        byArray16[7] = 19;
        byArrayArray3[6] = byArray16;
        byte[] byArray17 = new byte[8];
        byArray17[1] = 20;
        byArray17[5] = 21;
        byArray17[7] = 20;
        byArrayArray3[7] = byArray17;
        byte[] byArray18 = new byte[8];
        byArray18[0] = 24;
        byArray18[1] = 1;
        byArray18[2] = 23;
        byArray18[3] = 23;
        byArray18[5] = 24;
        byArray18[6] = 23;
        byArray18[7] = 1;
        byArrayArray3[8] = byArray18;
        byte[] byArray19 = new byte[8];
        byArray19[0] = 9;
        byArray19[1] = 10;
        byArray19[2] = 8;
        byArray19[3] = 8;
        byArray19[5] = 9;
        byArray19[6] = 8;
        byArray19[7] = 10;
        byArrayArray3[9] = byArray19;
        byte[] byArray20 = new byte[8];
        byArray20[0] = 12;
        byArray20[1] = 13;
        byArray20[2] = 11;
        byArray20[3] = 11;
        byArray20[5] = 12;
        byArray20[6] = 11;
        byArray20[7] = 13;
        byArrayArray3[10] = byArray20;
        byte[] byArray21 = new byte[8];
        byArray21[0] = 15;
        byArray21[1] = 16;
        byArray21[2] = 14;
        byArray21[3] = 14;
        byArray21[5] = 15;
        byArray21[6] = 14;
        byArray21[7] = 16;
        byArrayArray3[11] = byArray21;
        byte[] byArray22 = new byte[8];
        byArray22[1] = 22;
        byArray22[7] = 22;
        byArrayArray3[12] = byArray22;
        byte[] byArray23 = new byte[8];
        byArray23[0] = 26;
        byArray23[5] = 26;
        byArrayArray3[13] = byArray23;
        byte[] byArray24 = new byte[8];
        byArray24[1] = 27;
        byArray24[7] = 27;
        byArrayArray3[14] = byArray24;
        byte[] byArray25 = new byte[8];
        byArray25[1] = 28;
        byArray25[7] = 28;
        byArrayArray3[15] = byArray25;
        transitionGraph = byArrayArray3;
    }

    private static class ElemFct {
        int priority;
        ExpressionNode expression;

        public ElemFct(int n, ExpressionNode expressionNode) {
            this.priority = n;
            this.expression = expressionNode;
        }
    }

    private static class StackFct
    extends Stack {
        public Object pop() {
            ElemFct elemFct = (ElemFct)super.pop();
            if (!this.empty() && elemFct.expression != null) {
                ElemFct elemFct2 = (ElemFct)this.peek();
                if (elemFct2.expression instanceof ParameterizedNode) {
                    ((ParameterizedNode)elemFct2.expression).addParameter(elemFct.expression);
                } else {
                    elemFct2.expression = elemFct.expression;
                }
            }
            return elemFct;
        }

        StackFct() {
        }
    }
}

