/*
 * Decompiled with CFR 0.152.
 */
package com.rits.cloning;

import com.rits.cloning.CloningException;
import com.rits.cloning.FastClonerArrayList;
import com.rits.cloning.FastClonerCalendar;
import com.rits.cloning.FastClonerConcurrentHashMap;
import com.rits.cloning.FastClonerHashMap;
import com.rits.cloning.FastClonerHashSet;
import com.rits.cloning.FastClonerLinkedList;
import com.rits.cloning.FastClonerTreeMap;
import com.rits.cloning.IFastCloner;
import com.rits.cloning.IFreezable;
import com.rits.cloning.Immutable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cloner {
    private final Objenesis objenesis;
    private final Set<Class<?>> ignored = new HashSet();
    private final Set<Class<?>> nullInstead = new HashSet();
    private final Map<Class<?>, IFastCloner> fastCloners = new HashMap();
    private final Map<Object, Boolean> ignoredInstances = new IdentityHashMap<Object, Boolean>();
    private final ConcurrentHashMap<Class<?>, List<Field>> fieldsCache = new ConcurrentHashMap();
    private boolean dumpClonedClasses = false;
    private boolean cloningEnabled = true;
    private boolean nullTransient = false;
    private boolean cloneSynthetics = true;
    private final ConcurrentHashMap<Class<?>, Boolean> immutables = new ConcurrentHashMap();

    public Cloner() {
        this.objenesis = new ObjenesisStd();
        this.init();
    }

    public Cloner(Objenesis objenesis) {
        this.objenesis = objenesis;
        this.init();
    }

    public boolean isNullTransient() {
        return this.nullTransient;
    }

    public void setNullTransient(boolean nullTransient) {
        this.nullTransient = nullTransient;
    }

    public void setCloneSynthetics(boolean cloneSynthetics) {
        this.cloneSynthetics = cloneSynthetics;
    }

    private void init() {
        this.registerKnownJdkImmutableClasses();
        this.registerKnownConstants();
        this.registerFastCloners();
    }

    protected void registerFastCloners() {
        this.fastCloners.put(GregorianCalendar.class, new FastClonerCalendar());
        this.fastCloners.put(ArrayList.class, new FastClonerArrayList());
        this.fastCloners.put(LinkedList.class, new FastClonerLinkedList());
        this.fastCloners.put(HashSet.class, new FastClonerHashSet());
        this.fastCloners.put(HashMap.class, new FastClonerHashMap());
        this.fastCloners.put(TreeMap.class, new FastClonerTreeMap());
        this.fastCloners.put(ConcurrentHashMap.class, new FastClonerConcurrentHashMap());
    }

    protected Object fastClone(Object o, Map<Object, Object> clones) throws IllegalAccessException {
        Class<?> c = o.getClass();
        IFastCloner fastCloner = this.fastCloners.get(c);
        if (fastCloner != null) {
            return fastCloner.clone(o, this, clones);
        }
        return null;
    }

    public void registerConstant(Object o) {
        this.ignoredInstances.put(o, true);
    }

    public void registerConstant(Class<?> c, String privateFieldName) {
        try {
            Field field = c.getDeclaredField(privateFieldName);
            field.setAccessible(true);
            Object v = field.get(null);
            this.ignoredInstances.put(v, true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void registerKnownJdkImmutableClasses() {
        this.registerImmutable(String.class);
        this.registerImmutable(Integer.class);
        this.registerImmutable(Long.class);
        this.registerImmutable(Boolean.class);
        this.registerImmutable(Class.class);
        this.registerImmutable(Float.class);
        this.registerImmutable(Double.class);
        this.registerImmutable(Character.class);
        this.registerImmutable(Byte.class);
        this.registerImmutable(Short.class);
        this.registerImmutable(Void.class);
        this.registerImmutable(BigDecimal.class);
        this.registerImmutable(BigInteger.class);
        this.registerImmutable(URI.class);
        this.registerImmutable(URL.class);
        this.registerImmutable(UUID.class);
        this.registerImmutable(Pattern.class);
    }

    protected void registerKnownConstants() {
        this.registerStaticFields(TreeSet.class, HashSet.class, HashMap.class, TreeMap.class);
    }

    public void registerStaticFields(Class<?> ... classes) {
        for (Class<?> c : classes) {
            List<Field> fields = this.allFields(c);
            for (Field field : fields) {
                int mods = field.getModifiers();
                if (!Modifier.isStatic(mods) || field.getType().isPrimitive()) continue;
                this.registerConstant(c, field.getName());
            }
        }
    }

    public void setExtraStaticFields(Set<Class<?>> set) {
        this.registerStaticFields((Class[])set.toArray());
    }

    public void dontClone(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignored.add(cl);
        }
    }

    public void nullInsteadOfClone(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.nullInstead.add(cl);
        }
    }

    public void setExtraNullInsteadOfClone(Set<Class<?>> set) {
        this.nullInstead.addAll(set);
    }

    public void registerImmutable(Class<?> ... c) {
        for (Class<?> cl : c) {
            this.ignored.add(cl);
        }
    }

    public void setExtraImmutables(Set<Class<?>> set) {
        this.ignored.addAll(set);
    }

    public void registerFastCloner(Class<?> c, IFastCloner fastCloner) {
        if (this.fastCloners.containsKey(c)) {
            throw new IllegalArgumentException(c + " already fast-cloned!");
        }
        this.fastCloners.put(c, fastCloner);
    }

    public <T> T newInstance(Class<T> c) {
        return (T)this.objenesis.newInstance(c);
    }

    public <T> T fastCloneOrNewInstance(Class<T> c) {
        try {
            Object fastClone = this.fastClone(c, null);
            if (fastClone != null) {
                return (T)fastClone;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return this.newInstance(c);
    }

    public <T> T deepClone(T o) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        if (this.dumpClonedClasses) {
            System.out.println("start>" + o.getClass());
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>(16);
        try {
            return this.cloneInternal(o, clones);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("error during cloning of " + o, e);
        }
    }

    public <T> T deepCloneDontCloneInstances(T o, Object ... dontCloneThese) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        if (this.dumpClonedClasses) {
            System.out.println("start>" + o.getClass());
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>(16);
        for (Object dc : dontCloneThese) {
            clones.put(dc, dc);
        }
        try {
            return this.cloneInternal(o, clones);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("error during cloning of " + o, e);
        }
    }

    public <T> T shallowClone(T o) {
        if (o == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return o;
        }
        try {
            return this.cloneInternal(o, null);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("error during cloning of " + o, e);
        }
    }

    private boolean isImmutable(Class<?> clz) {
        Boolean b = this.immutables.get(clz);
        if (b != null && b.booleanValue()) {
            return true;
        }
        for (Annotation annotation : clz.getDeclaredAnnotations()) {
            if (annotation.annotationType() != Immutable.class) continue;
            this.immutables.put(clz, Boolean.TRUE);
            return true;
        }
        for (Class<?> c = clz.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Annotation annotation : c.getDeclaredAnnotations()) {
                Immutable im;
                if (annotation.annotationType() != Immutable.class || !(im = (Immutable)annotation).subClass()) continue;
                this.immutables.put(clz, Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    public <T> T cloneInternal(T o, Map<Object, Object> clones) throws IllegalAccessException {
        Object clonedPreviously;
        IFreezable f;
        if (o == null) {
            return null;
        }
        if (o == this) {
            return null;
        }
        if (this.ignoredInstances.containsKey(o)) {
            return o;
        }
        Class<?> clz = o.getClass();
        if (clz.isEnum()) {
            return o;
        }
        if (this.nullInstead.contains(clz)) {
            return null;
        }
        if (this.ignored.contains(clz)) {
            return o;
        }
        if (this.isImmutable(clz)) {
            return o;
        }
        if (o instanceof IFreezable && (f = (IFreezable)o).isFrozen()) {
            return o;
        }
        Object object = clonedPreviously = clones != null ? clones.get(o) : null;
        if (clonedPreviously != null) {
            return (T)clonedPreviously;
        }
        Object fastClone = this.fastClone(o, clones);
        if (fastClone != null) {
            if (clones != null) {
                clones.put(o, fastClone);
            }
            return (T)fastClone;
        }
        if (this.dumpClonedClasses) {
            System.out.println("clone>" + clz);
        }
        if (clz.isArray()) {
            int length = Array.getLength(o);
            Object newInstance = Array.newInstance(clz.getComponentType(), length);
            clones.put(o, newInstance);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(o, i);
                Object clone = clones != null ? this.cloneInternal(v, clones) : v;
                Array.set(newInstance, i, clone);
            }
            return (T)newInstance;
        }
        Object newInstance = this.newInstance(clz);
        if (clones != null) {
            clones.put(o, newInstance);
        }
        List<Field> fields = this.allFields(clz);
        for (Field field : fields) {
            boolean shouldClone;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            if (this.nullTransient && Modifier.isTransient(modifiers)) {
                Class<?> type = field.getType();
                if (type.isPrimitive()) continue;
                field.set(newInstance, null);
                continue;
            }
            Object fieldObject = field.get(o);
            boolean bl = shouldClone = this.cloneSynthetics || !this.cloneSynthetics && !field.isSynthetic();
            Object fieldObjectClone = clones != null ? (shouldClone ? this.cloneInternal(fieldObject, clones) : fieldObject) : fieldObject;
            field.set(newInstance, fieldObjectClone);
            if (!this.dumpClonedClasses || fieldObjectClone == fieldObject) continue;
            System.out.println("cloned field>" + field + "  -- of class " + o.getClass());
        }
        return (T)newInstance;
    }

    public <T, E extends T> void copyPropertiesOfInheritedClass(T src, E dest) {
        if (src == null) {
            throw new IllegalArgumentException("src can't be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("dest can't be null");
        }
        Class<?> srcClz = src.getClass();
        Class<?> destClz = dest.getClass();
        if (srcClz.isArray()) {
            if (!destClz.isArray()) {
                throw new IllegalArgumentException("can't copy from array to non-array class " + destClz);
            }
            int length = Array.getLength(src);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(src, i);
                Array.set(dest, i, v);
            }
            return;
        }
        List<Field> fields = this.allFields(srcClz);
        List<Field> destFields = this.allFields(dest.getClass());
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object fieldObject = field.get(src);
                field.setAccessible(true);
                if (!destFields.contains(field)) continue;
                field.set(dest, fieldObject);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addAll(List<Field> l, Field[] fields) {
        for (Field field : fields) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            l.add(field);
        }
    }

    private List<Field> allFields(Class<?> c) {
        List<Field> l = this.fieldsCache.get(c);
        if (l == null) {
            l = new LinkedList<Field>();
            Field[] fields = c.getDeclaredFields();
            this.addAll(l, fields);
            Class<?> sc = c;
            while ((sc = sc.getSuperclass()) != Object.class && sc != null) {
                this.addAll(l, sc.getDeclaredFields());
            }
            this.fieldsCache.putIfAbsent(c, l);
        }
        return l;
    }

    public boolean isDumpClonedClasses() {
        return this.dumpClonedClasses;
    }

    public void setDumpClonedClasses(boolean dumpClonedClasses) {
        this.dumpClonedClasses = dumpClonedClasses;
    }

    public boolean isCloningEnabled() {
        return this.cloningEnabled;
    }

    public void setCloningEnabled(boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }
}

