/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.BipartiteGraph;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import edu.uci.ics.jung.graph.impl.HypergraphBPG;
import edu.uci.ics.jung.graph.impl.HypervertexBPG;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.Iterator;

public abstract class AbstractHyperUnitBPG
implements UserDataContainer {
    protected BipartiteVertex vertex;
    protected HypergraphBPG graph;

    public AbstractHyperUnitBPG() {
        this.vertex = new BipartiteVertex();
    }

    AbstractHyperUnitBPG(BipartiteVertex bpg, HypergraphBPG hypergraphBPG) {
        this.vertex = bpg;
        this.graph = hypergraphBPG;
    }

    protected BipartiteVertex underlying_vertex() {
        return this.vertex;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractHyperUnitBPG) {
            AbstractHyperUnitBPG hu = (AbstractHyperUnitBPG)o;
            return this.vertex.equals(hu.underlying_vertex());
        }
        if (o instanceof Vertex) {
            return this.vertex.equals(o);
        }
        return false;
    }

    public ArchetypeGraph getGraph() {
        return this.graph;
    }

    public void addUserDatum(Object key, Object datum, UserDataContainer.CopyAction copyAct) {
        this.vertex.addUserDatum(key, datum, copyAct);
    }

    public void importUserData(UserDataContainer udc) {
        this.vertex.importUserData(udc);
    }

    public Iterator getUserDatumKeyIterator() {
        return this.vertex.getUserDatumKeyIterator();
    }

    public UserDataContainer.CopyAction getUserDatumCopyAction(Object key) {
        return this.vertex.getUserDatumCopyAction(key);
    }

    public Object getUserDatum(Object key) {
        return this.vertex.getUserDatum(key);
    }

    public void setUserDatum(Object key, Object datum, UserDataContainer.CopyAction copyAct) {
        this.vertex.setUserDatum(key, datum, copyAct);
    }

    public Object removeUserDatum(Object key) {
        return this.vertex.removeUserDatum(key);
    }

    public boolean containsUserDatumKey(Object key) {
        return this.vertex.containsUserDatumKey(key);
    }

    protected void setGraph(HypergraphBPG hypergraphBPG) {
        this.graph = hypergraphBPG;
    }

    public void removeVertex(HypervertexBPG hv3) {
        Edge e = this.vertex.findEdge(hv3.underlying_vertex());
        BipartiteGraph bpg = (BipartiteGraph)hv3.underlying_vertex().getGraph();
        bpg.removeEdge(e);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

