/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeGraph;
import edu.uci.ics.jung.graph.impl.BipartiteGraph;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import edu.uci.ics.jung.graph.impl.HyperedgeBPG;
import edu.uci.ics.jung.graph.impl.HypervertexBPG;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class HypergraphBPG
extends AbstractArchetypeGraph
implements Hypergraph {
    protected BipartiteGraph bpg;
    public static final BipartiteGraph.Choice VERTEX = BipartiteGraph.CLASSA;
    public static final BipartiteGraph.Choice EDGE = BipartiteGraph.CLASSB;
    Map hypervertices;
    Map hyperedges;
    private Transformer vertexToHyperVertex;
    private Transformer vertexToHyperEdge;

    public HypergraphBPG() {
        this.initialize();
    }

    protected void initialize() {
        this.bpg = new BipartiteGraph();
        this.hyperedges = new HashMap();
        this.hypervertices = new HashMap();
        this.vertexToHyperVertex = new XToHyperX(this.hypervertices);
        this.vertexToHyperEdge = new XToHyperX(this.hyperedges);
        super.initialize();
    }

    public ArchetypeGraph newInstance() {
        return new HypergraphBPG();
    }

    public Hypervertex addVertex(Hypervertex v) {
        HypervertexBPG hv = (HypervertexBPG)v;
        this.bpg.addVertex(hv.underlying_vertex(), VERTEX);
        this.hypervertices.put(hv.underlying_vertex(), hv);
        hv.setGraph(this);
        this.mGraphListenerHandler.handleAdd(v);
        return v;
    }

    public Hyperedge addEdge(Hyperedge e) {
        HyperedgeBPG he = (HyperedgeBPG)e;
        this.bpg.addVertex(he.underlying_vertex(), EDGE);
        this.hyperedges.put(he.underlying_vertex(), he);
        he.setGraph(this);
        this.mGraphListenerHandler.handleAdd(e);
        return e;
    }

    public Set getVertices() {
        return new HashSet(this.hypervertices.values());
    }

    public Set getEdges() {
        return new HashSet(this.hyperedges.values());
    }

    public int numVertices() {
        return this.hypervertices.size();
    }

    public int numEdges() {
        return this.hyperedges.size();
    }

    public void removeVertex(Hypervertex v) {
        HypervertexBPG hv = (HypervertexBPG)v;
        this.hypervertices.remove(hv.underlying_vertex());
        this.bpg.removeVertex(hv.underlying_vertex());
        hv.setGraph(null);
        this.mGraphListenerHandler.handleRemove(v);
    }

    public void removeEdge(Hyperedge e) {
        HyperedgeBPG he = (HyperedgeBPG)e;
        this.hyperedges.remove(he.underlying_vertex());
        this.bpg.removeVertex(he.underlying_vertex());
        he.setGraph(null);
        this.mGraphListenerHandler.handleRemove(e);
    }

    public void addVertices(Set vertices) {
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            this.addVertex((HypervertexBPG)iter.next());
        }
    }

    public void addEdges(Set edges) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            this.addEdge((HyperedgeBPG)iter.next());
        }
    }

    public void removeVertices(Set vertices) {
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            HypervertexBPG v = (HypervertexBPG)iter.next();
            this.removeVertex(v);
        }
    }

    public void removeEdges(Set edges) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            HyperedgeBPG e = (HyperedgeBPG)iter.next();
            this.removeEdge(e);
        }
    }

    public void removeAllEdges() {
        this.removeEdges(new HashSet(this.hyperedges.values()));
    }

    public void removeAllVertices() {
        this.removeVertices(new HashSet(this.hypervertices.values()));
    }

    public ArchetypeGraph copy() {
        HypergraphBPG cln = (HypergraphBPG)this.newInstance();
        cln.bpg = (BipartiteGraph)this.bpg.copy();
        cln.updateHyperTable();
        return cln;
    }

    private void updateHyperTable() {
        Iterator iter = this.bpg.getAllVertices(VERTEX).iterator();
        while (iter.hasNext()) {
            BipartiteVertex bpv = (BipartiteVertex)iter.next();
            this.hypervertices.put(bpv, new HypervertexBPG(bpv, this));
        }
        iter = this.bpg.getAllVertices(EDGE).iterator();
        while (iter.hasNext()) {
            BipartiteVertex bpe = (BipartiteVertex)iter.next();
            this.hyperedges.put(bpe, new HyperedgeBPG(bpe, this));
        }
    }

    public void addUserDatum(Object key, Object datum, UserDataContainer.CopyAction copyAct) {
        this.bpg.addUserDatum(key, datum, copyAct);
    }

    public void importUserData(UserDataContainer udc) {
        this.bpg.importUserData(udc);
    }

    public Iterator getUserDatumKeyIterator() {
        return this.bpg.getUserDatumKeyIterator();
    }

    public UserDataContainer.CopyAction getUserDatumCopyAction(Object key) {
        return this.bpg.getUserDatumCopyAction(key);
    }

    public Object getUserDatum(Object key) {
        return this.bpg.getUserDatum(key);
    }

    public void setUserDatum(Object key, Object datum, UserDataContainer.CopyAction copyAct) {
        this.bpg.setUserDatum(key, datum, copyAct);
    }

    public Object removeUserDatum(Object key) {
        return this.bpg.removeUserDatum(key);
    }

    void addVertex_without_adding(HypervertexBPG hv) {
        this.hypervertices.put(hv.underlying_vertex(), hv);
        hv.setGraph(this);
    }

    public ArchetypeVertex getVertexCorrespondingTo(BipartiteVertex vertex2) {
        return (HypervertexBPG)this.hypervertices.get(vertex2);
    }

    public ArchetypeEdge getEdgeCorrespondingTo(BipartiteVertex vertex2) {
        return (HyperedgeBPG)this.hyperedges.get(vertex2);
    }

    Set translateUnderlyingVertices(Set vertices) {
        Collection translated = CollectionUtils.collect((Collection)vertices, (Transformer)this.vertexToHyperVertex);
        return new HashSet(translated);
    }

    Set translateUnderlyingEdges(Set vertices) {
        Collection translated = CollectionUtils.collect((Collection)vertices, (Transformer)this.vertexToHyperEdge);
        return new HashSet(translated);
    }

    public BipartiteGraph getBipartiteGraphEquivalent() {
        return (BipartiteGraph)this.bpg.copy();
    }

    private class XToHyperX
    implements Transformer {
        private Map map;

        XToHyperX(Map m) {
            this.map = m;
        }

        public Object transform(Object o) {
            return this.map.get(o);
        }
    }
}

