/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import edu.uci.ics.jung.graph.predicates.ParallelEdgePredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleDirectedSparseVertex
extends AbstractSparseVertex {
    private Map mPredsToInEdges;
    private Map mSuccsToOutEdges;

    public Set getPredecessors() {
        return Collections.unmodifiableSet(this.getPredsToInEdges().keySet());
    }

    public int numPredecessors() {
        return this.getPredecessors().size();
    }

    public Set getSuccessors() {
        return Collections.unmodifiableSet(this.getSuccsToOutEdges().keySet());
    }

    public int numSuccessors() {
        return this.getSuccessors().size();
    }

    public Set getInEdges() {
        return Collections.unmodifiableSet(new HashSet(this.getPredsToInEdges().values()));
    }

    public Set getOutEdges() {
        return Collections.unmodifiableSet(new HashSet(this.getSuccsToOutEdges().values()));
    }

    public int inDegree() {
        return this.getInEdges().size();
    }

    public int outDegree() {
        return this.getOutEdges().size();
    }

    public boolean isSuccessorOf(Vertex v) {
        return this.getPredsToInEdges().containsKey(v);
    }

    public boolean isPredecessorOf(Vertex v) {
        return this.getSuccsToOutEdges().containsKey(v);
    }

    public boolean isSource(Edge e) {
        if (e.getGraph() == this.getGraph()) {
            return this.equals(((DirectedEdge)e).getSource());
        }
        return false;
    }

    public boolean isDest(Edge e) {
        if (e.getGraph() == this.getGraph()) {
            return this.equals(((DirectedEdge)e).getDest());
        }
        return false;
    }

    public Edge findEdge(Vertex v) {
        return (Edge)this.getSuccsToOutEdges().get(v);
    }

    public Set findEdgeSet(Vertex v) {
        HashSet<Edge> s = new HashSet<Edge>();
        Edge e = this.findEdge(v);
        if (e != null) {
            s.add(e);
        }
        return Collections.unmodifiableSet(s);
    }

    protected Collection getNeighbors_internal() {
        HashSet neighbors = new HashSet();
        neighbors.addAll(this.getPredsToInEdges().keySet());
        neighbors.addAll(this.getSuccsToOutEdges().keySet());
        return neighbors;
    }

    protected Collection getEdges_internal() {
        HashSet edges = new HashSet();
        edges.addAll(this.getPredsToInEdges().values());
        edges.addAll(this.getSuccsToOutEdges().values());
        return edges;
    }

    protected void addNeighbor_internal(Edge e, Vertex v) {
        if (!(e instanceof DirectedEdge)) {
            throw new IllegalArgumentException("This vertex implementation only accepts directed edges");
        }
        if (ParallelEdgePredicate.getInstance().evaluate(e)) {
            throw new IllegalArgumentException("This vertex implementation does not support parallel edges");
        }
        DirectedEdge edge = (DirectedEdge)e;
        boolean added = false;
        if (this == edge.getSource()) {
            this.getSuccsToOutEdges().put(v, e);
            added = true;
        }
        if (this == edge.getDest()) {
            this.getPredsToInEdges().put(v, e);
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException("Internal error: this vertex is not incident to " + e);
        }
    }

    protected void removeNeighbor_internal(Edge e, Vertex v) {
        String error = "Internal error: edge " + e + " not incident to vertex ";
        if (this.getSuccsToOutEdges().containsKey(v) && v.isDest(e)) {
            if (this.getSuccsToOutEdges().remove(v) == null) {
                throw new FatalException(error + v);
            }
        } else if (this.getPredsToInEdges().containsKey(v) && v.isSource(e)) {
            if (this.getPredsToInEdges().remove(v) == null) {
                throw new FatalException(error + v);
            }
        } else {
            throw new FatalException(error + this);
        }
    }

    protected Map getPredsToInEdges() {
        if (this.mPredsToInEdges == null) {
            this.setPredsToInEdges(new HashMap(5));
        }
        return this.mPredsToInEdges;
    }

    protected void setPredsToInEdges(Map predsToInEdges) {
        this.mPredsToInEdges = predsToInEdges;
    }

    protected Map getSuccsToOutEdges() {
        if (this.mSuccsToOutEdges == null) {
            this.setSuccsToOutEdges(new HashMap(5));
        }
        return this.mSuccsToOutEdges;
    }

    protected void setSuccsToOutEdges(Map succsToOutEdges) {
        this.mSuccsToOutEdges = succsToOutEdges;
    }

    protected void initialize() {
        super.initialize();
        this.setPredsToInEdges(null);
        this.setSuccsToOutEdges(null);
    }
}

