/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.utils.ChangeEventSupport;
import edu.uci.ics.jung.utils.DefaultChangeEventSupport;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.StatusCallback;
import edu.uci.ics.jung.visualization.VisualizationModel;
import java.awt.Dimension;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultVisualizationModel
implements VisualizationModel,
ChangeEventSupport {
    ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected StatusCallback statusCallback;
    Thread relaxer;
    boolean manualSuspend;
    protected Layout layout;
    protected long relaxerThreadSleepTime = 100L;
    protected ChangeListener changeListener;
    public Object pauseObject = new String("PAUSE OBJECT");
    long[] relaxTimes = new long[5];
    long[] paintTimes = new long[5];
    int relaxIndex = 0;
    int paintIndex = 0;
    double paintfps;
    double relaxfps;
    boolean stop = false;
    boolean visRunnerIsRunning = false;

    public DefaultVisualizationModel(Layout layout) {
        this(layout, null);
    }

    public DefaultVisualizationModel(Layout layout, Dimension d) {
        if (this.changeListener == null) {
            this.changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    DefaultVisualizationModel.this.fireStateChanged();
                }
            };
        }
        this.setGraphLayout(layout, d);
        this.init();
    }

    public long getRelaxerThreadSleepTime() {
        return this.relaxerThreadSleepTime;
    }

    public void setRelaxerThreadSleepTime(long relaxerThreadSleepTime) {
        this.relaxerThreadSleepTime = relaxerThreadSleepTime;
    }

    public void setGraphLayout(Layout layout, Dimension viewSize) {
        if (this.layout != null && this.layout instanceof ChangeEventSupport) {
            ((ChangeEventSupport)((Object)this.layout)).removeChangeListener(this.changeListener);
        }
        if (viewSize == null) {
            viewSize = new Dimension(600, 600);
        }
        this.suspend();
        Dimension layoutSize = layout.getCurrentSize();
        if (layoutSize == null) {
            layout.initialize(viewSize);
        } else {
            layout.restart();
        }
        layoutSize = layout.getCurrentSize();
        this.layout = layout;
        if (this.layout instanceof ChangeEventSupport) {
            ((ChangeEventSupport)((Object)this.layout)).addChangeListener(this.changeListener);
        }
        this.prerelax();
        this.unsuspend();
    }

    public void setGraphLayout(Layout layout) {
        this.setGraphLayout(layout, null);
    }

    public Layout getGraphLayout() {
        return this.layout;
    }

    public synchronized void restartThreadOnly() {
        if (this.visRunnerIsRunning) {
            this.stop();
        }
        this.relaxer = new VisRunner();
        this.relaxer.setPriority(1);
        this.relaxer.start();
    }

    public synchronized void init() {
        if (this.visRunnerIsRunning) {
            this.stop();
        }
        this.prerelax();
        this.relaxer = new VisRunner();
        this.relaxer.start();
    }

    public synchronized void restart() {
        if (this.visRunnerIsRunning) {
            this.stop();
        }
        this.stop = false;
        this.layout.restart();
        this.init();
        this.fireStateChanged();
    }

    public void prerelax() {
        this.suspend();
        int i = 0;
        if (this.layout.isIncremental()) {
            long timeNow = System.currentTimeMillis();
            while (System.currentTimeMillis() - timeNow < 500L && !this.layout.incrementsAreDone()) {
                ++i;
                this.layout.advancePositions();
            }
        }
        this.unsuspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.pauseObject;
        synchronized (object) {
            this.pauseObject.notifyAll();
        }
    }

    public synchronized void suspend() {
        this.manualSuspend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsuspend() {
        this.manualSuspend = false;
        Object object = this.pauseObject;
        synchronized (object) {
            this.pauseObject.notifyAll();
        }
    }

    public boolean isVisRunnerRunning() {
        return this.visRunnerIsRunning;
    }

    protected double average(long[] paintTimes) {
        double l = 0.0;
        for (int i = 0; i < paintTimes.length; ++i) {
            l += (double)paintTimes[i];
        }
        return l / (double)paintTimes.length;
    }

    public void setTextCallback(StatusCallback scb) {
        this.statusCallback = scb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.manualSuspend = false;
        this.stop = true;
        try {
            this.relaxer.interrupt();
        }
        catch (Exception ex) {
            System.err.println("got " + ex);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object object = this.pauseObject;
        synchronized (object) {
            this.pauseObject.notifyAll();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    protected class VisRunner
    extends Thread {
        public VisRunner() {
            super("Relaxer Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DefaultVisualizationModel.this.visRunnerIsRunning = true;
            try {
                while (!DefaultVisualizationModel.this.layout.incrementsAreDone() && !DefaultVisualizationModel.this.stop) {
                    Object object = DefaultVisualizationModel.this.pauseObject;
                    synchronized (object) {
                        while (DefaultVisualizationModel.this.manualSuspend && !DefaultVisualizationModel.this.stop) {
                            try {
                                DefaultVisualizationModel.this.pauseObject.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    long start = System.currentTimeMillis();
                    DefaultVisualizationModel.this.layout.advancePositions();
                    long delta = System.currentTimeMillis() - start;
                    if (DefaultVisualizationModel.this.stop) {
                        return;
                    }
                    String status = DefaultVisualizationModel.this.layout.getStatus();
                    if (DefaultVisualizationModel.this.statusCallback != null && status != null) {
                        DefaultVisualizationModel.this.statusCallback.callBack(status);
                    }
                    if (DefaultVisualizationModel.this.stop) {
                        return;
                    }
                    DefaultVisualizationModel.this.relaxTimes[DefaultVisualizationModel.this.relaxIndex++] = delta;
                    DefaultVisualizationModel.this.relaxIndex %= DefaultVisualizationModel.this.relaxTimes.length;
                    DefaultVisualizationModel.this.relaxfps = DefaultVisualizationModel.this.average(DefaultVisualizationModel.this.relaxTimes);
                    if (DefaultVisualizationModel.this.stop) {
                        return;
                    }
                    DefaultVisualizationModel.this.fireStateChanged();
                    if (DefaultVisualizationModel.this.stop) {
                        return;
                    }
                    try {
                        VisRunner.sleep(DefaultVisualizationModel.this.relaxerThreadSleepTime);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            finally {
                DefaultVisualizationModel.this.visRunnerIsRunning = false;
            }
        }
    }
}

