/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunctionAdapter;
import edu.uci.ics.jung.utils.ChangeEventSupport;
import edu.uci.ics.jung.utils.DefaultChangeEventSupport;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.ClassicPickSupport;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.HasGraphLayout;
import edu.uci.ics.jung.visualization.HasShapeFunctions;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.MouseListenerTranslator;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.StatusCallback;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.transform.LayoutTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.Transformer;
import edu.uci.ics.jung.visualization.transform.ViewTransformer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections.Predicate;

public class VisualizationViewer
extends JPanel
implements Transformer,
LayoutTransformer,
ViewTransformer,
HasGraphLayout,
ChangeListener,
ChangeEventSupport {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected VisualizationModel model;
    protected Renderer renderer;
    protected ToolTipFunction toolTipFunction;
    protected Map renderingHints = new HashMap();
    protected PickSupport pickSupport;
    protected PickedState pickedState;
    protected ItemListener pickEventListener;
    protected BufferedImage offscreen;
    protected Graphics2D offscreenG2d;
    protected boolean doubleBuffered;
    protected MutableTransformer viewTransformer = new MutableAffineTransformer(new AffineTransform());
    protected MutableTransformer layoutTransformer = new MutableAffineTransformer(new AffineTransform());
    protected List preRenderers = new ArrayList();
    protected List postRenderers = new ArrayList();
    protected GraphMouse graphMouse;
    protected Map locationMap = new HashMap();
    long[] relaxTimes = new long[5];
    long[] paintTimes = new long[5];
    int relaxIndex = 0;
    int paintIndex = 0;
    double paintfps;
    double relaxfps;

    public VisualizationViewer(Layout layout, Renderer renderer) {
        this(new DefaultVisualizationModel(layout), renderer);
    }

    public VisualizationViewer(Layout layout, Renderer renderer, Dimension preferredSize) {
        this(new DefaultVisualizationModel(layout, preferredSize), renderer, preferredSize);
    }

    public VisualizationViewer(VisualizationModel model, Renderer renderer) {
        this(model, renderer, new Dimension(600, 600));
    }

    public VisualizationViewer(VisualizationModel model, Renderer renderer, Dimension preferredSize) {
        this.model = model;
        model.addChangeListener(this);
        this.setDoubleBuffered(false);
        this.addComponentListener(new VisualizationListener(this));
        this.setPickSupport(new ClassicPickSupport());
        this.setPickedState(new MultiPickedState());
        this.setRenderer(renderer);
        renderer.setPickedKey(this.pickedState);
        this.setPreferredSize(preferredSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.initMouseClicker();
        this.scaleToLayout(model.getGraphLayout().getCurrentSize());
        this.layoutTransformer.addChangeListener(this);
        this.viewTransformer.addChangeListener(this);
    }

    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    protected void checkOffscreenImage(Dimension d) {
        if (this.doubleBuffered && (this.offscreen == null || this.offscreen.getWidth() != d.width || this.offscreen.getHeight() != d.height)) {
            this.offscreen = new BufferedImage(d.width, d.height, 2);
            this.offscreenG2d = this.offscreen.createGraphics();
        }
    }

    public VisualizationModel getModel() {
        return this.model;
    }

    public void setModel(VisualizationModel model) {
        this.model = model;
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
        this.fireStateChanged();
    }

    protected void initMouseClicker() {
        this.setGraphMouse(new GraphMouseImpl());
    }

    public void setTextCallback(StatusCallback scb) {
        this.model.setTextCallback(scb);
    }

    public void setGraphMouse(GraphMouse graphMouse) {
        this.graphMouse = graphMouse;
        MouseListener[] ml = this.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (!(ml[i] instanceof GraphMouse)) continue;
            this.removeMouseListener(ml[i]);
        }
        MouseMotionListener[] mml = this.getMouseMotionListeners();
        for (int i = 0; i < mml.length; ++i) {
            if (!(mml[i] instanceof GraphMouse)) continue;
            this.removeMouseMotionListener(mml[i]);
        }
        MouseWheelListener[] mwl = this.getMouseWheelListeners();
        for (int i = 0; i < mwl.length; ++i) {
            if (!(mwl[i] instanceof GraphMouse)) continue;
            this.removeMouseWheelListener(mwl[i]);
        }
        this.addMouseListener(graphMouse);
        this.addMouseMotionListener(graphMouse);
        this.addMouseWheelListener(graphMouse);
    }

    public GraphMouse getGraphMouse() {
        return this.graphMouse;
    }

    public void setRenderer(Renderer r) {
        this.renderer = r;
        if (this.renderer instanceof PluggableRenderer) {
            PluggableRenderer pr = (PluggableRenderer)this.renderer;
            pr.setScreenDevice(this);
            pr.setViewTransformer(this.getViewTransformer());
            if (this.pickSupport instanceof ShapePickSupport) {
                ((ShapePickSupport)this.pickSupport).setHasShapes((HasShapeFunctions)((Object)this.renderer));
            }
        }
        r.setPickedKey(this.pickedState);
        this.repaint();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setGraphLayout(Layout layout) {
        this.setGraphLayout(layout, true);
    }

    public void setGraphLayout(Layout layout, boolean scaleToLayout) {
        Dimension viewSize = this.getSize();
        if (viewSize.width <= 0 || viewSize.height <= 0) {
            viewSize = this.getPreferredSize();
        }
        this.model.setGraphLayout(layout, viewSize);
        if (scaleToLayout) {
            this.scaleToLayout(layout.getCurrentSize());
        }
    }

    protected void scaleToLayout(Dimension layoutSize) {
        Dimension viewSize = this.getSize();
        if (viewSize.width == 0 || viewSize.height == 0) {
            viewSize = this.getPreferredSize();
        }
        float scalex = (float)viewSize.width / (float)layoutSize.width;
        float scaley = (float)viewSize.height / (float)layoutSize.height;
        float scale = 1.0f;
        scale = scalex - 1.0f < scaley - 1.0f ? scalex : scaley;
        this.viewTransformer.setScale(scale, scale, new Point2D.Float());
    }

    public Layout getGraphLayout() {
        return this.model.getGraphLayout();
    }

    public void addGraphMouseListener(GraphMouseListener gel) {
        this.addMouseListener(new MouseListenerTranslator(gel, this));
    }

    public synchronized void init() {
        this.model.init();
    }

    public synchronized void restart() {
        this.model.restart();
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.model.getGraphLayout().resize(this.getSize());
    }

    public void prerelax() {
        this.model.prerelax();
    }

    protected synchronized void start() {
        this.model.start();
    }

    public synchronized void suspend() {
        this.model.suspend();
    }

    public synchronized void unsuspend() {
        this.model.unsuspend();
    }

    public boolean isPicked(Vertex v) {
        return this.pickedState.isPicked(v);
    }

    public boolean isPicked(Edge e) {
        return this.pickedState.isPicked(e);
    }

    protected void pick(Vertex picked, boolean b) {
        this.pickedState.pick(picked, b);
    }

    public boolean isVisRunnerRunning() {
        return this.model.isVisRunnerRunning();
    }

    public void scale(double scalex, double scaley) {
        this.scale(scalex, scaley, null);
    }

    public void scale(double scalex, double scaley, Point2D from) {
        if (from == null) {
            from = this.getCenter();
        }
        this.viewTransformer.scale(scalex, scaley, from);
    }

    public void setScale(double scalex, double scaley) {
        this.setScale(scalex, scaley, null);
    }

    public void setScale(double scalex, double scaley, Point2D from) {
        this.viewTransformer.setScale(scalex, scaley, from);
    }

    public double getScaleX() {
        return this.viewTransformer.getScaleX();
    }

    public double getScaleY() {
        return this.viewTransformer.getScaleY();
    }

    public double getOffsetX() {
        return this.getTranslateX();
    }

    public double getTranslateX() {
        return this.viewTransformer.getTranslateX();
    }

    public double getOffsetY() {
        return this.getTranslateY();
    }

    public double getTranslateY() {
        return this.viewTransformer.getTranslateY();
    }

    public void setOffset(double offsetx, double offsety) {
        this.setTranslate(offsetx, offsety);
    }

    public void setTranslate(double tx, double ty) {
        this.viewTransformer.setTranslate(tx, ty);
    }

    public void translate(double tx, double ty) {
        this.viewTransformer.translate(tx, ty);
    }

    public Point2D inverseTransform(Point2D p) {
        return this.layoutTransformer.inverseTransform(this.inverseViewTransform(p));
    }

    public Point2D inverseViewTransform(Point2D p) {
        return this.viewTransformer.inverseTransform(p);
    }

    public Point2D inverseLayoutTransform(Point2D p) {
        return this.layoutTransformer.inverseTransform(p);
    }

    public Point2D transform(Point2D p) {
        return this.viewTransformer.transform(this.layoutTransform(p));
    }

    public Point2D viewTransform(Point2D p) {
        return this.viewTransformer.transform(p);
    }

    public Point2D layoutTransform(Point2D p) {
        return this.layoutTransformer.transform(p);
    }

    public void setViewTransformer(MutableTransformer transformer) {
        this.viewTransformer.removeChangeListener(this);
        this.viewTransformer = transformer;
        this.viewTransformer.addChangeListener(this);
        if (this.renderer instanceof PluggableRenderer) {
            ((PluggableRenderer)this.renderer).setViewTransformer(transformer);
        }
    }

    public void setLayoutTransformer(MutableTransformer transformer) {
        this.layoutTransformer.removeChangeListener(this);
        this.layoutTransformer = transformer;
        this.layoutTransformer.addChangeListener(this);
    }

    public MutableTransformer getViewTransformer() {
        return this.viewTransformer;
    }

    public MutableTransformer getLayoutTransformer() {
        return this.layoutTransformer;
    }

    public Map getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(Map renderingHints) {
        this.renderingHints = renderingHints;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.checkOffscreenImage(this.getSize());
        this.model.start();
        Graphics2D g2d = (Graphics2D)g;
        if (this.doubleBuffered) {
            this.renderGraph(this.offscreenG2d);
            g2d.drawImage(this.offscreen, null, 0, 0);
        } else {
            this.renderGraph(g2d);
        }
    }

    protected void renderGraph(Graphics2D g2d) {
        Iterator iter;
        Layout layout = this.model.getGraphLayout();
        g2d.setRenderingHints(this.renderingHints);
        long start = System.currentTimeMillis();
        Dimension d = this.getSize();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.viewTransformer.getTransform());
        g2d.setTransform(newXform);
        Iterator iterator = this.preRenderers.iterator();
        while (iterator.hasNext()) {
            Paintable paintable = (Paintable)iterator.next();
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        this.locationMap.clear();
        try {
            iter = layout.getGraph().getEdges().iterator();
            while (iter.hasNext()) {
                Point2D q;
                Edge e = (Edge)iter.next();
                Vertex v1 = (Vertex)e.getEndpoints().getFirst();
                Vertex v2 = (Vertex)e.getEndpoints().getSecond();
                Point2D p = (Point2D)this.locationMap.get(v1);
                if (p == null) {
                    p = layout.getLocation(v1);
                    p = this.layoutTransformer.transform(p);
                    this.locationMap.put(v1, p);
                }
                if ((q = (Point2D)this.locationMap.get(v2)) == null) {
                    q = layout.getLocation(v2);
                    q = this.layoutTransformer.transform(q);
                    this.locationMap.put(v2, q);
                }
                if (p == null || q == null) continue;
                this.renderer.paintEdge(g2d, e, (int)p.getX(), (int)p.getY(), (int)q.getX(), (int)q.getY());
            }
        }
        catch (ConcurrentModificationException cme) {
            this.repaint();
        }
        try {
            iter = layout.getGraph().getVertices().iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                Point2D p = (Point2D)this.locationMap.get(v);
                if (p == null) {
                    p = layout.getLocation(v);
                    p = this.layoutTransformer.transform(p);
                    this.locationMap.put(v, p);
                }
                if (p == null) continue;
                this.renderer.paintVertex(g2d, v, (int)p.getX(), (int)p.getY());
            }
        }
        catch (ConcurrentModificationException cme) {
            this.repaint();
        }
        long delta = System.currentTimeMillis() - start;
        this.paintTimes[this.paintIndex++] = delta;
        this.paintIndex %= this.paintTimes.length;
        this.paintfps = this.average(this.paintTimes);
        Iterator iterator2 = this.postRenderers.iterator();
        while (iterator2.hasNext()) {
            Paintable paintable = (Paintable)iterator2.next();
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        g2d.setTransform(oldXform);
    }

    protected double average(long[] paintTimes) {
        double l = 0.0;
        for (int i = 0; i < paintTimes.length; ++i) {
            l += (double)paintTimes[i];
        }
        return l / (double)paintTimes.length;
    }

    public synchronized void stop() {
        this.model.stop();
    }

    public void setToolTipListener(ToolTipListener listener) {
        if (listener instanceof ToolTipFunction) {
            this.setToolTipFunction((ToolTipFunction)listener);
        } else {
            this.setToolTipFunction(new ToolTipListenerWrapper(listener));
        }
    }

    public void setToolTipFunction(ToolTipFunction toolTipFunction) {
        this.toolTipFunction = toolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.toolTipFunction != null) {
            if (this.toolTipFunction instanceof ToolTipListenerWrapper) {
                return this.toolTipFunction.getToolTipText(event);
            }
            Point2D p = this.inverseViewTransform(event.getPoint());
            Vertex vertex = this.pickSupport.getVertex(p.getX(), p.getY());
            if (vertex != null && this.willRender(vertex)) {
                return this.toolTipFunction.getToolTipText(vertex);
            }
            Edge edge = this.pickSupport.getEdge(p.getX(), p.getY());
            if (edge != null && this.willRender(edge)) {
                return this.toolTipFunction.getToolTipText(edge);
            }
            return this.toolTipFunction.getToolTipText(event);
        }
        return super.getToolTipText(event);
    }

    private boolean willRender(Vertex v) {
        if (this.renderer instanceof PluggableRenderer) {
            Predicate vip = ((PluggableRenderer)this.renderer).getVertexIncludePredicate();
            return vip == null || vip.evaluate((Object)v);
        }
        return true;
    }

    private boolean willRender(Edge e) {
        if (this.renderer instanceof PluggableRenderer) {
            Predicate eip = ((PluggableRenderer)this.renderer).getEdgeIncludePredicate();
            Pair endpoints = e.getEndpoints();
            boolean edgeAnswer = eip == null || eip.evaluate((Object)e);
            boolean endpointAnswer = this.willRender((Vertex)endpoints.getFirst()) && this.willRender((Vertex)endpoints.getSecond());
            return edgeAnswer && endpointAnswer;
        }
        return true;
    }

    public void addPreRenderPaintable(Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList();
        }
        this.preRenderers.add(paintable);
    }

    public void removePreRenderPaintable(Paintable paintable) {
        if (this.preRenderers != null) {
            this.preRenderers.remove(paintable);
        }
    }

    public void addPostRenderPaintable(Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList();
        }
        this.postRenderers.add(paintable);
    }

    public void removePostRenderPaintable(Paintable paintable) {
        if (this.postRenderers != null) {
            this.postRenderers.remove(paintable);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    public PickedState getPickedState() {
        return this.pickedState;
    }

    public void setPickedState(PickedState pickedState) {
        if (this.pickEventListener != null && this.pickedState != null) {
            this.pickedState.removeItemListener(this.pickEventListener);
        }
        this.pickedState = pickedState;
        if (this.renderer != null) {
            this.renderer.setPickedKey(pickedState);
        }
        if (this.pickEventListener == null) {
            this.pickEventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    VisualizationViewer.this.repaint();
                }
            };
        }
        pickedState.addItemListener(this.pickEventListener);
    }

    public PickSupport getPickSupport() {
        return this.pickSupport;
    }

    public void setPickSupport(PickSupport pickSupport) {
        this.pickSupport = pickSupport;
        this.pickSupport.setHasGraphLayout(this);
        if (pickSupport instanceof ShapePickSupport && this.renderer instanceof HasShapeFunctions) {
            ((ShapePickSupport)pickSupport).setHasShapes((HasShapeFunctions)((Object)this.renderer));
            ((ShapePickSupport)pickSupport).setLayoutTransformer(this);
        }
    }

    public Point2D getCenter() {
        Dimension d = this.getSize();
        return new Point2D.Float(d.width / 2, d.height / 2);
    }

    protected final class GraphMouseImpl
    extends MouseAdapter
    implements GraphMouse {
        protected Vertex picked;

        protected GraphMouseImpl() {
        }

        public void mousePressed(MouseEvent e) {
            Point2D p = VisualizationViewer.this.inverseViewTransform(e.getPoint());
            Vertex v = VisualizationViewer.this.pickSupport.getVertex(p.getX(), p.getY());
            if (v == null) {
                return;
            }
            this.picked = v;
            VisualizationViewer.this.pick(this.picked, true);
            VisualizationViewer.this.model.getGraphLayout().forceMove(this.picked, p.getX(), p.getY());
            VisualizationViewer.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.picked == null) {
                return;
            }
            VisualizationViewer.this.pick(this.picked, false);
            this.picked = null;
            VisualizationViewer.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            if (this.picked == null) {
                return;
            }
            Point2D p = VisualizationViewer.this.inverseViewTransform(e.getPoint());
            VisualizationViewer.this.model.getGraphLayout().forceMove(this.picked, p.getX(), p.getY());
            VisualizationViewer.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }
    }

    public static interface GraphMouse
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener {
    }

    public static interface Paintable {
        public void paint(Graphics var1);

        public boolean useTransform();
    }

    protected static class ToolTipListenerWrapper
    extends ToolTipFunctionAdapter {
        ToolTipListener listener;

        public ToolTipListenerWrapper(ToolTipListener listener) {
            this.listener = listener;
        }

        public String getToolTipText(MouseEvent e) {
            return this.listener.getToolTipText(e);
        }
    }

    public static interface ToolTipListener {
        public String getToolTipText(MouseEvent var1);
    }

    protected class VisualizationListener
    extends ComponentAdapter {
        protected VisualizationViewer vv;

        public VisualizationListener(VisualizationViewer vv) {
            this.vv = vv;
        }

        public void componentResized(ComponentEvent e) {
            Dimension d = this.vv.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return;
            }
            VisualizationViewer.this.checkOffscreenImage(d);
            VisualizationViewer.this.repaint();
        }
    }
}

