/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.DefaultVertexIconFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.PickableVertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexIconAndShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.visualization.DefaultGraphLabelRenderer;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.FourPassImageShaper;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VertexImageShaperDemo
extends JApplet {
    Graph graph;
    VisualizationViewer vv;
    String[] iconNames = new String[]{"apple", "os", "x", "linux", "inputdevices", "wireless", "graphics3", "gamespcgames", "humor", "music", "privacy"};
    static /* synthetic */ Class class$samples$graph$VertexImageShaperDemo;

    public VertexImageShaperDemo() {
        this.graph = new DirectedSparseGraph();
        Vertex[] vertices = this.createVertices(11);
        HashMap<Vertex, String> map = new HashMap<Vertex, String>();
        for (int i = 0; i < vertices.length; ++i) {
            map.put(vertices[i], this.iconNames[i % this.iconNames.length]);
        }
        HashMap<Vertex, LayeredIcon> iconMap = new HashMap<Vertex, LayeredIcon>();
        for (int i = 0; i < vertices.length; ++i) {
            String name = "/topic" + this.iconNames[i] + ".gif";
            try {
                LayeredIcon icon = new LayeredIcon(new ImageIcon((class$samples$graph$VertexImageShaperDemo == null ? VertexImageShaperDemo.class$("samples.graph.VertexImageShaperDemo") : class$samples$graph$VertexImageShaperDemo).getResource(name)).getImage());
                iconMap.put(vertices[i], icon);
                continue;
            }
            catch (Exception ex) {
                System.err.println("You need slashdoticons.jar in your classpath to see the image " + name);
            }
        }
        this.createEdges(vertices);
        DemoRenderer pr = new DemoRenderer();
        VertexStringerImpl vertexStringerImpl = new VertexStringerImpl(map);
        pr.setVertexStringer(vertexStringerImpl);
        PickableVertexPaintFunction vpf = new PickableVertexPaintFunction(pr, Color.black, Color.white, Color.yellow);
        pr.setVertexPaintFunction(vpf);
        pr.setEdgePaintFunction(new PickableEdgePaintFunction(pr, Color.black, Color.cyan));
        pr.setGraphLabelRenderer(new DefaultGraphLabelRenderer(Color.cyan, Color.cyan));
        final DemoVertexImageShapeFunction vertexImagerAndShapeFunction = new DemoVertexImageShapeFunction(new EllipseVertexShapeFunction());
        vertexImagerAndShapeFunction.setIconMap(iconMap);
        pr.setVertexShapeFunction(vertexImagerAndShapeFunction);
        pr.setVertexIconFunction(vertexImagerAndShapeFunction);
        FRLayout layout = new FRLayout(this.graph);
        layout.setMaxIterations(100);
        this.vv = new VisualizationViewer(layout, (Renderer)pr, new Dimension(400, 400));
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        this.vv.setBackground(Color.white);
        PickedState ps = this.vv.getPickedState();
        ps.addItemListener(new PickWithIconListener(vertexImagerAndShapeFunction));
        this.vv.addPostRenderPaintable(new VisualizationViewer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "Thank You, slashdot.org, for the images!";

            public void paint(Graphics g) {
                Dimension d = VertexImageShaperDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 20);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(VertexImageShaperDemo.this.vv, 1.1f, VertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(VertexImageShaperDemo.this.vv, 0.9090909f, VertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JCheckBox shape = new JCheckBox("Shape");
        shape.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                vertexImagerAndShapeFunction.setShapeImages(e.getStateChange() == 1);
                VertexImageShaperDemo.this.vv.repaint();
            }
        });
        shape.setSelected(true);
        JCheckBox fill = new JCheckBox("Fill");
        fill.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                vertexImagerAndShapeFunction.setFillImages(e.getStateChange() == 1);
                VertexImageShaperDemo.this.vv.repaint();
            }
        });
        fill.setSelected(true);
        JCheckBox drawOutlines = new JCheckBox("Outline");
        drawOutlines.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                vertexImagerAndShapeFunction.setOutlineImages(e.getStateChange() == 1);
                VertexImageShaperDemo.this.vv.repaint();
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel labelFeatures = new JPanel(new GridLayout(1, 0));
        labelFeatures.setBorder(BorderFactory.createTitledBorder("Image Effects"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        labelFeatures.add(shape);
        labelFeatures.add(fill);
        labelFeatures.add(drawOutlines);
        controls.add(labelFeatures);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    private Vertex[] createVertices(int count) {
        Vertex[] v = new Vertex[count];
        for (int i = 0; i < count; ++i) {
            v[i] = this.graph.addVertex(new DirectedSparseVertex());
        }
        return v;
    }

    void createEdges(Vertex[] v) {
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[0]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[5], v[3]));
        this.graph.addEdge(new DirectedSparseEdge(v[2], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[8], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[7]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[9]));
        this.graph.addEdge(new DirectedSparseEdge(v[9], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[6]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[5], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[10]));
        this.graph.addEdge(new DirectedSparseEdge(v[10], v[4]));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new VertexImageShaperDemo());
        frame.pack();
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LayeredIcon
    extends ImageIcon {
        Set iconSet = new LinkedHashSet();

        public LayeredIcon(Image image) {
            super(image);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Dimension d = new Dimension(this.getIconWidth(), this.getIconHeight());
            Iterator iterator = this.iconSet.iterator();
            while (iterator.hasNext()) {
                Icon icon = (Icon)iterator.next();
                Dimension id = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                int dx = (d.width - id.width) / 2;
                int dy = (d.height - id.height) / 2;
                icon.paintIcon(c, g, x + dx, y + dy);
            }
        }

        public void add(Icon icon) {
            this.iconSet.add(icon);
        }

        public boolean remove(Icon icon) {
            return this.iconSet.remove(icon);
        }
    }

    public static class Checkmark
    implements Icon {
        GeneralPath path = new GeneralPath();
        AffineTransform highlight = AffineTransform.getTranslateInstance(-1.0, -1.0);
        AffineTransform lowlight = AffineTransform.getTranslateInstance(1.0, 1.0);
        AffineTransform shadow = AffineTransform.getTranslateInstance(2.0, 2.0);
        Color color;

        public Checkmark() {
            this(Color.green);
        }

        public Checkmark(Color color) {
            this.color = color;
            this.path.moveTo(10.0f, 17.0f);
            this.path.lineTo(13.0f, 20.0f);
            this.path.lineTo(20.0f, 13.0f);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Shape shape = AffineTransform.getTranslateInstance(x, y).createTransformedShape(this.path);
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(Collections.singletonMap(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2d.setStroke(new BasicStroke(4.0f));
            g2d.setColor(Color.darkGray);
            g2d.draw(this.shadow.createTransformedShape(shape));
            g2d.setColor(Color.black);
            g2d.draw(this.lowlight.createTransformedShape(shape));
            g2d.setColor(Color.white);
            g2d.draw(this.highlight.createTransformedShape(shape));
            g2d.setColor(this.color);
            g2d.draw(shape);
        }

        public int getIconWidth() {
            return 20;
        }

        public int getIconHeight() {
            return 20;
        }
    }

    class DemoRenderer
    extends PluggableRenderer {
        DemoRenderer() {
        }

        public void paintIconForVertex(Graphics g, Vertex v, int x, int y) {
            Icon icon;
            boolean outlineImages = false;
            if (this.vertexIconFunction instanceof DemoVertexImageShapeFunction) {
                outlineImages = ((DemoVertexImageShapeFunction)this.vertexIconFunction).isOutlineImages();
            }
            if ((icon = this.vertexIconFunction.getIcon(v)) == null || outlineImages) {
                Shape s = AffineTransform.getTranslateInstance(x, y).createTransformedShape(this.getVertexShapeFunction().getShape(v));
                this.paintShapeForVertex((Graphics2D)g, v, s);
            }
            if (icon != null) {
                int xLoc = x - icon.getIconWidth() / 2;
                int yLoc = y - icon.getIconHeight() / 2;
                icon.paintIcon(this.screenDevice, g, xLoc, yLoc);
            }
        }
    }

    public static class DemoVertexImageShapeFunction
    extends VertexIconAndShapeFunction {
        boolean shapeImages = true;
        boolean fillImages = true;
        boolean outlineImages = false;

        public DemoVertexImageShapeFunction(VertexShapeFunction delegate) {
            super(delegate);
        }

        public boolean isFillImages() {
            return this.fillImages;
        }

        public void setFillImages(boolean fillImages) {
            this.fillImages = fillImages;
        }

        public boolean isShapeImages() {
            return this.shapeImages;
        }

        public void setShapeImages(boolean shapeImages) {
            this.shapeMap.clear();
            this.shapeImages = shapeImages;
        }

        public boolean isOutlineImages() {
            return this.outlineImages;
        }

        public void setOutlineImages(boolean outlineImages) {
            this.outlineImages = outlineImages;
        }

        public Shape getShape(Vertex v) {
            Icon icon = (Icon)this.iconMap.get(v);
            if (icon != null && icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                Shape shape = (Shape)this.shapeMap.get(image);
                if (shape == null && (shape = this.shapeImages ? FourPassImageShaper.getShape(image, 30) : new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(null), image.getHeight(null))).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                    shape = transform.createTransformedShape(shape);
                    this.shapeMap.put(image, shape);
                }
                return shape;
            }
            return this.delegate.getShape(v);
        }

        public Icon getIcon(ArchetypeVertex v) {
            if (this.fillImages) {
                return (Icon)this.iconMap.get(v);
            }
            return null;
        }
    }

    public static class VertexStringerImpl
    implements VertexStringer {
        Map map = new HashMap();
        boolean enabled = true;

        public VertexStringerImpl(Map map) {
            this.map = map;
        }

        public String getLabel(ArchetypeVertex v) {
            if (this.isEnabled()) {
                return (String)this.map.get(v);
            }
            return "";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class PickWithIconListener
    implements ItemListener {
        DefaultVertexIconFunction imager;
        Icon checked;

        public PickWithIconListener(DefaultVertexIconFunction imager) {
            this.imager = imager;
            this.checked = new Checkmark();
        }

        public void itemStateChanged(ItemEvent e) {
            Vertex v;
            Icon icon;
            if (e.getItem() instanceof Vertex && (icon = this.imager.getIcon(v = (Vertex)e.getItem())) instanceof LayeredIcon) {
                if (e.getStateChange() == 1) {
                    ((LayeredIcon)icon).add(this.checked);
                } else {
                    ((LayeredIcon)icon).remove(this.checked);
                }
            }
        }
    }
}

