/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.analysisView;

import SocLab.GUI.analysisView.ActorActorPanel;
import SocLab.GUI.analysisView.MyTableModelSimple;
import SocLab.GUI.analysisView.RelationActorPanel;
import SocLab.GUI.analysisView.SignifiantStates;
import SocLab.core.OrgNew;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

class SignifiantStatesPanel
extends JPanel {
    private JTable actorIndicatorsTable;
    private JTable relationIndicatorsTable;
    private OrgNew orgNew;
    private SignifiantStates signifiantStates;

    SignifiantStatesPanel(OrgNew orgNew) {
        this.orgNew = orgNew;
        if (orgNew != null) {
            this.init();
        }
    }

    public void setOrgNew(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.removeAll();
        this.init();
    }

    private void init() {
        this.signifiantStates = new SignifiantStates(this.orgNew);
        this.actorIndicatorsTable = new JTable(new MyTableModelSimple(this.signifiantStates.actorIndicators, this.signifiantStates.actorIndicatorLabels));
        this.relationIndicatorsTable = new JTable(new MyTableModelSimple(this.signifiantStates.relationIndicators, this.signifiantStates.relationIndicatorLabels));
        this.setColumnSize(this.actorIndicatorsTable);
        JTabbedPane mainTabbedPane = new JTabbedPane();
        RelationActorPanel relationActorPanel = new RelationActorPanel(this.signifiantStates, this.orgNew);
        ActorActorPanel actorActorPanel = new ActorActorPanel(this.signifiantStates, this.orgNew);
        mainTabbedPane.add("Actor Indicator", new JScrollPane(this.actorIndicatorsTable));
        mainTabbedPane.add("Relation Indicator", new JScrollPane(this.relationIndicatorsTable));
        mainTabbedPane.add("Relation/Actor Indicator", new JScrollPane(relationActorPanel));
        mainTabbedPane.add("Actor/Actor Indicator", new JScrollPane(actorActorPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)mainTabbedPane, "Center");
    }

    public void setColumnSize(JTable table) {
        table.setAutoResizeMode(0);
        FontMetrics fm = table.getFontMetrics(table.getFont());
        int i = 0;
        while (i < table.getColumnCount()) {
            int size = fm.stringWidth(table.getColumnName(i));
            table.getColumnModel().getColumn(i).setPreferredWidth(size + 10);
            ++i;
        }
    }
}

