/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.desktop;

import SocLab.GUI.analysisView.GraphView;
import SocLab.GUI.analysisView.StateAnalysisSynthesisView;
import SocLab.GUI.analysisView.StructuralAnalysisView;
import SocLab.GUI.desktop.MyDesktopPane;
import SocLab.GUI.desktop.MyMenuBar;
import SocLab.GUI.desktop.OrgFileChooser;
import SocLab.GUI.desktop.PreviousSimulationsFileChooser;
import SocLab.GUI.evolLauncher.GraphicalEvolLauncher;
import SocLab.GUI.modelEditor.ModelDescFrame;
import SocLab.GUI.modelEditor.ModelEditor;
import SocLab.GUI.modelEditor.ParamsPanels.OrgParamTabbedPane;
import SocLab.GUI.sensiLauncher.GraphicalSensiLauncher;
import SocLab.GUI.sensiLauncher.SensitivityProgressBar;
import SocLab.GUI.simuLauncher.GraphicalSimuLauncher;
import SocLab.GUI.simuLauncher.SimulationProgressBar;
import SocLab.GUI.simuLauncher.simuResultSynth.SimuResulsSynthFrame;
import SocLab.GUI.simuLauncher.waitingWindows;
import SocLab.GUI.stateAnalysis.StateAnalysisFrame;
import SocLab.core.SocLabToolkit;
import controller.simuSynthesis.ControllerImpl;
import gui.synthesis.GuiImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayDeque;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceBottleGreenTheme;
import org.jvnet.substance.theme.SubstanceTheme;

public class DesktopFrame
extends JFrame {
    public static MyDesktopPane desktopPanel;
    public static MyMenuBar menuBar;
    public static ArrayDeque<String> fileTemp;
    static final Image soclabImage;
    private static final String smallIconPath;
    public static final ImageIcon modelEditorIcon;
    static final ImageIcon newModelIcon;
    static final ImageIcon openModelIcon;
    public static final ImageIcon saveModelIcon;
    static final ImageIcon saveAsModelIcon;
    static final ImageIcon closeModelIcon;
    public static final ImageIcon switchIcon;
    public static final ImageIcon statAnalysisIcon;
    public static final ImageIcon stateAnalysisIcon;
    public static final ImageIcon synthesisIcon;
    public static final ImageIcon numbersIcon;
    static final ImageIcon exitIcon;
    public static final ImageIcon okIcon;
    public static final ImageIcon cancelIcon;
    public static final ImageIcon addIcon;
    public static final ImageIcon delIcon;
    public static final ImageIcon editIcon;
    public static final ImageIcon addUserIcon;
    public static final ImageIcon delUserIcon;
    public static final ImageIcon runModelIcon;
    public static final ImageIcon effectIcon;
    public static final ImageIcon editOkIcon;
    public static final ImageIcon editCancelIcon;
    public static OrgFileChooser fileChooser;
    public static PreviousSimulationsFileChooser preSimFileChooser;
    public static ModelEditor modelEditor;
    public static OrgParamTabbedPane orgparm;
    public static ModelDescFrame modelDescEditor;
    public static StateAnalysisFrame stateInterpreter;
    public static StructuralAnalysisView structuralAnalysisView;
    public static GraphView graphView;
    public static StateAnalysisSynthesisView stateAnalysisSynthesisView;
    public static GraphicalSimuLauncher simuLauncher;
    public static ControllerImpl controllerSimulationSynthesis;
    public static GuiImpl guiSimulationSynthesis;
    public static GraphicalSensiLauncher sensiLauncher;
    static controller.sensitivity.ControllerImpl controllerSensitivitySynthesis;
    public static gui.sensitivity.GuiImpl guiSensitivitySynthesis;
    public static SimuResulsSynthFrame simuResult;
    public static GraphicalEvolLauncher evolLauncher;
    public static waitingWindows ww;
    public static SimulationProgressBar smb;
    public static SensitivityProgressBar spb;
    public static JLabel statusBar;

    static {
        fileTemp = new ArrayDeque();
        soclabImage = new ImageIcon(ClassLoader.getSystemResource("soclab.png")).getImage();
        smallIconPath = "icones16" + File.separatorChar;
        modelEditorIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "edit_group.png"));
        newModelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "filenew.png"));
        openModelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "fileopen.png"));
        saveModelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "filesave.png"));
        saveAsModelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "filesaveas.png"));
        closeModelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "fileclose.png"));
        switchIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "recur.png"));
        statAnalysisIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "tool1.png"));
        stateAnalysisIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "tool2.png"));
        synthesisIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "synthesis.png"));
        numbersIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "numbers.png"));
        exitIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "exit.png"));
        okIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "apply.png"));
        cancelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "cancel.png"));
        addIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "edit_add.png"));
        delIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "edit_remove.png"));
        editIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "edit.png"));
        addUserIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "add_user.png"));
        delUserIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "delete_user.png"));
        runModelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "next.png"));
        effectIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "effect.png"));
        editOkIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "edit_ok.png"));
        editCancelIcon = new ImageIcon(ClassLoader.getSystemResource(String.valueOf(smallIconPath) + "edit_cancel.png"));
    }

    private DesktopFrame(SocLabToolkit socLabToolkit) {
        this.setName("Desktop Frame");
        desktopPanel = new MyDesktopPane(this);
        statusBar = new JLabel("Welcome ...");
        menuBar = new MyMenuBar(this);
        this.setJMenuBar(menuBar);
        this.setIconImage(soclabImage);
        this.setMinimumSize(new Dimension(1224, 777));
        this.setLayout(new BorderLayout());
        fileChooser = new OrgFileChooser(this);
        preSimFileChooser = new PreviousSimulationsFileChooser(this);
        this.add(desktopPanel);
        this.add((Component)statusBar, "South");
        this.setEnabled(true);
        this.setTitle("SocLab - []");
        this.setDefaultCloseOperation(3);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public MyDesktopPane getDesktopPanel() {
        return desktopPanel;
    }

    public void setDesktopPanel(MyDesktopPane desktop) {
        desktopPanel = desktop;
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SubstanceLookAndFeel());
            SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)new SubstanceBottleGreenTheme());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        new DesktopFrame(new SocLabToolkit());
    }
}

