/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.desktop;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JDesktopPane;

public class MyDesktopPane
extends JDesktopPane {
    private DesktopFrame desktop;
    private BufferedImage image;
    private Font font = new Font("SansSerif", 2, 70);

    MyDesktopPane(DesktopFrame desktop) {
        this.desktop = desktop;
        Image i = DesktopFrame.soclabImage;
        this.image = new BufferedImage(i.getWidth(null), i.getHeight(null), 2);
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        g.drawImage(i, 0, 0, i.getWidth(null), i.getHeight(null), null);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension dim = this.getSize();
        int wi = this.image.getWidth(this);
        int hi = this.image.getHeight(this);
        int x = dim.width - wi;
        int y = dim.height - hi;
        g.setColor(this.getRootPane().getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        String msg = SwitchLanguages.MyDesktopPaneNoModel[SocLabToolkit.idLanguage];
        if (SocLabToolkit.currentOrgNew != null) {
            msg = SocLabToolkit.currentOrgNew.getName();
        }
        g2d.setColor(new Color(255, 255, 255, 75));
        g2d.setFont(this.font);
        Rectangle2D bounds = this.font.getStringBounds(msg, 0, msg.length(), ((Graphics2D)this.getGraphics()).getFontRenderContext());
        g2d.drawString(msg, new Double(((double)dim.width - bounds.getWidth()) / 2.0).intValue(), new Double(((double)dim.height + bounds.getHeight()) / 2.0).intValue());
        g2d.drawImage(this.image, x - 10, y - 10, wi, hi, null);
        super.paint(g);
    }

    public DesktopFrame getDesktop() {
        return this.desktop;
    }
}

