/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.evolLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.evolLauncher.paramsPanels.BIComponent;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EvolTEParams
extends JPanel {
    private static final long serialVersionUID = 1L;
    Graphics graph;
    BIComponent[] relationNameBICs;
    JPanel subPanel = new JPanel();
    JScrollPane scrollPane;
    JComboBox[] TEInputs;
    JComboBox[] TEBminInputs;
    JComboBox[] TEBmaxInputs;
    String[] TEChoices = new String[]{"-10", "-9", "-8", "-7", "-6", "-5", "-4", "-3", "-2", "-2", "-1", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};

    public EvolTEParams() {
        this.scrollPane = new JScrollPane(this.subPanel);
    }

    public void init() {
        this.subPanel.removeAll();
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        Font font = new Font("Times New Roman", 1, 16);
        FontMetrics fm = DesktopFrame.desktopPanel.getGraphics().getFontMetrics();
        int hauteur = fm.getHeight() + 2;
        int nbRelations = orgNew.getNbRelationsNew();
        GridBagLayout subPanelLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.subPanel.setLayout(subPanelLayout);
        int hauteurRel = hauteur;
        int maxStringWidth = new Double(Double.NEGATIVE_INFINITY).intValue();
        int i = 0;
        while (i < nbRelations) {
            Rectangle2D r = font.getStringBounds(rNames[i], 0, rNames[i].length(), ((Graphics2D)this.graph).getFontRenderContext());
            if (r.getWidth() + 3.0 > (double)maxStringWidth) {
                maxStringWidth = new Double(r.getWidth()).intValue() + 3;
            }
            ++i;
        }
        int largeurRel = maxStringWidth;
        this.relationNameBICs = new BIComponent[nbRelations];
        int i2 = 0;
        while (i2 < nbRelations) {
            BufferedImage bi = new BufferedImage(largeurRel, hauteurRel, 1);
            Graphics2D g = (Graphics2D)bi.getGraphics();
            g.setFont(font);
            g.setColor(new Color(242, 246, 251));
            g.fillRect(0, 0, largeurRel, hauteurRel);
            g.setColor(Color.black);
            g.drawString(String.valueOf(rNames[i2]) + ": ", 0, fm.getMaxAscent());
            this.relationNameBICs[i2] = new BIComponent(bi);
            ++i2;
        }
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        this.subPanel.add((Component)new Container(), c);
        ++c.gridx;
        this.subPanel.add((Component)new JLabel("TE init"), c);
        ++c.gridx;
        this.subPanel.add((Component)new JLabel("TE Bmin"), c);
        ++c.gridx;
        this.subPanel.add((Component)new JLabel("TE Bmax"), c);
        this.TEInputs = new JComboBox[nbRelations];
        this.TEBminInputs = new JComboBox[nbRelations];
        this.TEBmaxInputs = new JComboBox[nbRelations];
        i2 = 0;
        while (i2 < nbRelations) {
            c.gridx = 0;
            c.gridy = i2 + 1;
            this.subPanel.add((Component)this.relationNameBICs[i2], c);
            ++c.gridx;
            this.TEInputs[i2] = new JComboBox<String>(this.TEChoices);
            this.TEBminInputs[i2] = new JComboBox<String>(this.TEChoices);
            this.TEBmaxInputs[i2] = new JComboBox<String>(this.TEChoices);
            this.subPanel.add((Component)this.TEInputs[i2], c);
            ++c.gridx;
            this.subPanel.add((Component)this.TEBminInputs[i2], c);
            ++c.gridx;
            this.subPanel.add((Component)this.TEBmaxInputs[i2], c);
            this.TEInputs[i2].setPreferredSize(new Dimension(50, 20));
            this.TEInputs[i2].setEditable(true);
            this.TEBminInputs[i2].setPreferredSize(new Dimension(50, 20));
            this.TEBminInputs[i2].setEditable(true);
            this.TEBmaxInputs[i2].setPreferredSize(new Dimension(50, 20));
            this.TEBmaxInputs[i2].setEditable(true);
            ++i2;
        }
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)this.scrollPane, "Center");
    }

    public void updateParams(OrgNew orgNew) {
        String[] rNames = orgNew.getRelationsNewName();
        int relID = 0;
        while (relID < orgNew.getNbRelationsNew()) {
            double valMax;
            double val = Double.valueOf(this.TEInputs[relID].getSelectedItem().toString());
            double valMin = Double.valueOf(this.TEBminInputs[relID].getSelectedItem().toString());
            if (valMin > (valMax = Double.valueOf(this.TEBmaxInputs[relID].getSelectedItem().toString()).doubleValue())) {
                valMin = -10.0;
                valMax = 10.0;
                this.TEBminInputs[relID].setSelectedItem(valMin);
                this.TEBmaxInputs[relID].setSelectedItem(valMax);
            }
            if (val < valMin) {
                val = valMin;
                this.TEInputs[relID].setSelectedItem(val);
            }
            if (val > valMax) {
                val = valMax;
                this.TEInputs[relID].setSelectedItem(val);
            }
            orgNew.getRelationNew(rNames[relID]).getRPNInitial().setState(val);
            orgNew.getRelationNew(rNames[relID]).getRPNInitial().setLowerBound(valMin);
            orgNew.getRelationNew(rNames[relID]).getRPNInitial().setUpperBound(valMax);
            ++relID;
        }
    }

    public void reinitParams(OrgNew org) {
        Vector<RelationNew> relations = org.getRelationsNew();
        int relID = 0;
        while (relID < org.getNbRelationsNew()) {
            double val = Double.parseDouble((String)this.TEInputs[relID].getSelectedItem());
            relations.get(relID).getRPNCurrent().setState(val);
            ++relID;
        }
    }

    public void initValues(Graphics g) {
        this.graph = g;
        this.subPanel.removeAll();
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew != null) {
            String[] rNames = orgNew.getRelationsNewName();
            if (orgNew.getNbActorsNew() >= 2 && orgNew.getNbRelationsNew() >= 2) {
                this.init();
                int relID = 0;
                while (relID < orgNew.getNbRelationsNew()) {
                    boolean error = false;
                    String val = new String("" + orgNew.getRelationNew(rNames[relID]).getRPNInitial().getState());
                    String valMin = new String("" + orgNew.getRelationNew(rNames[relID]).getRPNInitial().getLowerBound());
                    String valMax = new String("" + orgNew.getRelationNew(rNames[relID]).getRPNInitial().getUpperBound());
                    if (Double.valueOf(valMin) > Double.valueOf(valMax)) {
                        valMin = "-10";
                        valMax = "10";
                        error = true;
                    }
                    if (Double.valueOf(val) < Double.valueOf(valMin)) {
                        val = valMin;
                        error = true;
                    }
                    if (Double.valueOf(val) > Double.valueOf(valMax)) {
                        val = valMax;
                        error = true;
                    }
                    this.TEInputs[relID].setSelectedItem(val);
                    this.TEBminInputs[relID].setSelectedItem(valMin);
                    this.TEBmaxInputs[relID].setSelectedItem(valMax);
                    if (error) {
                        SocLabToolkit.saveOrgNew();
                    }
                    ++relID;
                }
            }
        }
    }
}

