/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.desktop.MyDesktopPane;
import SocLab.GUI.modelEditor.CreateStructfromOrgFile;
import SocLab.GUI.modelEditor.ParamsPanels.OrgParamTabbedPane;
import SocLab.GUI.modelEditor.RelationDescEditor;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.tools.RTFReports;
import SocLab.tools.fileKit.OrgIOToolkit;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class ModelEditor
extends JInternalFrame {
    private JButton addRelation;
    private JButton renameRel;
    private JButton delRelation;
    private JButton editRel;
    private JButton help;
    private JButton close;
    private JButton parameters;
    private JButton editActDec;
    private JButton addActor;
    private JButton delActor;
    private JButton renameAct;
    private JButton apply;
    private JButton cancel;
    private JLabel actorLabel;
    private JLabel relationLabel;
    private JList listeRel;
    private JList listeAct;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane listeSplitPane;
    private JTextArea relDescText;
    private JTextArea actDescText;
    public static OrgNew orgTemp;
    public static JDesktopPane desktop;
    private String xmlTemp;

    public ModelEditor(JDesktopPane desktop) throws Exception {
        super("Model Editor", true, true, true, true);
        ModelEditor.desktop = desktop;
        this.xmlTemp = OrgIOToolkit.saveObjectNew(SocLabToolkit.currentOrgNew);
        orgTemp = CreateStructfromOrgFile.loadOrgNewStruct(this.xmlTemp);
        this.init();
        this.listeSplitPane.setResizeWeight(0.5);
        this.listeSplitPane.setOneTouchExpandable(true);
        this.listeSplitPane.setContinuousLayout(true);
        this.setName("Model Editor");
        this.setClosable(false);
        this.update();
    }

    private void init() {
        this.jPanel11 = new JPanel();
        this.listeSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listeRel = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.relDescText = new JTextArea();
        this.editRel = new JButton(DesktopFrame.editIcon);
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.listeAct = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.actDescText = new JTextArea();
        this.editActDec = new JButton(DesktopFrame.editIcon);
        this.actorLabel = new JLabel();
        this.relationLabel = new JLabel();
        this.parameters = new JButton(DesktopFrame.switchIcon);
        this.addActor = new JButton(DesktopFrame.addUserIcon);
        this.delActor = new JButton(DesktopFrame.delUserIcon);
        this.apply = new JButton(DesktopFrame.okIcon);
        this.cancel = new JButton(DesktopFrame.cancelIcon);
        this.renameAct = new JButton(DesktopFrame.switchIcon);
        this.addRelation = new JButton(DesktopFrame.addUserIcon);
        this.delRelation = new JButton(DesktopFrame.delUserIcon);
        this.help = new JButton(DesktopFrame.editIcon);
        this.renameRel = new JButton(DesktopFrame.switchIcon);
        this.close = new JButton(DesktopFrame.cancelIcon);
        this.listeRel.setModel(new DefaultListModel());
        this.listeAct.setModel(new DefaultListModel());
        this.listeSplitPane.setCursor(new Cursor(0));
        this.actDescText.setFont(new Font("Calibri", 0, 12));
        this.actDescText.setEditable(false);
        this.actDescText.setBackground(new Color(247, 242, 242));
        this.relDescText.setFont(new Font("Calibri", 0, 12));
        this.relDescText.setEditable(false);
        this.relDescText.setBackground(new Color(247, 242, 242));
        this.jScrollPane1.setViewportView(this.listeRel);
        this.relDescText.setColumns(20);
        this.relDescText.setRows(5);
        this.jScrollPane2.setViewportView(this.relDescText);
        this.editRel.setText("Edit");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.addRelation, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delRelation, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renameRel, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editRel, -2, 125, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 486, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 486, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 188, -2).addGap(19, 19, 19).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addRelation, -1, -1, Short.MAX_VALUE).addComponent(this.editRel).addComponent(this.delRelation, -1, -1, Short.MAX_VALUE).addComponent(this.renameRel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 251, -2)));
        this.listeSplitPane.setRightComponent(this.jPanel1);
        this.jScrollPane3.setViewportView(this.listeAct);
        this.actDescText.setColumns(20);
        this.actDescText.setRows(5);
        this.jScrollPane4.setViewportView(this.actDescText);
        this.editActDec.setText("Edit");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.addActor, -1, 102, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delActor, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renameAct, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editActDec, -2, 107, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(10, Short.MAX_VALUE).addComponent(this.jScrollPane4, -1, 439, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane3, -1, 439, Short.MAX_VALUE).addContainerGap(10, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -2, 188, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addActor).addComponent(this.editActDec).addComponent(this.renameAct).addComponent(this.delActor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 248, -2)));
        this.listeSplitPane.setLeftComponent(this.jPanel2);
        this.actorLabel.setFont(new Font("Tahoma", 1, 11));
        this.actorLabel.setText("Actors ");
        this.relationLabel.setFont(new Font("Tahoma", 1, 11));
        this.relationLabel.setText("Relations");
        this.parameters.setText("Parameters");
        this.parameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ModelEditor.this.parametres();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.addActor.setText("Add");
        this.addActor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.addActor();
            }
        });
        this.delActor.setText("Del");
        this.delActor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.delActor();
            }
        });
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ModelEditor.this.apply();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ModelEditor.this.cancelOrg();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.renameAct.setText("Rename");
        this.renameAct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.renameActor();
            }
        });
        this.addRelation.setText("Add");
        this.addRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.addRelation();
            }
        });
        this.delRelation.setText("Del");
        this.delRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.delRelation();
            }
        });
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.help();
            }
        });
        this.renameRel.setText("Rename");
        this.renameRel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.renameRelation();
            }
        });
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ModelEditor.this.closeOrg();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.editActDec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.editActDesc();
            }
        });
        this.editRel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelEditor.this.editRelDesc();
            }
        });
        this.listeAct.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModelEditor.this.showActDesc();
            }
        });
        this.listeRel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModelEditor.this.showRelDesc();
            }
        });
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.actorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 879, Short.MAX_VALUE).addComponent(this.relationLabel)).addGroup(jPanel11Layout.createSequentialGroup().addGap(130, 130, 130).addComponent(this.apply, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancel, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.close, -1, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parameters, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.help, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(this.listeSplitPane, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.actorLabel).addComponent(this.relationLabel)).addGap(6, 6, 6).addComponent(this.listeSplitPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.help, -2, 31, -2).addComponent(this.close, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.parameters, GroupLayout.Alignment.LEADING, -1, 31, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancel, -1, 31, Short.MAX_VALUE)).addComponent(this.apply, GroupLayout.Alignment.LEADING, -1, 31, Short.MAX_VALUE)).addGap(39, 39, 39))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel11, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(15, Short.MAX_VALUE).addComponent(this.jPanel11, -2, 579, -2).addGap(30, 30, 30)));
        this.pack();
    }

    protected void parametres() throws Exception {
        if (DesktopFrame.orgparm == null) {
            DesktopFrame.orgparm = new OrgParamTabbedPane(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.orgparm);
        }
        if (!DesktopFrame.orgparm.isVisible()) {
            DesktopFrame.desktopPanel.remove(DesktopFrame.orgparm);
            DesktopFrame.orgparm = new OrgParamTabbedPane(DesktopFrame.desktopPanel);
            DesktopFrame.desktopPanel.add(DesktopFrame.orgparm);
            OrgParamTabbedPane gui = DesktopFrame.orgparm;
            gui.setVisible(true);
            gui.moveToFront();
            DesktopFrame.statusBar.setText("Model Parameters ...");
        }
        this.dispose();
    }

    protected void editRelDesc() {
        if (this.canEdit() && this.listeRel.getSelectedIndex() > -1) {
            new RelationDescEditor((Frame)((MyDesktopPane)desktop).getDesktop(), orgTemp, this.listeRel.getSelectedValue().toString(), true);
        }
    }

    protected void showRelDesc() {
        if (this.listeRel.getSelectedIndex() > -1) {
            this.relDescText.setText("");
        }
        this.relDescText.setText(new RelationDescEditor((Frame)((MyDesktopPane)desktop).getDesktop(), orgTemp, this.listeRel.getSelectedValue().toString(), false).initValues());
    }

    protected void showActDesc() {
        this.actDescText.setText("");
        this.actDescText.setText(orgTemp.getActorNew(this.listeAct.getSelectedValue().toString()).getDescription());
    }

    protected void editActDesc() {
        if (this.canEdit()) {
            if (!this.actDescText.isEditable()) {
                this.editActDec.setText("Save");
                this.actDescText.setEditable(true);
                this.actDescText.setBackground(new Color(255, 255, 255));
            } else {
                this.editActDec.setText("Edit");
                String description = this.actDescText.getText();
                description = description.replace('<', '_');
                description = description.replace('>', '_');
                description = description.replace('\"', '_');
                orgTemp.getActorNew(this.listeAct.getSelectedValue().toString()).setDescription(description);
                this.actDescText.setEditable(false);
                this.actDescText.setBackground(new Color(247, 242, 242));
            }
        }
    }

    public void apply() throws Exception {
        if (orgTemp != null && this.canEdit()) {
            this.xmlTemp = OrgIOToolkit.saveObjectNew(orgTemp);
            SocLabToolkit.currentOrgNew = CreateStructfromOrgFile.loadOrgNewStruct(this.xmlTemp);
        }
    }

    public void update() throws Exception {
        if (orgTemp != null) {
            ((DefaultListModel)this.listeRel.getModel()).removeAllElements();
            ((DefaultListModel)this.listeAct.getModel()).removeAllElements();
            LinkedList<String> listAct = new LinkedList<String>(Arrays.asList(orgTemp.getActorsNewName()));
            LinkedList<String> listRele = new LinkedList<String>(Arrays.asList(orgTemp.getRelationsNewName()));
            for (String i : listAct) {
                ((DefaultListModel)this.listeAct.getModel()).addElement(i);
            }
            for (String i : listRele) {
                ((DefaultListModel)this.listeRel.getModel()).addElement(i);
            }
        }
    }

    private void delRelation() {
        if (this.listeRel.getSelectedIndex() >= 0 && this.canEdit()) {
            if (orgTemp != null) {
                int relIndex = this.listeRel.getSelectedIndex();
                String relationNewName = this.listeRel.getSelectedValue().toString();
                orgTemp.delRelationNew(relationNewName);
                ((DefaultListModel)this.listeRel.getModel()).removeElementAt(relIndex);
                this.listeRel.setSelectedIndex(((DefaultListModel)this.listeRel.getModel()).getSize() - 1);
            }
            this.relDescText.setText("");
        }
    }

    private void renameRelation() {
        if (this.listeRel.getSelectedIndex() >= 0 && this.canEdit()) {
            String old_name = this.listeRel.getSelectedValue().toString();
            String new_name = this.renameOrAdd();
            if (new_name != null && !new_name.equals("")) {
                new_name = new_name.replace('<', '_');
                new_name = new_name.replace('>', '_');
                new_name = new_name.replace('\"', '_');
                new_name = new_name.replace('-', '_');
                new_name = new_name.replace('.', '_');
                if (orgTemp != null) {
                    int relIndex = this.listeRel.getSelectedIndex();
                    orgTemp.renameRelationNew(old_name, new_name);
                    ((DefaultListModel)this.listeRel.getModel()).removeElementAt(relIndex);
                    ((DefaultListModel)this.listeRel.getModel()).insertElementAt(new_name, relIndex);
                    this.listeRel.setSelectedIndex(((DefaultListModel)this.listeRel.getModel()).getSize() - 1);
                }
            }
        }
    }

    private void addRelation() {
        String relationNewName;
        if (orgTemp != null && this.canEdit() && (relationNewName = this.renameOrAdd()) != null && !relationNewName.equals("")) {
            relationNewName = relationNewName.replace('<', '_');
            relationNewName = relationNewName.replace('>', '_');
            relationNewName = relationNewName.replace('\"', '_');
            relationNewName = relationNewName.replace('-', '_');
            relationNewName = relationNewName.replace('.', '_');
            if (!((DefaultListModel)this.listeRel.getModel()).contains(relationNewName)) {
                orgTemp.addRelationNew(relationNewName, "");
                ((DefaultListModel)this.listeRel.getModel()).addElement(relationNewName);
                this.listeRel.setSelectedIndex(((DefaultListModel)this.listeRel.getModel()).getSize() - 1);
            }
            this.relDescText.setText("");
        }
    }

    private void delActor() {
        if (this.listeAct.getSelectedIndex() >= 0 && this.canEdit()) {
            if (orgTemp != null) {
                int actorIndex = this.listeAct.getSelectedIndex();
                String actorNewName = this.listeAct.getSelectedValue().toString();
                orgTemp.delActorNew(actorNewName);
                ((DefaultListModel)this.listeAct.getModel()).removeElementAt(actorIndex);
                this.listeAct.setSelectedIndex(((DefaultListModel)this.listeAct.getModel()).getSize() - 1);
            }
            this.actDescText.setText("");
        }
    }

    private void renameActor() {
        if (this.listeAct.getSelectedIndex() >= 0 && this.canEdit()) {
            String old_name = this.listeAct.getSelectedValue().toString();
            String new_name = this.renameOrAdd();
            if (new_name != null && !new_name.equals("")) {
                new_name = new_name.replace('<', '_');
                new_name = new_name.replace('>', '_');
                new_name = new_name.replace('\"', '_');
                new_name = new_name.replace('-', '_');
                new_name = new_name.replace('.', '_');
                if (orgTemp != null) {
                    int actorIndex = this.listeAct.getSelectedIndex();
                    orgTemp.renameActorNew(old_name, new_name);
                    ((DefaultListModel)this.listeAct.getModel()).removeElementAt(actorIndex);
                    ((DefaultListModel)this.listeAct.getModel()).insertElementAt(new_name, actorIndex);
                    this.listeAct.setSelectedIndex(((DefaultListModel)this.listeAct.getModel()).getSize() - 1);
                    if (orgTemp.getNbActorsNew() >= 2) {
                        orgTemp.getNbRelationsNew();
                    }
                }
            }
        }
    }

    private void addActor() {
        String actorNewName;
        if (orgTemp != null && this.canEdit() && (actorNewName = this.renameOrAdd()) != null && !actorNewName.equals("")) {
            actorNewName = actorNewName.replace('<', '_');
            actorNewName = actorNewName.replace('>', '_');
            actorNewName = actorNewName.replace('\"', '_');
            actorNewName = actorNewName.replace('-', '_');
            actorNewName = actorNewName.replace('.', '_');
            if (!((DefaultListModel)this.listeAct.getModel()).contains(actorNewName)) {
                orgTemp.addActorNew(actorNewName, "", orgTemp);
                ((DefaultListModel)this.listeAct.getModel()).addElement(actorNewName);
                this.listeAct.setSelectedIndex(((DefaultListModel)this.listeAct.getModel()).getSize() - 1);
            }
            this.actDescText.setText("");
        }
    }

    private boolean canEdit() {
        if (DesktopFrame.structuralAnalysisView != null && DesktopFrame.structuralAnalysisView.isVisible()) {
            return false;
        }
        if (DesktopFrame.stateInterpreter != null && DesktopFrame.stateInterpreter.isVisible()) {
            return false;
        }
        if (DesktopFrame.stateAnalysisSynthesisView != null && DesktopFrame.stateAnalysisSynthesisView.isVisible()) {
            return false;
        }
        if (DesktopFrame.graphView != null && DesktopFrame.graphView.isVisible()) {
            return false;
        }
        if (DesktopFrame.simuLauncher != null && DesktopFrame.simuLauncher.isVisible()) {
            return false;
        }
        if (DesktopFrame.guiSimulationSynthesis != null && DesktopFrame.guiSimulationSynthesis.isVisible()) {
            return false;
        }
        if (DesktopFrame.simuResult != null && DesktopFrame.simuResult.isVisible()) {
            return false;
        }
        if (DesktopFrame.sensiLauncher != null && DesktopFrame.sensiLauncher.isVisible()) {
            return false;
        }
        if (DesktopFrame.guiSensitivitySynthesis != null && DesktopFrame.guiSensitivitySynthesis.isVisible()) {
            return false;
        }
        return DesktopFrame.evolLauncher == null || !DesktopFrame.evolLauncher.isVisible();
    }

    public String renameOrAdd() {
        String sortie = JOptionPane.showInputDialog(null, (Object)"New Name");
        return sortie;
    }

    public void saveOrg() {
        SocLabToolkit.saveOrgNewTemp();
    }

    private void cancelOrg() throws Exception {
        if (this.canEdit()) {
            orgTemp = CreateStructfromOrgFile.loadOrgNewStruct(this.xmlTemp);
            this.relDescText.setText("");
            this.actDescText.setText("");
            this.update();
        }
    }

    private void closeOrg() throws Exception {
        DesktopFrame.modelEditor.setVisible(false);
    }

    private void help() {
        DesktopFrame.menuBar.newHelpEdit();
    }

    private void saveReport() {
        String choosedFile = "";
        DesktopFrame.fileChooser.init("choose the folder where you want to save the report", "Select", true);
        int returnVal = DesktopFrame.fileChooser.showOpenDialog(desktop);
        if (returnVal == 0) {
            choosedFile = DesktopFrame.fileChooser.getSelectedFile().getPath();
            File f1 = new File(choosedFile);
            if (!f1.exists()) {
                f1.mkdirs();
            }
            choosedFile = f1.getPath();
            orgTemp.setCurrentModelEditorPath(choosedFile);
            RTFReports.makeModelReport(orgTemp);
        }
    }

    public void closeEdition() {
        this.saveOrg();
        if (this.actDescText.isEnabled()) {
            this.editActDec.doClick();
        }
    }
}

