/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.core.structures.Interpretation;
import SocLab.tools.interval.Interval;
import SocLab.tools.interval.QualitativeScale;
import SocLab.tools.interval.gui.IntervalEditor;
import SocLab.tools.interval.gui.QualitativeScaleTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

class RelationDescEditor
extends JDialog {
    private static final String RELATION_DESCRIPTION = "DESCRIPTION";
    private static String QUALITATIVE_SCALE;
    private OrgNew orgNew;
    private String relationName;
    private JEditorPane showDescEditor;
    private JEditorPane editDescEditor;
    private JTable scaleTable;
    private QualitativeScale qualitativeScale;
    private boolean descs;

    RelationDescEditor(Frame owner, OrgNew orgNew, String relationName, boolean descs) {
        super(owner, String.valueOf(SwitchLanguages.RelationDescEditorTitle[SocLabToolkit.idLanguage]) + relationName, true);
        QUALITATIVE_SCALE = SwitchLanguages.RelationDescEditorScale[SocLabToolkit.idLanguage];
        this.orgNew = orgNew;
        this.relationName = relationName;
        this.descs = descs;
        RelationNew rN = orgNew.getRelationNew(this.relationName);
        this.qualitativeScale = new QualitativeScale();
        int i = 0;
        while (i < rN.getNbInterpretations()) {
            double stateBegin = rN.getInterpretations().elementAt(i).getStateBegin();
            double stateEnd = rN.getInterpretations().elementAt(i).getStateEnd();
            boolean inBegin = rN.getInterpretations().elementAt(i).getIncludeBegin();
            boolean inEnd = rN.getInterpretations().elementAt(i).getIncludeEnd();
            String desc = rN.getInterpretations().elementAt(i).getDescription();
            Interval interval = new Interval(stateBegin, stateEnd, inBegin, inEnd);
            this.qualitativeScale.addInterval(interval);
            this.qualitativeScale.putInterpretation(interval, desc);
            ++i;
        }
        this.init();
    }

    private void init() {
        JTabbedPane tabPanel = new JTabbedPane();
        JPanel showPanel = new JPanel();
        this.showDescEditor = new JEditorPane();
        JButton okButton = new JButton(SwitchLanguages.RelationDescEditorOkButton[SocLabToolkit.idLanguage], DesktopFrame.okIcon);
        JPanel editPanel = new JPanel();
        JTabbedPane editTabPanel = new JTabbedPane();
        this.editDescEditor = new JEditorPane();
        JPanel qualiScalePanel = new JPanel();
        JPanel secButtonPanel = new JPanel();
        JButton addInterval = new JButton(SwitchLanguages.RelationDescEditorAddButton[SocLabToolkit.idLanguage], DesktopFrame.addIcon);
        JButton editInterval = new JButton(SwitchLanguages.RelationDescEditorEditButton[SocLabToolkit.idLanguage], DesktopFrame.editIcon);
        JButton delInterval = new JButton(SwitchLanguages.RelationDescEditorDeleteButton[SocLabToolkit.idLanguage], DesktopFrame.delIcon);
        this.scaleTable = new JTable();
        JPanel buttonPanel = new JPanel();
        JButton saveButton = new JButton(SwitchLanguages.RelationDescEditorSaveButton[SocLabToolkit.idLanguage], DesktopFrame.saveModelIcon);
        JButton cancelButton = new JButton(SwitchLanguages.RelationDescEditorCancelButton[SocLabToolkit.idLanguage], DesktopFrame.cancelIcon);
        this.showDescEditor.setEditable(false);
        this.scaleTable.setModel(new QualitativeScaleTableModel(this.qualitativeScale));
        this.initValues();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationDescEditor.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationDescEditor.this.dispose();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationDescEditor.this.saveValues();
                RelationDescEditor.this.initValues();
            }
        });
        addInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QualitativeScale scale = RelationDescEditor.this.qualitativeScale;
                IntervalEditor intervalEditor = new IntervalEditor((Frame)RelationDescEditor.this.getOwner(), new Interval(-1.0, 1.0));
                Interval interval = intervalEditor.getInterval();
                if (interval != null) {
                    scale.addInterval(interval);
                    ((QualitativeScaleTableModel)RelationDescEditor.this.scaleTable.getModel()).fireTableDataChanged();
                }
            }
        });
        editInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QualitativeScale scale = RelationDescEditor.this.qualitativeScale;
                Interval interval = scale.getIntervalAt(RelationDescEditor.this.scaleTable.getSelectedRow());
                new IntervalEditor((Frame)RelationDescEditor.this.getOwner(), interval);
                ((QualitativeScaleTableModel)RelationDescEditor.this.scaleTable.getModel()).fireTableDataChanged();
            }
        });
        delInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QualitativeScale scale = RelationDescEditor.this.qualitativeScale;
                scale.removeIntervalAt(RelationDescEditor.this.scaleTable.getSelectedRow());
                ((QualitativeScaleTableModel)RelationDescEditor.this.scaleTable.getModel()).fireTableDataChanged();
            }
        });
        editPanel.setLayout(new BorderLayout());
        showPanel.setLayout(new BorderLayout());
        qualiScalePanel.setLayout(new BorderLayout());
        secButtonPanel.add(addInterval);
        secButtonPanel.add(editInterval);
        secButtonPanel.add(delInterval);
        qualiScalePanel.add((Component)secButtonPanel, "North");
        qualiScalePanel.add((Component)new JScrollPane(this.scaleTable), "Center");
        buttonPanel.add(saveButton);
        buttonPanel.add(cancelButton);
        editTabPanel.add((Component)new JScrollPane(this.editDescEditor), RELATION_DESCRIPTION);
        editTabPanel.add((Component)qualiScalePanel, QUALITATIVE_SCALE);
        showPanel.add((Component)new JScrollPane(this.showDescEditor), "Center");
        showPanel.add((Component)okButton, "South");
        this.add((Component)editTabPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.setSize(800, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setVisible(this.descs);
    }

    private void saveValues() {
        this.orgNew.getRelationNew(this.relationName).clearInterpretation();
        int i = 0;
        while (i < this.qualitativeScale.getIntervalSerieSize()) {
            double stateTop = this.qualitativeScale.getIntervalAt(i).getFrom();
            double stateEnd = this.qualitativeScale.getIntervalAt(i).getTo();
            boolean includeTop = this.qualitativeScale.getIntervalAt(i).isIncludeFrom();
            boolean includeEnd = this.qualitativeScale.getIntervalAt(i).isIncludeTo();
            String interpretation = this.qualitativeScale.getInterpretationAt(i);
            interpretation = interpretation.replace('<', '_');
            interpretation = interpretation.replace('>', '_');
            interpretation = interpretation.replace('\"', '_');
            Interpretation in = new Interpretation(stateTop, stateEnd, includeTop, includeEnd, interpretation);
            this.orgNew.getRelationNew(this.relationName).addInterpretation(in);
            ++i;
        }
        String description = this.editDescEditor.getText();
        description = description.replace('<', '_');
        description = description.replace('>', '_');
        description = description.replace('\"', '_');
        this.orgNew.getRelationNew(this.relationName).setDescription(description);
        this.dispose();
    }

    public String initValues() {
        String showText = "";
        String desc = this.orgNew.getRelationNew(this.relationName).getDescription();
        if (desc == null) {
            desc = "";
        }
        showText = "DESCRIPTION : \n\t" + desc + "\n\n" + QUALITATIVE_SCALE + " : " + "\n\t" + SwitchLanguages.RelationDescEditorInterval[SocLabToolkit.idLanguage] + "\t\t\tINTERPRETATION\n";
        int i = 0;
        while (i < this.qualitativeScale.getIntervalSerieSize()) {
            showText = String.valueOf(showText) + "\t" + this.qualitativeScale.getIntervalAt(i).toString() + "\t\t\t" + this.qualitativeScale.getInterpretationAt(i) + "\n";
            ++i;
        }
        this.editDescEditor.setText(desc);
        this.showDescEditor.setText(showText);
        return showText;
    }
}

