/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.simuLauncher.paramsPanels;

import SocLab.GUI.simuLauncher.paramsPanels.BIComponent;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AgentParams
extends JPanel {
    private Graphics graph;
    private BIComponent[] actorNameBICs;
    private JPanel subPanel = new JPanel();
    private JScrollPane scrollPane;
    private JLabel labelEval = new JLabel("Evaluation");
    private JLabel labelScope = new JLabel("Scope");
    private JLabel labelDistance = new JLabel("<html>Distance min/max<br> aim</html>");
    private JLabel labelTenacity = new JLabel("Tenacity");
    private JLabel labelReactivity = new JLabel("Reactivity");
    private JLabel labelGroupIdentification = new JLabel("Group Ident");
    private JLabel labelRep = new JLabel("<html>Repartition<br> of reward</html>");
    private JLabel labelTypeOfRules = new JLabel("Type of Rules");
    private JLabel labelOblivion = new JLabel("Oblivion");
    private JLabel labelReward = new JLabel("Reward");
    private JComboBox[] oblivionInputs;
    private String[] oblivionChoices = new String[]{"0", "1", "2", "3"};
    private JComboBox[] rewardInputs;
    private String[] rewardChoices = new String[]{"4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"};
    private JComboBox[] ScopeInputs;
    private String[] ScopeChoices = new String[]{"1", "2", "3", "4", "5"};
    private JLabel[] distanceInputs;
    private JComboBox[] evaluationInputs;
    private String[] evaluationChoices = new String[]{"satisfaction", "power", "capacity", "influence"};
    private JComboBox[] tenacityInputs;
    private String[] tenacityChoices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private JComboBox[] reactivityInputs;
    private String[] reactivityChoices = new String[]{"1", "9", "10"};
    private JComboBox[] moralSensibilityInputs;
    private String[] moralSensibilityChoices = new String[]{"-1.0", "-0.9", "-0.8", "-0.7", "-0.6", "-0.5", "-0.4", "-0.3", "-0.2", "-0.1", "0.0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1.0"};
    private String[] repVal = new String[]{"0% / 100%", "10% / 90%", "20% / 80%", "30% / 70%", "40% / 60%", "50% / 50%", "60% / 40%", "70% / 30%", "80% / 20%", "90% / 10%", "100% / 0%"};
    private static JComboBox[] repartition;
    private JComboBox[] typeOfRulesInputs;
    private String[] typeOfRulesChoices = new String[]{"Simple", "Self Learning"};

    public AgentParams() {
        this.scrollPane = new JScrollPane(this.subPanel);
    }

    private void init() {
        this.subPanel.removeAll();
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        Font font = new Font("Times New Roman", 1, 16);
        FontMetrics fm = this.graph.getFontMetrics();
        int hauteur = fm.getHeight() + 2;
        int nbActors = orgNew.getNbActorsNew();
        GridBagLayout subPanelLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.subPanel.setLayout(subPanelLayout);
        int hauteurRel = hauteur;
        int maxStringWidth = new Double(Double.NEGATIVE_INFINITY).intValue();
        maxStringWidth = new Double(Double.NEGATIVE_INFINITY).intValue();
        int i = 0;
        while (i < nbActors) {
            Rectangle2D r = font.getStringBounds(aNames[i], 0, aNames[i].length(), ((Graphics2D)this.graph).getFontRenderContext());
            if (r.getWidth() > (double)maxStringWidth) {
                maxStringWidth = new Double(r.getWidth()).intValue();
            }
            ++i;
        }
        int largeurRel = maxStringWidth;
        this.actorNameBICs = new BIComponent[nbActors];
        int i2 = 0;
        while (i2 < nbActors) {
            BufferedImage bi = new BufferedImage(largeurRel, hauteurRel, 1);
            Graphics2D g = (Graphics2D)bi.getGraphics();
            g.setFont(font);
            g.setColor(new Color(242, 246, 251));
            g.fillRect(0, 0, largeurRel, hauteurRel);
            g.setColor(Color.black);
            g.drawString(aNames[i2], 0, fm.getMaxAscent());
            this.actorNameBICs[i2] = new BIComponent(bi);
            ++i2;
        }
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        this.subPanel.add((Component)new Container(), c);
        this.labelOblivion.setToolTipText("<html>(Fr) Valeur pour la d\u00c8cr\u00c8mentation de la force des toutes les r\u00cbgles \u221a\u2020 chaque tour.<br>(En) Decrement value for the strength of all the rules at every step.</html>");
        this.labelReward.setToolTipText("<html>(Fr) Valeur pour l'incr\u00c8mentation ou la d\u00c8cr\u00c8mentation de la force de la r\u00cbgle choisie.<br>(En) Value for the increment or decrement the strength of the rule chosen.</html>");
        this.labelScope.setToolTipText("<html>(Fr) Finesse de la distinction entre les \u00e9tats pour l'application des r\u00e8gles.\n<br>(En) Fine distinction between states Game.</html>");
        this.labelTenacity.setToolTipText("<html>(Fr) Facteur de r\u00c8signation.<br>(En) Factor of resignation.</html>");
        this.labelReactivity.setToolTipText("<html>(Fr) Reactivit\u00e9 de l'acteur.<br>(En) Reactivity of the actor.</html>");
        this.labelGroupIdentification.setToolTipText("<html>(Fr) Sensibilit\u00e9 Morale de l'acteur.<br>(En) Moral sensibility of the actor.</html>");
        this.labelEval.setToolTipText("<html>(Fr) Grandeur que les acteurs essayent d'optimiser durant la simulation du mod\u00cble.<br>(En) Magnitude as the actors try to optimize during the simulation model.</html>");
        this.labelTypeOfRules.setToolTipText("<html>(Fr) Standard m\u00c8thodes utilis\u00c8es pour la r\u00c8tribution des r\u00cbgles.<br>(En) Standard methods used for retribution of rules.</html>");
        this.labelRep.setToolTipText("<html>(Fr) Repartition du bonus sur les deux r\u00cbgles (derni\u00cbre / avant derni\u00cbre) dans l'algorithme 2step.<br>(En) .</html>");
        this.labelOblivion.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelReward.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelScope.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelDistance.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelTenacity.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelReactivity.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelGroupIdentification.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelEval.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelTypeOfRules.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelRep.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelOblivion.setHorizontalAlignment(0);
        this.labelReward.setHorizontalAlignment(0);
        this.labelScope.setHorizontalAlignment(0);
        this.labelDistance.setHorizontalAlignment(0);
        this.labelTenacity.setHorizontalAlignment(0);
        this.labelReactivity.setHorizontalAlignment(0);
        this.labelGroupIdentification.setHorizontalAlignment(0);
        this.labelEval.setHorizontalAlignment(0);
        this.labelTypeOfRules.setHorizontalAlignment(0);
        this.labelRep.setHorizontalAlignment(0);
        ++c.gridx;
        this.subPanel.add((Component)this.labelDistance, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelScope, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelTenacity, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelGroupIdentification, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelRep, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelTypeOfRules, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelOblivion, c);
        ++c.gridx;
        this.subPanel.add((Component)this.labelReward, c);
        this.oblivionInputs = new JComboBox[nbActors];
        this.rewardInputs = new JComboBox[nbActors];
        this.ScopeInputs = new JComboBox[nbActors];
        this.distanceInputs = new JLabel[nbActors];
        this.tenacityInputs = new JComboBox[nbActors];
        this.reactivityInputs = new JComboBox[nbActors];
        this.moralSensibilityInputs = new JComboBox[nbActors];
        this.evaluationInputs = new JComboBox[nbActors];
        this.typeOfRulesInputs = new JComboBox[nbActors];
        repartition = new JComboBox[nbActors];
        int actorId = 0;
        while (actorId < nbActors) {
            c.gridx = 0;
            c.gridy = actorId + 2;
            this.subPanel.add((Component)this.actorNameBICs[actorId], c);
            this.oblivionInputs[actorId] = new JComboBox<String>(this.oblivionChoices);
            this.rewardInputs[actorId] = new JComboBox<String>(this.rewardChoices);
            this.ScopeInputs[actorId] = new JComboBox<String>(this.ScopeChoices);
            this.distanceInputs[actorId] = new JLabel();
            this.tenacityInputs[actorId] = new JComboBox<String>(this.tenacityChoices);
            this.reactivityInputs[actorId] = new JComboBox<String>(this.reactivityChoices);
            this.moralSensibilityInputs[actorId] = new JComboBox<String>(this.moralSensibilityChoices);
            this.evaluationInputs[actorId] = new JComboBox<String>(this.evaluationChoices);
            this.typeOfRulesInputs[actorId] = new JComboBox<String>(this.typeOfRulesChoices);
            AgentParams.repartition[actorId] = new JComboBox<String>(this.repVal);
            ++c.gridx;
            this.subPanel.add((Component)this.distanceInputs[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)this.ScopeInputs[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)this.tenacityInputs[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)this.moralSensibilityInputs[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)repartition[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)this.typeOfRulesInputs[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)this.oblivionInputs[actorId], c);
            ++c.gridx;
            this.subPanel.add((Component)this.rewardInputs[actorId], c);
            this.oblivionInputs[actorId].setPreferredSize(new Dimension(50, 20));
            this.rewardInputs[actorId].setPreferredSize(new Dimension(50, 20));
            this.distanceInputs[actorId].setPreferredSize(new Dimension(60, 20));
            this.ScopeInputs[actorId].setPreferredSize(new Dimension(60, 20));
            this.tenacityInputs[actorId].setPreferredSize(new Dimension(50, 20));
            this.reactivityInputs[actorId].setPreferredSize(new Dimension(50, 20));
            this.moralSensibilityInputs[actorId].setPreferredSize(new Dimension(50, 20));
            this.evaluationInputs[actorId].setPreferredSize(new Dimension(100, 20));
            this.typeOfRulesInputs[actorId].setPreferredSize(new Dimension(100, 20));
            repartition[actorId].setPreferredSize(new Dimension(100, 20));
            this.oblivionInputs[actorId].setEditable(true);
            this.rewardInputs[actorId].setEditable(true);
            this.ScopeInputs[actorId].setEditable(false);
            this.tenacityInputs[actorId].setEditable(false);
            this.reactivityInputs[actorId].setEditable(false);
            this.moralSensibilityInputs[actorId].setEditable(false);
            ++actorId;
        }
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)this.scrollPane, "Center");
    }

    public void updateParams() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] aNames = orgNew.getActorsNewName();
        int actID = 0;
        while (actID < orgNew.getNbActorsNew()) {
            String oblivion = this.oblivionInputs[actID].getSelectedItem().toString();
            String reward = this.rewardInputs[actID].getSelectedItem().toString();
            String scope = this.ScopeInputs[actID].getSelectedItem().toString();
            String tenacity = this.tenacityInputs[actID].getSelectedItem().toString();
            String reactivity = this.reactivityInputs[actID].getSelectedItem().toString();
            String moralSensibility = this.moralSensibilityInputs[actID].getSelectedItem().toString();
            double rp = repartition[actID].getSelectedIndex();
            double tor = this.typeOfRulesInputs[actID].getSelectedIndex();
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setOblivion(new Double(oblivion));
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setReward(new Double(reward));
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setScope(new Double(scope));
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setTenacity(new Double(tenacity));
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setReactivity(new Double(reactivity));
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setMoralSensibility(new Double(moralSensibility));
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setRepartitionPourcentage(rp / 10.0);
            orgNew.getActorNew(aNames[actID]).getAPNInitial().setTypeOfRules(tor);
            ++actID;
        }
    }

    public void initValues(Graphics g) {
        this.graph = g;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew != null) {
            String[] aNames = orgNew.getActorsNewName();
            this.subPanel.removeAll();
            if (orgNew.getNbActorsNew() >= 2 && orgNew.getNbRelationsNew() >= 2) {
                this.init();
                int actID = 0;
                while (actID < orgNew.getNbActorsNew()) {
                    String oblivion = new String("" + orgNew.getActorNew(aNames[actID]).getAPNInitial().getOblivion());
                    String reward = new String("" + orgNew.getActorNew(aNames[actID]).getAPNInitial().getReward());
                    double scope = orgNew.getActorNew(aNames[actID]).getAPNInitial().getScope();
                    double tenacity = orgNew.getActorNew(aNames[actID]).getAPNInitial().getTenacity();
                    double reactivity = orgNew.getActorNew(aNames[actID]).getAPNInitial().getReactivity();
                    double moralSensibility = orgNew.getActorNew(aNames[actID]).getAPNInitial().getMoralSensibility();
                    double ec = orgNew.getActorNew(aNames[actID]).getAPNInitial().getEvaluationCriterium();
                    double tor = orgNew.getActorNew(aNames[actID]).getAPNInitial().getTypeOfRules();
                    double rp = orgNew.getActorNew(aNames[actID]).getAPNInitial().getRepartitionPourcentage();
                    this.typeOfRulesInputs[actID].setSelectedIndex((int)tor);
                    repartition[actID].setSelectedIndex((int)(rp * 10.0));
                    this.evaluationInputs[actID].setSelectedIndex((int)ec);
                    this.oblivionInputs[actID].setSelectedItem(oblivion);
                    this.rewardInputs[actID].setSelectedItem(reward);
                    this.ScopeInputs[actID].setSelectedItem(String.valueOf((int)scope));
                    this.tenacityInputs[actID].setSelectedItem(String.valueOf((int)tenacity));
                    this.reactivityInputs[actID].setSelectedItem(String.valueOf((int)reactivity));
                    this.moralSensibilityInputs[actID].setSelectedItem(String.valueOf(moralSensibility));
                    ++actID;
                }
            }
        }
        this.calculDistance();
    }

    public void switchLanguage() {
        this.labelOblivion.setText(SwitchLanguages.AgentParamsLabelOblivion[SocLabToolkit.idLanguage]);
        this.labelReward.setText(SwitchLanguages.AgentParamsLabelReward[SocLabToolkit.idLanguage]);
        this.labelScope.setText(SwitchLanguages.AgentParamsLabelScope[SocLabToolkit.idLanguage]);
        this.labelTenacity.setText(SwitchLanguages.AgentParamsLabelTenacity[SocLabToolkit.idLanguage]);
        this.labelReactivity.setText(SwitchLanguages.AgentParamsLabelReactivity[SocLabToolkit.idLanguage]);
        this.labelGroupIdentification.setText(SwitchLanguages.AgentParamsLabelMoralSensibility[SocLabToolkit.idLanguage]);
        this.labelEval.setText(SwitchLanguages.AgentParamsLabelEvaluation[SocLabToolkit.idLanguage]);
        this.labelTypeOfRules.setText(SwitchLanguages.AgentParamsLabelTypeOfRules[SocLabToolkit.idLanguage]);
        this.labelRep.setText(SwitchLanguages.AgentParamsLabelRepartition[SocLabToolkit.idLanguage]);
        this.typeOfRulesChoices = SwitchLanguages.AgentParamschoicesTypeRules[SocLabToolkit.idLanguage];
        if (SocLabToolkit.currentOrgNew != null && SocLabToolkit.currentOrgNew.getNbActorsNew() >= 2 && SocLabToolkit.currentOrgNew.getNbRelationsNew() >= 2) {
            int actorId = 0;
            while (actorId < SocLabToolkit.currentOrgNew.getNbActorsNew()) {
                int id = this.typeOfRulesInputs[actorId].getSelectedIndex();
                this.typeOfRulesInputs[actorId].removeAllItems();
                int i = 0;
                while (i < this.typeOfRulesChoices.length) {
                    this.typeOfRulesInputs[actorId].addItem(this.typeOfRulesChoices[i]);
                    ++i;
                }
                this.typeOfRulesInputs[actorId].setSelectedIndex(id);
                ++actorId;
            }
        }
    }

    public void calculDistance() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] actorsNames = orgNew.getActorsNewName();
        String[] relationsNames = orgNew.getRelationsNewName();
        HashMap<RelationNew, Double> situationMax = new HashMap<RelationNew, Double>();
        HashMap<RelationNew, Double> situationMin = new HashMap<RelationNew, Double>();
        int i = 0;
        while (i < actorsNames.length) {
            ActorNew aN = orgNew.getActorNew(actorsNames[i]);
            int j = 0;
            while (j < relationsNames.length) {
                RelationNew rN = orgNew.getRelationNew(relationsNames[j]);
                situationMax.put(rN, (Double)aN.stateMaxAim.get(rN));
                situationMin.put(rN, (Double)aN.stateMinAim.get(rN));
                ++j;
            }
            double distance = 0.0;
            aN.distanceMaxScope = distance = 100.0;
            this.distanceInputs[i].setText(String.format("%.2f", distance));
            ++i;
        }
    }
}

