/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.simuLauncher.simuResultSynth;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SocialGameState;
import SocLab.tools.interval.Interval;
import SocLab.tools.interval.QualitativeScale;

public class simuResultSynthesis {
    private OrgNew orgNew;
    private SocialGameState state;
    private int nbActors;
    private int nbRelations;
    public int nbConv;
    public Double mean_nb_steps;
    public Double std_nb_steps;
    private String[] actorNames;
    private String[] relationNames;
    public Double[][] matrixSatisf;
    public Double[][] matrixStateRel;
    public Double[][][] array3DVarActor;
    public int nbVarActor;
    public String[] nameVarActors;

    public simuResultSynthesis(OrgNew orgNew) {
        if (orgNew != null) {
            this.nbActors = orgNew.getNbActorsNew();
            this.nbRelations = orgNew.getNbRelationsNew();
            this.actorNames = orgNew.getActorsNewName();
            this.relationNames = orgNew.getRelationsNewName();
            this.state = orgNew.getSocialGameState();
        }
    }

    String toHTML() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String html = "<html><font color=blue><b><u>Simulations Parameters<br></u></b></font>NB of Runs: " + orgNew.getNbRuns() + "<br>" + "Max Nb of Steps: " + orgNew.getNbSteps() + "<br>" + "<font color=blue><b><u>" + "<br>" + "<br>" + "Initial parameters:" + "</u></b></font>" + "<br>" + "Relations:" + this.getTEInitTable() + "<br>" + "Actors" + this.getActorParametersTable() + "<br><br>" + "<font color=blue><b><u>" + "Results" + "</u></b></font>" + "<br>" + this.getNbEtapesNecTable() + "Averages and Deviations of <u>Actors'</u> final variables (in value)" + this.getActorFinalVarTable() + "<br>" + "Influence, Absolute influence and Satisfaction percentage" + this.getActorPercentage() + "<br>" + "Averages, deviations, and Interpretations of States of <u>Relations</u>" + this.getTETable() + "<br>(\t The content of this panel can by copied-pasted, it is more complete than the report) </br>";
        html = String.valueOf(html) + "</html>";
        return html;
    }

    private String getNbEtapesNecTable() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew.headNbEtapesNec == 0) {
            return "Number of steps not available";
        }
        String result = "Number of steps before the convergence is reached: <br><table border=1><tr align=center><td>Min</td><td>Max</td><td>Mean</td></tr>";
        double min = 2.147483647E9;
        double max = -2.147483648E9;
        double mean = 0.0;
        double Converge = 0.0;
        int i = 0;
        while (i < orgNew.headNbEtapesNec) {
            double value;
            if (orgNew.nbStepConvergence[i][2].equals("-")) {
                value = SocLabToolkit.currentOrgNew.getNbSteps();
            } else {
                value = Double.valueOf(orgNew.nbStepConvergence[i][2]);
                Converge += 1.0;
            }
            mean += value;
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            ++i;
        }
        result = String.valueOf(result) + "<tr align=center><td>" + min + "</td><td>" + max + "</td><td>" + this.shiftDecimal(mean /= (double)orgNew.headNbEtapesNec, 2) + "</td></tr>";
        result = String.valueOf(result) + "</table><br>";
        result = String.valueOf(result) + "Nombre de simulations qui ont converg\u00e9 : " + Converge + "<br><br>";
        return result;
    }

    private String getTETable() {
        String table = "<table border=\"1\"><tr align=center><td>Relations</td><td>Averages</td><td>Deviations</td><td>Interpretations</td></tr>";
        int i = 0;
        while (i < this.nbRelations) {
            RelationNew rN = SocLabToolkit.currentOrgNew.getRelationNew(this.relationNames[i]);
            QualitativeScale scale = new QualitativeScale();
            if (rN.getNbInterpretations() == 0) {
                scale = null;
            } else {
                int ii = 0;
                while (ii < rN.getNbInterpretations()) {
                    double stateBegin = rN.getInterpretations().elementAt(ii).getStateBegin();
                    double stateEnd = rN.getInterpretations().elementAt(ii).getStateEnd();
                    boolean inBegin = rN.getInterpretations().elementAt(ii).getIncludeBegin();
                    boolean inEnd = rN.getInterpretations().elementAt(ii).getIncludeEnd();
                    String desc = rN.getInterpretations().elementAt(ii).getDescription();
                    Interval interval = new Interval(stateBegin, stateEnd, inBegin, inEnd);
                    scale.addInterval(interval);
                    scale.putInterpretation(interval, desc);
                    ++ii;
                }
            }
            String interpretation = " ";
            if (scale != null) {
                interpretation = scale.getQuality(this.matrixStateRel[i][0]);
            }
            table = String.valueOf(table) + "<tr align=center><td>" + this.relationNames[i] + "</td>" + "<td>" + this.shiftDecimal(this.matrixStateRel[i][0], 2) + "</td>" + "<td>" + this.shiftDecimal(this.matrixStateRel[i][1], 2) + "</td>" + "<td>" + interpretation + "</td>" + "</tr>";
            ++i;
        }
        table = String.valueOf(table) + "</table>";
        return table;
    }

    private String getActorFinalVarTable() {
        String table = "<table border=\"1\"><tr align=center><td>Actors</td>";
        int j = 0;
        while (j < this.nbVarActor) {
            table = String.valueOf(table) + "<td>" + this.nameVarActors[j] + " Aver.</td>" + "<td>" + this.nameVarActors[j] + " Dev.</td>";
            ++j;
        }
        table = String.valueOf(table) + "<td> min Aim </td> <td> max Aim </td> </tr>";
        int i = 0;
        while (i < this.nbActors) {
            table = String.valueOf(table) + "<tr align=center><td>" + this.actorNames[i] + "</td>" + "<td>";
            int j2 = 0;
            while (j2 < this.nbVarActor) {
                table = String.valueOf(table) + this.shiftDecimal(this.array3DVarActor[j2][i][0], 2) + "</td>" + "<td>" + this.shiftDecimal(this.array3DVarActor[j2][i][1], 2) + "</td>";
                ++j2;
            }
            ActorNew a = SocLabToolkit.currentOrgNew.getActorNew(this.actorNames[i]);
            table = String.valueOf(table) + "<td>" + String.format("%.2f", a.minAim) + "</td> <td>" + String.format("%.2f", a.maxAim) + "</td> </tr>";
            ++i;
        }
        table = String.valueOf(table) + "</table>";
        return table;
    }

    private String getActorPercentage() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String table = "<table border=\"1\"><tr align=center><td>Actors</td><td>% Influence</td> <td>% Absolute Infl</td> <td>% Satisfaction</td></tr>";
        int j = 0;
        while (j < this.nbActors) {
            ActorNew a = orgNew.getActorNew(this.actorNames[j]);
            table = String.valueOf(table) + "<tr align=center><td>" + this.actorNames[j] + "</td>" + "<td>";
            double val = a.getAccumulatedActualInfluence(this.state);
            a.computeMaxMinAccumulatedActualInfluence(0, 0);
            double max = a.getMaxSitInfluence();
            double min = a.getMinSitInfluence();
            table = String.valueOf(table) + String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1)) + " %" + "</td> <td>";
            val = 0.0;
            max = 0.0;
            int i = 0;
            while (i < this.nbActors) {
                ActorNew b = orgNew.getActorNew(this.actorNames[i]);
                a.getTarget(b.getName()).computeMaxMinActualInfluence(a, b);
                double v = a.getTarget(b.getName()).getActualInfluence(a, b, this.state);
                if (v >= 0.0) {
                    val += v;
                    max += a.getTarget(b.getName()).getMaxActualInfluence();
                } else {
                    val -= v;
                    max -= a.getTarget(b.getName()).getMinActualInfluence();
                }
                ++i;
            }
            table = String.valueOf(table) + String.valueOf(this.shiftDecimal(val / max * 100.0, 1)) + " %" + "</td> <td>";
            val = a.getSatisfaction(a, this.state);
            a.getMaxSatis(a, 1);
            max = a.getMaxSatis();
            a.getMinSatis(a, 1);
            min = a.getMinSatis();
            table = String.valueOf(table) + String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1)) + " %" + "</td>";
            table = String.valueOf(table) + "</tr>";
            ++j;
        }
        table = String.valueOf(table) + " </table>";
        return table;
    }

    private String getTEInitTable() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String table = "<table border=\"1\"><tr align=center><td>Relations</td><td>Init States</td><td>LowerBound</td><td>UpperBound</td><td>Frequency</td></tr>";
        int i = 0;
        while (i < this.nbRelations) {
            table = String.valueOf(table) + "<tr align=center><td>" + this.relationNames[i] + "</td>" + "<td>" + orgNew.getRelationNew(this.relationNames[i]).getRPNInitial().getState() + "</td>" + "<td>" + orgNew.getRelationNew(this.relationNames[i]).getRPNInitial().getLowerBound() + "</td>" + "<td>" + orgNew.getRelationNew(this.relationNames[i]).getRPNInitial().getUpperBound() + "</td>" + "<td>" + orgNew.getRelationNew(this.relationNames[i]).getRPNInitial().getFrequency() + "</td>" + "</tr>";
            ++i;
        }
        table = String.valueOf(table) + "</table>";
        return table;
    }

    private String getActorParametersTable() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String table = "<table border=\"1\"><tr align=center><td>Actors</td><td>oblivion</td><td>Reward</td><td>Scope</td><td>Tenacity</td><td>Reactivity</td><td>Group Ident.</td><td>Action Range</td><td>Evaluation</td><td>Type of Rules</td><td>Repartition of Reward</td></tr>";
        int i = 0;
        while (i < this.nbActors) {
            String eval = "Satisfaction";
            String rulesType = "";
            rulesType = orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getTypeOfRules() == 0.0 ? "Simple Rules" : "Self Learning Rules";
            double p = orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getRepartitionPourcentage();
            String pourcentage = "last rule:" + (int)(p * 100.0) + "%, penultimate rule:" + (int)((1.0 - p) * 100.0) + "%";
            table = String.valueOf(table) + "<tr align=center><td>" + this.actorNames[i] + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getOblivion() + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getReward() + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getScope() + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getTenacity() + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getReactivity() + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getMoralSensibility() + "</td>" + "<td>" + orgNew.getActorNew(this.actorNames[i]).getAPNInitial().getActionRange() + "</td>" + "<td>" + eval + "</td>" + "<td>" + rulesType + "</td>" + "<td>" + pourcentage + "</td>" + "</tr>";
            ++i;
        }
        table = String.valueOf(table) + "</table>";
        return table;
    }

    public String shiftDecimal(double d, int decay) {
        return String.format("%.2f", d);
    }
}

