/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.stateInterpreter.tableModel;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.SocialGameState;
import javax.swing.table.AbstractTableModel;

public class PowerCapacityActionPercentageTableModel
extends AbstractTableModel {
    private OrgNew orgNew;
    private SocialGameState state;

    public PowerCapacityActionPercentageTableModel(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.state = new SocialGameState();
        this.state.initState(orgNew);
    }

    @Override
    public int getColumnCount() {
        return this.orgNew.getNbActorsNew() + 2;
    }

    @Override
    public int getRowCount() {
        return this.orgNew.getNbActorsNew() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int nbActors = this.orgNew.getNbActorsNew();
        String[] aNames = this.orgNew.getActorsNewName();
        if (row < nbActors && col == 0) {
            return aNames[row];
        }
        if (row == nbActors && col == 0) {
            return "POWER";
        }
        if (row < nbActors && col == nbActors + 1) {
            ActorNew aN = this.orgNew.getActorNew(aNames[row]);
            double val = aN.getActionCapacity(aN, this.state);
            double max = aN.getMaxActionCap();
            double min = aN.getMinActionCap();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
        }
        if (row == nbActors && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[col - 1]);
            double val = a.getAccumulatedActualPowerBrut(a, this.state);
            double max = a.getMaxSitPowerBrut();
            double min = a.getMinSitPowerBrut();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
        }
        if (row < nbActors && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[row]);
            ActorNew b = this.orgNew.getActorNew(aNames[col - 1]);
            double val = b.getTarget(a.getName()).getActualPower(b, a, this.state);
            double max = b.getTarget(a.getName()).getMaxActualPowerBrut();
            double min = b.getTarget(a.getName()).getMinActualPower();
            return String.valueOf(String.valueOf(this.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        if (col == this.orgNew.getNbActorsNew() + 1) {
            return "ACTION CAPACITY";
        }
        return this.orgNew.getActorsNewName()[col - 1];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setState(SocialGameState state) {
        this.state = state;
        this.fireTableDataChanged();
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

