/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.stateInterpreter.tableModel;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.SocialGameState;
import javax.swing.table.AbstractTableModel;

public class PowerCapacityActionTableModel
extends AbstractTableModel {
    private OrgNew orgNew;
    private SocialGameState state;

    public PowerCapacityActionTableModel(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.state = new SocialGameState();
        this.state.initState(orgNew);
    }

    @Override
    public int getColumnCount() {
        return this.orgNew.getNbActorsNew() + 2;
    }

    @Override
    public int getRowCount() {
        return this.orgNew.getNbActorsNew() + 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int nbActors = this.orgNew.getNbActorsNew();
        String[] aNames = this.orgNew.getActorsNewName();
        if (row < nbActors && col == 0) {
            return aNames[row];
        }
        if (row == nbActors && col == 0) {
            return "POWER";
        }
        if (row == nbActors + 1 && col == 0) {
            return "ABSOLUTE POWER";
        }
        if (row == nbActors + 2 && col == 0) {
            return "COOPERATIVE POWER";
        }
        if (row < nbActors && col == nbActors + 1) {
            ActorNew aN = this.orgNew.getActorNew(aNames[row]);
            return this.shiftDecimal(aN.getActionCapacity(aN, this.state), 1);
        }
        if (row == nbActors && col == nbActors + 1) {
            double sum = 0.0;
            int i = 0;
            while (i < this.orgNew.getNbActorsNew()) {
                ActorNew aN = this.orgNew.getActorNew(aNames[i]);
                sum += aN.getActionCapacity(aN, this.state);
                ++i;
            }
            return this.shiftDecimal(sum /= (double)this.orgNew.getNbActorsNew(), 1);
        }
        if (row == nbActors && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[col - 1]);
            return this.shiftDecimal(a.getAccumulatedActualPowerBrut(a, this.state), 1);
        }
        if (row == nbActors + 1 && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[col - 1]);
            return this.shiftDecimal(a.getAccumulatedAbsoluteActualPower(a, this.state), 1);
        }
        if (row == nbActors + 2 && col < nbActors + 1) {
            ActorNew b = this.orgNew.getActorNew(aNames[col - 1]);
            return this.shiftDecimal(b.getAccumulatedCooperativeActualPowerBrut(b, this.state), 1);
        }
        if (row < nbActors && col < nbActors + 1) {
            ActorNew a = this.orgNew.getActorNew(aNames[row]);
            ActorNew b = this.orgNew.getActorNew(aNames[col - 1]);
            return this.shiftDecimal(b.getTarget(a.getName()).getActualPower(b, a, this.state), 1);
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        if (col == this.orgNew.getNbActorsNew() + 1) {
            return "Action Capacity";
        }
        return this.orgNew.getActorsNewName()[col - 1];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setState(SocialGameState state) {
        this.state = state;
        this.fireTableDataChanged();
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

