/*
 * Decompiled with CFR 0.152.
 */
package SocLab.core.actors.lcs;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.tools.Couple;
import SocLab.tools.StructElementManipulator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class RuleOwnStake
implements Serializable {
    public static int typeOfRuleCreation = 3;
    int lifeTime = 0;
    Vector<HashMap<RelationNew, Double>> situation;
    public HashMap<RelationNew, Double> actions;
    public double force;
    private int maxForce = 50;
    private Random rand = new Random();

    RuleOwnStake(OrgNew org, ActorNew a, Double action_range, Double initialForce) {
        this.force = initialForce;
        this.situation = new Vector();
        this.actions = new HashMap();
        this.situation.add(new HashMap());
        this.situation.add(new HashMap());
        if (typeOfRuleCreation != 3) {
            StructElementManipulator<RelationNew> sem = new StructElementManipulator<RelationNew>();
            Vector<Double> valeursModifs = null;
            int i = 0;
            while (i < org.getNbRelationsNew()) {
                if (org.getRelationsNew().get(i).getDepend(a.getName()).getStake() != 0.0) {
                    sem.addElement(org.getRelationsNew().get(i), 0.0);
                }
                ++i;
            }
            switch (typeOfRuleCreation) {
                case 0: {
                    valeursModifs = sem.repartRandomlyWithoutLimit(action_range, 0.0);
                    break;
                }
                case 1: {
                    valeursModifs = sem.oneModif(action_range);
                    break;
                }
                case 2: {
                    valeursModifs = sem.oneModifRepart(action_range);
                }
            }
            for (RelationNew r : org.getRelationsNew()) {
                this.situation.get(0).put(r, r.getDepend(a.getName()).getStake());
                if (sem.getData().contains(r)) {
                    this.situation.get(1).put(r, r.getRPNCurrent().getState());
                    this.actions.put(r, valeursModifs.get(sem.getIndexOf(r)));
                    continue;
                }
                this.actions.put(r, 0.0);
            }
        } else {
            double valModif;
            RelationNew rmin = null;
            RelationNew rmax = null;
            Vector<Couple<RelationNew, Double>> sortedRelations = new Vector<Couple<RelationNew, Double>>();
            for (RelationNew r : org.getRelationsNew()) {
                if (r.getDepend(a.getName()).getStake() == 0.0) continue;
                double effect = a.getSolde(r);
                sortedRelations.add(new Couple<RelationNew, Double>(r, effect + Math.random() / 100.0));
            }
            Collections.sort(sortedRelations);
            rmin = (RelationNew)((Couple)sortedRelations.firstElement()).getElem1();
            while (rmin.getDepend(a.getName()).getStake() - OrgNew.valMinStake < OrgNew.valMinStake / 5.0 && sortedRelations.size() > 2) {
                sortedRelations.removeElementAt(0);
                rmin = (RelationNew)((Couple)sortedRelations.firstElement()).getElem1();
            }
            rmax = (RelationNew)((Couple)sortedRelations.lastElement()).getElem1();
            if (a.getMaxControlStake() - a.sumControl() <= OrgNew.valMinStake && rmax.getControlActor().actorNew == a || a.sumControl() - a.getMinControlStake() <= OrgNew.valMinStake && rmin.getControlActor().actorNew == a) {
                RelationNew rTemp = rmin;
                rmin = rmax;
                rmax = rTemp;
                valModif = Math.random() * (rmin.getDepend(a.getName()).getStake() - rmax.getDepend(a.getName()).getStake());
            } else {
                double seuilModif = Math.min(a.getMaxControlStake() - rmax.getDepend(a.getName()).getStake(), rmin.getDepend(a.getName()).getStake() - OrgNew.valMinStake);
                if (rmin.getControlActor().actorNew == a) {
                    seuilModif = Math.min(seuilModif, a.sumControl() - a.getMinControlStake());
                }
                if (rmax.getControlActor().actorNew == a) {
                    seuilModif = Math.min(seuilModif, a.getMaxControlStake() - a.sumControl());
                }
                valModif = Math.min(seuilModif - 0.05, this.rand.nextDouble() * action_range);
            }
            for (RelationNew r : org.getRelationsNew()) {
                this.situation.get(0).put(r, r.getDepend(a.getName()).getStake());
                this.situation.get(1).put(r, r.getRPNCurrent().getState());
                if (r.getName().equals(rmax.getName())) {
                    this.actions.put(r, valModif);
                    continue;
                }
                if (r.getName().equals(rmin.getName())) {
                    this.actions.put(r, -valModif);
                    continue;
                }
                this.actions.put(r, 0.0);
            }
        }
        this.force = initialForce;
    }

    void minusForce(double minus) {
        this.force -= minus;
    }

    void addForce(double add) {
        this.force += add;
        if (this.force > (double)this.maxForce) {
            this.force = this.maxForce;
        }
    }

    public Vector<HashMap<RelationNew, Double>> getSituation() {
        return this.situation;
    }

    public double getForce() {
        return this.force;
    }
}

