/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools;

import SocLab.core.OrgNew;
import java.util.Random;
import java.util.Vector;

public class StructElementManipulator<T> {
    private Vector<Double> valeurs;
    private Vector<T> relations;
    private double valMin = OrgNew.valMinStake;
    private double valMax = OrgNew.valMaxStake;

    public StructElementManipulator() {
        this.valeurs = new Vector();
        this.relations = new Vector();
    }

    public void addElement(T r, double valeur) {
        this.valeurs.add(valeur);
        this.relations.add(r);
    }

    public T getRandomly() {
        Random r = new Random();
        int tirage = r.nextInt(this.relations.size());
        return this.relations.get(tirage);
    }

    private Vector<Double> repartRandomly(double modif, double sumNormalisation) {
        Vector<Double> valeursModifiees = new Vector<Double>();
        int i = 0;
        while (i < this.relations.size()) {
            valeursModifiees.add(new Double(this.valeurs.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.relations.size()) {
            if (i != this.relations.size() - 1) {
                double aimin = valeursModifiees.get(i) - modif;
                double aimax = valeursModifiees.get(i) + modif;
                double sum1 = sumNormalisation;
                double sum2 = sumNormalisation;
                int j = 0;
                while (j < i) {
                    sum1 -= valeursModifiees.get(j).doubleValue();
                    ++j;
                }
                sum2 = sum1;
                j = i + 1;
                while (j < this.relations.size()) {
                    sum1 -= Math.min(this.valMax, valeursModifiees.get(j) + modif);
                    sum2 -= Math.max(this.valMin, valeursModifiees.get(j) - modif);
                    ++j;
                }
                double ai = this.hasardChoice(Math.max(this.valMin, Math.max(aimin, sum1)), Math.min(this.valMax, Math.min(aimax, sum2)));
                valeursModifiees.set(i, ai);
            } else {
                double an = sumNormalisation;
                int j = 0;
                while (j < this.relations.size() - 1) {
                    an -= valeursModifiees.get(j).doubleValue();
                    ++j;
                }
                valeursModifiees.set(valeursModifiees.size() - 1, an);
            }
            ++i;
        }
        return valeursModifiees;
    }

    public Vector<Double> repartRandomlyWithoutLimit(double modif, double sumNormalisation) {
        Vector<Double> valeursModifiees = new Vector<Double>();
        int i = 0;
        while (i < this.relations.size()) {
            valeursModifiees.add(new Double(this.valeurs.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.relations.size()) {
            if (i != this.relations.size() - 1) {
                double aimin = valeursModifiees.get(i) - modif;
                double aimax = valeursModifiees.get(i) + modif;
                double sum1 = sumNormalisation;
                double sum2 = sumNormalisation;
                int j = 0;
                while (j < i) {
                    sum1 -= valeursModifiees.get(j).doubleValue();
                    ++j;
                }
                sum2 = sum1;
                j = i + 1;
                while (j < this.relations.size()) {
                    sum1 -= valeursModifiees.get(j) + modif;
                    sum2 -= valeursModifiees.get(j) - modif;
                    ++j;
                }
                double ai = this.hasardChoice(aimin, aimax);
                valeursModifiees.set(i, ai);
            } else {
                double an = sumNormalisation;
                int j = 0;
                while (j < this.relations.size() - 1) {
                    an -= valeursModifiees.get(j).doubleValue();
                    ++j;
                }
                valeursModifiees.set(valeursModifiees.size() - 1, an);
            }
            ++i;
        }
        return valeursModifiees;
    }

    private double hasardChoice(double a, double b) {
        Random r = new Random();
        return r.nextDouble() * (b - a) + a;
    }

    public Vector<Double> getValeurs() {
        return this.valeurs;
    }

    public Vector<T> getData() {
        return this.relations;
    }

    public int getIndexOf(T data) {
        return this.relations.indexOf(data);
    }

    public Vector<Double> oneModif(Double action_range) {
        Random r = new Random();
        int indice = r.nextInt(this.relations.size());
        int indice2 = r.nextInt(this.relations.size());
        while (indice == indice2) {
            indice2 = r.nextInt(this.relations.size());
        }
        Vector<Double> temp = new Vector<Double>();
        double modif = (r.nextDouble() - 0.5) * action_range;
        int i = 0;
        while (i < this.relations.size()) {
            if (i != indice && i != indice2) {
                temp.add(this.valeurs.get(i));
            }
            if (i == indice) {
                temp.add(this.valeurs.get(i) + modif);
            }
            if (i == indice2) {
                temp.add(this.valeurs.get(i) - modif);
            }
            ++i;
        }
        return temp;
    }

    public Vector<Double> oneModifRepart(Double action_range) {
        Random r = new Random();
        int indice = r.nextInt(this.relations.size());
        Vector<Double> temp = new Vector<Double>();
        double modif = r.nextDouble() * action_range * 2.0 - action_range;
        int i = 0;
        while (i < this.relations.size()) {
            if (i != indice) {
                temp.add(this.valeurs.get(i) - modif / (double)(this.relations.size() - 1));
            }
            if (i == indice) {
                temp.add(this.valeurs.get(i) + modif);
            }
            ++i;
        }
        return temp;
    }
}

