/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class ComplexSigmoidFunction
extends AbstractFunction {
    private String type = "CSF";

    public ComplexSigmoidFunction(String name) {
        super(name);
        this.setType("CSF");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("CSF");
        this.paramNames = new String[]{"alpha", "beta", "a1", "b1", "a2", "b2"};
        this.setParam("alpha", 1.0);
        this.setParam("beta", 0.0);
        this.setParam("a1", 1.0);
        this.setParam("b1", 1.0);
        this.setParam("a2", 1.0);
        this.setParam("b2", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double exp2;
        double a = this.getParam("alpha") / 10.0;
        double b = this.getParam("beta");
        double c = this.getParam("a1") / 10.0;
        double d = this.getParam("b1") / 10.0;
        double e = this.getParam("a2") / 10.0;
        double f = this.getParam("b2") / 10.0;
        double exp = Math.pow(Math.E, 2.0 * c * x + d);
        double val = a * (1.0 / (1.0 + exp) - 1.0 / (1.0 + (exp2 = Math.pow(Math.E, -2.0 * e * x + f)))) + b;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        return "f(x) = NaN";
    }

    @Override
    public String getType() {
        return this.type;
    }
}

