/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class LinearFunction
extends AbstractFunction {
    private String type = "linear";

    public LinearFunction(String name) {
        super(name);
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("linear");
        this.paramNames = new String[]{"a", "b"};
        this.setParam("a", 0.0);
        this.setParam("b", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double b;
        double a = this.getParam("a") / 10.0;
        double val = a * x + (b = this.getParam("b"));
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        return "f(x)=" + this.getParam("a") / 10.0 + "* x + " + this.getParam("b");
    }

    @Override
    public String getType() {
        return this.type;
    }
}

