/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class SigmoidFunction
extends AbstractFunction {
    private String type = "SF";

    public SigmoidFunction(String name) {
        super(name);
        this.setType("SF");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("SF");
        this.paramNames = new String[]{"a", "b", "c"};
        this.setParam("a", 1.0);
        this.setParam("b", 0.0);
        this.setParam("c", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double exp2;
        double a = this.getParam("a");
        double b = this.getParam("b");
        double c = this.getParam("c") / 10.0;
        double exp = Math.pow(Math.E, 2.0 * c * x);
        double val = a * (1.0 / (1.0 + exp) - 1.0 / (1.0 + (exp2 = Math.pow(Math.E, -2.0 * c * x)))) + b;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        double a = this.getParam("a");
        double b = this.getParam("b");
        double c = this.getParam("c");
        return "f(x) = " + a + "*(1/(1+E^2*" + c + "*x))-1/(1+E^-2*" + c + "*x))) + " + b;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

