/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.graph.orgBipartiteGraph;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.tools.graph.orgBipartiteGraph.ActorVertex;
import SocLab.tools.graph.orgBipartiteGraph.RelationVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseGraph;

public class BipartiteOrgGraph
extends SparseGraph {
    private ActorVertex[] actorVertexs;
    private RelationVertex[] relationVertexs;

    public BipartiteOrgGraph(OrgNew orgNew) {
        int j;
        this.actorVertexs = new ActorVertex[orgNew.getNbActorsNew()];
        String[] aNames = orgNew.getActorsNewName();
        int i = 0;
        while (i < orgNew.getNbActorsNew()) {
            this.actorVertexs[i] = new ActorVertex(orgNew, orgNew.getActorNew(aNames[i]));
            this.addVertex((Vertex)this.actorVertexs[i]);
            ++i;
        }
        String[] rNames = orgNew.getRelationsNewName();
        this.relationVertexs = new RelationVertex[orgNew.getNbRelationsNew()];
        int i2 = 0;
        while (i2 < orgNew.getNbRelationsNew()) {
            this.relationVertexs[i2] = new RelationVertex(orgNew, orgNew.getRelationNew(rNames[i2]));
            this.addVertex((Vertex)this.relationVertexs[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < orgNew.getNbRelationsNew()) {
            j = 0;
            while (j < orgNew.getNbActorsNew()) {
                RelationNew rN = orgNew.getRelationNew(rNames[i2]);
                ActorNew aN = orgNew.getActorNew(aNames[j]);
                if (aN.getDepend(rN.getName()).getStake() > 0.0) {
                    if (rN.getControlActor().getActorNew() != null) {
                        if (rN.getControlActor().getActorNew().getName().equals(aN.getName())) {
                            this.addEdge((Edge)new DirectedSparseEdge((Vertex)this.actorVertexs[j], (Vertex)this.relationVertexs[i2]));
                        } else {
                            this.addEdge((Edge)new DirectedSparseEdge((Vertex)this.relationVertexs[i2], (Vertex)this.actorVertexs[j]));
                        }
                    } else {
                        this.addEdge((Edge)new DirectedSparseEdge((Vertex)this.relationVertexs[i2], (Vertex)this.actorVertexs[j]));
                    }
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < orgNew.getNbActorsNew()) {
            j = 0;
            while (j < orgNew.getNbActorsNew()) {
                if (!this.actorVertexs[i2].equals((Object)this.actorVertexs[j])) {
                    this.addEdge((Edge)new DirectedSparseEdge((Vertex)this.actorVertexs[i2], (Vertex)this.actorVertexs[j]));
                }
                ++j;
            }
            ++i2;
        }
    }
}

