/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.graph.orgBipartiteGraph;

import SocLab.GUI.analysisView.QuickOrgGraphView;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.tools.graph.orgBipartiteGraph.ActorVertex;
import SocLab.tools.graph.orgBipartiteGraph.RelationVertex;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.collections.Predicate;

public class OrgRenderer
extends PluggableRenderer {
    private static final String NONE = "NONE";
    public String relationVertexType = "NONE";
    public String actorVertexType = "NONE";
    public String relationActorEdgeType = "NONE";
    public String actorActorEdgeType = "NONE";
    private OrgNew orgNew;
    private QuickOrgGraphView view;

    public OrgRenderer(QuickOrgGraphView view) {
        this.view = view;
        if (this.orgNew != null) {
            this.setOrgNew(view.orgNew);
        }
        this.setVertexStringer(new VertexStringer(){

            public String getLabel(ArchetypeVertex v) {
                return OrgRenderer.this.getVertexLabel(v);
            }
        });
        this.setVertexShapeFunction(new VertexShapeFunction(){

            public Shape getShape(Vertex v) {
                return OrgRenderer.this.getShape(v);
            }
        });
        this.setEdgeShapeFunction(new EdgeShapeFunction(){

            public Shape getShape(Edge e) {
                return OrgRenderer.this.getShape(e);
            }
        });
        this.setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.Line());
        this.setEdgeStrokeFunction(new EdgeStrokeFunction(){

            public Stroke getStroke(Edge e) {
                return OrgRenderer.this.getStroke(e);
            }
        });
        this.setEdgeIncludePredicate(new Predicate(){

            public boolean evaluate(Object o) {
                return OrgRenderer.this.getEdgeIncludePredicate((DirectedEdge)o);
            }
        });
        this.setVertexIncludePredicate(new Predicate(){

            public boolean evaluate(Object o) {
                return OrgRenderer.this.getVertexIncludePredicate((ArchetypeVertex)o);
            }
        });
        this.setEdgeStringer(new EdgeStringer(){

            public String getLabel(ArchetypeEdge e) {
                return OrgRenderer.this.getEdgeLabel((DirectedEdge)e);
            }
        });
        this.setGraphLabelRenderer(new GraphLabelRenderer(){

            public Component getGraphLabelRendererComponent(JComponent vv, Object value, Font font, boolean isSelected, Vertex vertex) {
                JLabel label = new JLabel(value.toString(), 0);
                label.setOpaque(true);
                Font current_font = new Font(label.getFont().getFontName(), 0, 16);
                label.setFont(current_font);
                label.setBackground(new Color(0, 0, 255, 66));
                label.setForeground(Color.black);
                return label;
            }

            public Component getGraphLabelRendererComponent(JComponent vv, Object value, Font font, boolean isSelected, Edge edge) {
                if (!value.toString().equals("")) {
                    JLabel label = new JLabel(value.toString(), 0);
                    label.setOpaque(true);
                    Font current_font = new Font(label.getFont().getFontName(), 0, 16);
                    label.setFont(current_font);
                    label.setBackground(new Color(255, 255, 255, 255));
                    Double d = new Double(value.toString());
                    if (d > 0.0) {
                        label.setForeground(Color.black);
                    }
                    if (new Double(value.toString()) == 0.0) {
                        label.setForeground(Color.black);
                    }
                    Double d2 = new Double(value.toString());
                    if (d2 < 0.0) {
                        label.setForeground(Color.black);
                    }
                    return label;
                }
                return new JLabel();
            }

            public boolean isRotateEdgeLabels() {
                return false;
            }

            public void setRotateEdgeLabels(boolean arg0) {
            }
        });
    }

    private Shape getShape(Edge e) {
        boolean actor2actorEdge;
        DirectedEdge de = (DirectedEdge)e;
        boolean relation2actorEdge = de.getSource() instanceof RelationVertex && de.getDest() instanceof ActorVertex;
        boolean actor2relationEdge = de.getSource() instanceof ActorVertex && de.getDest() instanceof RelationVertex;
        boolean bl = actor2actorEdge = de.getSource() instanceof ActorVertex && de.getDest() instanceof ActorVertex;
        if (relation2actorEdge) {
            return (Shape)new EdgeShape.QuadCurve();
        }
        if (actor2relationEdge) {
            return (Shape)new EdgeShape.QuadCurve();
        }
        if (actor2actorEdge) {
            return (Shape)new EdgeShape.Line();
        }
        return (Shape)new EdgeShape.Line();
    }

    private String getEdgeLabel(DirectedEdge edge) {
        ActorNew a;
        RelationNew r;
        boolean actor2actorEdge;
        boolean relation2actorEdge = edge.getSource() instanceof RelationVertex && edge.getDest() instanceof ActorVertex;
        boolean actor2relationEdge = edge.getSource() instanceof ActorVertex && edge.getDest() instanceof RelationVertex;
        boolean bl = actor2actorEdge = edge.getSource() instanceof ActorVertex && edge.getDest() instanceof ActorVertex;
        if (relation2actorEdge) {
            r = ((RelationVertex)edge.getSource()).relationNew;
            a = ((ActorVertex)edge.getDest()).actorNew;
            if (!this.relationActorEdgeType.equals(NONE)) {
                return "" + this.shiftDecimal(r.getDepend(a.getName()).getStrength(), 1);
            }
        }
        if (actor2relationEdge) {
            r = ((RelationVertex)edge.getDest()).relationNew;
            a = ((ActorVertex)edge.getSource()).actorNew;
            if (!this.relationActorEdgeType.equals(NONE)) {
                return "" + this.shiftDecimal(r.getDepend(a.getName()).getStrength(), 1);
            }
        }
        if (actor2actorEdge) {
            ActorNew a2 = ((ActorVertex)edge.getSource()).actorNew;
            ActorNew b = ((ActorVertex)edge.getDest()).actorNew;
            if (!this.actorActorEdgeType.equals(NONE)) {
                return "" + this.shiftDecimal(a2.getTarget(b.getName()).getStructPowerBrut(), 1);
            }
        }
        return "";
    }

    private boolean getEdgeIncludePredicate(DirectedEdge edge) {
        boolean relation2actorEdge = edge.getSource() instanceof RelationVertex && edge.getDest() instanceof ActorVertex;
        boolean actor2actorEdge = edge.getSource() instanceof ActorVertex && edge.getDest() instanceof ActorVertex;
        boolean actor2relationEdge = edge.getSource() instanceof ActorVertex && edge.getDest() instanceof RelationVertex;
        boolean actorGraphType = this.view.graphType.equals("Actors");
        boolean reLationActorGraphType = this.view.graphType.equals("Actors & Relations");
        return reLationActorGraphType && (relation2actorEdge || actor2relationEdge) || actorGraphType && actor2actorEdge;
    }

    private boolean getVertexIncludePredicate(ArchetypeVertex v) {
        boolean actorVertex = v instanceof ActorVertex;
        boolean actorGraphType = this.view.graphType.equals("Actors");
        boolean reLationActorGraphType = this.view.graphType.equals("Actors & Relations");
        return reLationActorGraphType || actorGraphType && actorVertex;
    }

    public void setOrgNew(OrgNew orgNew) {
        this.orgNew = orgNew;
    }

    private String getVertexLabel(ArchetypeVertex v) {
        String label = "";
        if (v instanceof ActorVertex) {
            ActorVertex av = (ActorVertex)v;
            label = av.actorNew.getName();
            ActorNew a = av.actorNew;
            if (!this.actorVertexType.equals(NONE)) {
                if (this.actorVertexType.equals("AUTONOMY")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(a.getAutonomy(), 1);
                } else if (this.actorVertexType.equals("SUBORDINATION")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(a.getSubordination(), 1);
                } else if (this.actorVertexType.equals("MAX_SATISFACTION")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(a.getMaxSatis(), 1);
                } else if (this.actorVertexType.equals("MIN_SATISFACTION")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(a.getMinSatis(), 1);
                }
            }
        }
        if (v instanceof RelationVertex) {
            RelationVertex rv = (RelationVertex)v;
            label = rv.relationNew.getName();
            RelationNew r = rv.relationNew;
            if (!this.relationVertexType.equals(NONE)) {
                if (this.relationVertexType.equals("MAX_POTENTIAL_STRENGTH")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(r.getMaxPotentialStrength(), 1);
                } else if (this.relationVertexType.equals("ACCUMULATED_POTENTIAL_STRENGTH")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(r.getAccumulatedPotentialStrength(), 1);
                } else if (this.relationVertexType.equals("EFFECTIVE_MAX_STRENGTH")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(r.getEffectiveMaxStrength(), 1);
                } else if (this.relationVertexType.equals("ACCUMULATED_EFFECTIVE_STRENGTH")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(r.getAccumulatedEffectiveStrength(), 1);
                } else if (this.relationVertexType.equals("RELEVANCE")) {
                    label = String.valueOf(label) + " : " + this.shiftDecimal(r.getRelevance(), 1);
                }
            }
        }
        return label;
    }

    private Shape getShape(Vertex v) {
        double minSize = 15.0;
        double maxSize = 40.0;
        if (v instanceof RelationVertex) {
            RelationVertex rv = (RelationVertex)v;
            RelationNew r = rv.relationNew;
            int size = 16;
            if (!this.relationVertexType.equals(NONE)) {
                double val = 0.0;
                double max = 0.0;
                double min = 0.0;
                if (this.relationVertexType.equals("MAX_POTENTIAL_STRENGTH")) {
                    val = r.getMaxPotentialStrength();
                    max = this.orgNew.getMaxRelationMaxPotentialStrength();
                    min = this.orgNew.getMinRelationMaxPotentialStrength();
                } else if (this.relationVertexType.equals("ACCUMULATED_POTENTIAL_STRENGTH")) {
                    val = r.getAccumulatedPotentialStrength();
                    max = this.orgNew.getMaxRelationAccumulatedPotentialStrength();
                    min = this.orgNew.getMinRelationAccumulatedPotentialStrength();
                } else if (this.relationVertexType.equals("EFFECTIVE_MAX_STRENGTH")) {
                    val = r.getEffectiveMaxStrength();
                    max = this.orgNew.getMaxRelationEffectiveMaxStrength();
                    min = this.orgNew.getMinRelationEffectiveMaxStrength();
                } else if (this.relationVertexType.equals("ACCUMULATED_EFFECTIVE_STRENGTH")) {
                    val = r.getAccumulatedEffectiveStrength();
                    max = this.orgNew.getMaxRelationAccumulatedEffectiveStrength();
                    min = this.orgNew.getMinRelationAccumulatedEffectiveStrength();
                } else if (this.relationVertexType.equals("RELEVANCE")) {
                    val = r.getRelevance();
                    max = this.orgNew.getMaxRelationRelevance();
                    min = this.orgNew.getMinRelationRelevance();
                }
                double val1 = Math.abs(val - min) * Math.abs(maxSize - minSize) / Math.abs(max - min) + minSize;
                size = new Double(val1 * Math.sqrt(2.0)).intValue();
            }
            return new Rectangle(-size / 2, -size / 2, size, size);
        }
        if (v instanceof ActorVertex) {
            ActorVertex av = (ActorVertex)v;
            ActorNew a = av.actorNew;
            int size = 16;
            if (!this.actorVertexType.equals(NONE)) {
                double val = 0.0;
                double max = 0.0;
                double min = 0.0;
                if (this.relationVertexType.equals("AUTONOMY")) {
                    val = a.getAutonomy();
                    max = this.orgNew.getMaxActorAutonomy();
                    min = this.orgNew.getMinActorAutonomy();
                } else if (this.relationVertexType.equals("SUBORDINATION")) {
                    val = a.getSubordination();
                    max = this.orgNew.getMaxActorSubordination();
                    min = this.orgNew.getMinActorSubordination();
                } else if (this.relationVertexType.equals("MAX_SATISFACTION")) {
                    val = a.getMaxSatis();
                    max = this.orgNew.getMaxActorMaxSatisfaction();
                    min = this.orgNew.getMinActorMaxSatisfaction();
                } else if (this.relationVertexType.equals("MIN_SATISFACTION")) {
                    val = a.getMinSatis();
                    max = this.orgNew.getMaxActorMinSatisfaction();
                    min = this.orgNew.getMinActorMinSatisfaction();
                }
                double val1 = Math.abs(val - min) * Math.abs(maxSize - minSize) / Math.abs(max - min) + minSize;
                size = new Double(val1 * Math.sqrt(2.0)).intValue();
                if (size == 0) {
                    size = 16;
                }
            }
            return new Ellipse2D.Double(-size / 2, -size / 2, size, size);
        }
        return new Ellipse2D.Double(-8.0, -8.0, 16.0, 16.0);
    }

    public Stroke getStroke(Edge e) {
        double val1;
        double min;
        double max;
        double val;
        float size;
        ActorNew a;
        RelationNew r;
        ActorVertex av;
        RelationVertex rv;
        boolean actor2actorEdge;
        double minSize = 0.5;
        double maxSize = 3.0;
        DirectedEdge de = (DirectedEdge)e;
        boolean relation2actorEdge = de.getSource() instanceof RelationVertex && de.getDest() instanceof ActorVertex;
        boolean actor2relationEdge = de.getSource() instanceof ActorVertex && de.getDest() instanceof RelationVertex;
        boolean bl = actor2actorEdge = de.getSource() instanceof ActorVertex && de.getDest() instanceof ActorVertex;
        if (relation2actorEdge) {
            rv = (RelationVertex)de.getSource();
            av = (ActorVertex)de.getDest();
            r = rv.relationNew;
            a = av.actorNew;
            size = 0.5f;
            if (!this.relationActorEdgeType.equals(NONE)) {
                val = r.getDepend(a.getName()).getStrength();
                max = this.orgNew.getMaxActorRelationStrength();
                min = this.orgNew.getMinActorRelationStrength();
                val1 = Math.abs(val - min) * Math.abs(maxSize - minSize) / Math.abs(max - min) + minSize;
                size = new Double(val1).floatValue();
            }
            if (r.getControlActor().getActorNew() != null) {
                if (r.getControlActor().getActorNew().getName().equals(a.getName())) {
                    return new BasicStroke(size);
                }
                float[] dashPattern = new float[]{3.0f, 3.0f, 3.0f, 3.0f, 3.0f};
                float dashPhase = 0.0f;
                return new BasicStroke(size, 0, 0, 1.0f, dashPattern, dashPhase);
            }
        }
        if (actor2relationEdge) {
            rv = (RelationVertex)de.getDest();
            av = (ActorVertex)de.getSource();
            r = rv.relationNew;
            a = av.actorNew;
            size = 0.5f;
            if (!this.relationActorEdgeType.equals(NONE)) {
                val = r.getDepend(a.getName()).getStrength();
                max = this.orgNew.getMaxActorRelationStrength();
                min = this.orgNew.getMinActorRelationStrength();
                val1 = Math.abs(val - min) * Math.abs(maxSize - minSize) / Math.abs(max - min) + minSize;
                size = new Double(val1).floatValue();
            }
            if (r.getControlActor().getActorNew() != null) {
                if (r.getControlActor().getActorNew().getName().equals(a.getName())) {
                    return new BasicStroke(size);
                }
                float[] dashPattern = new float[]{3.0f, 3.0f, 3.0f, 3.0f, 3.0f};
                float dashPhase = 0.0f;
                return new BasicStroke(size, 0, 0, 1.0f, dashPattern, dashPhase);
            }
        }
        if (actor2actorEdge) {
            ActorVertex av1 = (ActorVertex)de.getSource();
            ActorVertex av2 = (ActorVertex)de.getDest();
            ActorNew a2 = av1.actorNew;
            ActorNew b = av2.actorNew;
            size = 0.5f;
            if (!this.actorActorEdgeType.equals(NONE)) {
                val = a2.getTarget(b.getName()).getStructPowerBrut();
                max = this.orgNew.getMaxActorActorStructuralPower();
                min = this.orgNew.getMinActorActorStructuralPower();
                val1 = Math.abs(val - min) * Math.abs(maxSize - minSize) / Math.abs(max - min) + minSize;
                size = new Double(val1).floatValue();
            }
            return new BasicStroke(size);
        }
        return new BasicStroke(0.5f);
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

