/*
 * Decompiled with CFR 0.152.
 */
package controller;

import SocLab.tools.RTFReports;
import controller.EmptyException;
import docGen.Generator;
import docGen.GeneratorManager;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public abstract class ControllerGenDoc {
    private Collection<Object[]> images = new Vector<Object[]>();
    private String header = null;
    private static final int IMAGE_HEIGHT = 450;
    private static final int IMAGE_WIDTH = 550;
    private static final String TYPE_GEN = "rtf";

    public abstract String getCurrentDir();

    public abstract String getFileResultName();

    public void addGraphToDoc(JPanel graph, String title, String comment) {
        Object[] temp = new Object[]{this.getImage(graph), title, comment};
        RTFReports.simuSynImages.add(temp);
    }

    public void addHeader(String header_) {
        this.header = header_;
    }

    protected BufferedImage getImage(Component comp) {
        if (comp == null) {
            return null;
        }
        int width = comp.getWidth();
        int height = comp.getHeight();
        BufferedImage img = new BufferedImage(width, height, 5);
        Graphics2D g = img.createGraphics();
        comp.paint(g);
        g.dispose();
        return img;
    }

    public String createDoc() throws EmptyException, IOException {
        if (this.images.isEmpty()) {
            throw new EmptyException();
        }
        String adr = null;
        try {
            Generator gen = GeneratorManager.getGenerator(TYPE_GEN);
            String dir = this.getCurrentDir();
            gen.createDocument(String.valueOf(dir) + File.separator + this.getFileResultName());
            gen.changeHeadder("Statistics - Generated by SocLab");
            gen.changeFooter(true);
            gen.insertText("\nThis document is generated with the SocLab software.");
            if (this.header != null) {
                gen.insertText("\n\n" + this.header);
            }
            gen.insertTitle("Statistics");
            for (Object[] img : this.images) {
                gen.insertSubtitle((String)img[1]);
                File jpeg = File.createTempFile("img_", "_rtfGeneration");
                BufferedImage image = (BufferedImage)img[0];
                ImageIO.write((RenderedImage)image, "JPEG", jpeg);
                gen.insertImage(jpeg.getAbsolutePath(), 450, 550, null);
                jpeg.deleteOnExit();
                gen.insertCommentary((String)img[2]);
            }
            gen.closeDocument();
            adr = String.valueOf(dir) + File.separator + this.getFileResultName() + "." + TYPE_GEN;
        }
        catch (Exception e) {
            throw new IOException();
        }
        return adr;
    }

    protected String getHeader() {
        return this.header;
    }

    public Collection<Object[]> getImages() {
        return this.images;
    }
}

