/*
 * Decompiled with CFR 0.152.
 */
package graphGen;

import controller.staticAnalysis.Controller;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SimpleSparseVertex;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.utils.UserData;
import graphGen.IHMGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import organization.Actor;
import organization.Organization;
import staticParameters.StaticMath;

public class DependenceNetwork {
    private Collection<Actor> listActor;
    private Organization org;
    SparseGraph graph;
    private Map<Actor, Vertex> mapActVtx;
    public static String actorKey = "acteur";

    public DependenceNetwork(Organization o) {
        this.org = o;
        this.listActor = this.org.getActors();
        int nbActor = this.listActor.size();
        this.mapActVtx = new HashMap<Actor, Vertex>(nbActor);
        this.initGraph();
        for (Actor suivant : this.listActor) {
            this.calculeDependance(suivant);
        }
    }

    public Graph getGrah() {
        return this.graph;
    }

    public JPanel getPanelGraph(Controller ctrlGenDoc) {
        IHMGraph jp = new IHMGraph((Graph)this.graph, this.org, ctrlGenDoc);
        return jp;
    }

    private void initGraph() {
        this.graph = new SparseGraph();
        for (Actor suivant : this.listActor) {
            SimpleSparseVertex sdsv = new SimpleSparseVertex();
            Vertex v = this.graph.addVertex((Vertex)sdsv);
            v.addUserDatum((Object)actorKey, (Object)suivant, UserData.SHARED);
            this.mapActVtx.put(suivant, v);
        }
    }

    private void calculeDependance(Actor act) {
        for (Actor suivant : this.listActor) {
            UndirectedSparseEdge e;
            if (suivant.equals(act)) continue;
            float pouvoirIJ = StaticMath.power(this.org, act, suivant, false);
            float pouvoirIJEffectif = StaticMath.power(this.org, act, suivant, true);
            float pouvoirJI = StaticMath.power(this.org, suivant, act, false);
            float pouvoirJIEffectif = StaticMath.power(this.org, act, suivant, true);
            float domination = pouvoirIJ - pouvoirJI;
            float dominationBorne = pouvoirIJEffectif - pouvoirJIEffectif;
            if (!(domination >= 0.0f)) continue;
            Vertex v1 = this.mapActVtx.get(act);
            Vertex v2 = this.mapActVtx.get(suivant);
            if (domination == 0.0f && !v1.isPredecessorOf(v2)) {
                e = new UndirectedSparseEdge(v1, v2);
                e.addUserDatum((Object)"domination", (Object)Float.valueOf(domination), UserData.SHARED);
                e.addUserDatum((Object)"effective domination", (Object)Float.valueOf(dominationBorne), UserData.SHARED);
                this.graph.addEdge((Edge)e);
                continue;
            }
            if (!(domination > 0.0f)) continue;
            e = new DirectedSparseEdge(v1, v2);
            e.addUserDatum((Object)"domination", (Object)Float.valueOf(domination), UserData.SHARED);
            e.addUserDatum((Object)"effective domination", (Object)Float.valueOf(dominationBorne), UserData.SHARED);
            this.graph.addEdge((Edge)e);
        }
    }
}

