/*
 * Decompiled with CFR 0.152.
 */
package graphGen;

import controller.staticAnalysis.Controller;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStringer;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantVertexStringer;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.contrib.KKLayout;
import edu.uci.ics.jung.visualization.control.AbstractModalGraphMouse;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import graphGen.EdgeStringerWeight;
import graphGen.JSliderSizeActors;
import graphGen.OrganizationTips;
import graphGen.VertexStringerLabel;
import graphGen.actorSize.ActorSizeFunction;
import graphGen.actorSize.ActorSizeFunctionConstant;
import graphGen.actorSize.ActorSizeFunctionPropToAut;
import graphGen.actorSize.ActorSizeFunctionPropToDep;
import graphGen.actorSize.ActorSizeFunctionPropToPower;
import graphGen.actorSize.ActorSizeFunctionPropToSatisMax;
import graphGen.actorSize.ActorSizeFunctionPropToSatisMin;
import graphGen.actorSize.ActorSizeFunctionPropToSub;
import graphGen.edgeWidth.EdgeWidthDomBornee;
import graphGen.edgeWidth.EdgeWidthDomination;
import gui.staticAnalysis.AddDocPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import organization.Organization;

public class IHMGraph
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected Graph g;
    private VisualizationViewer vv;
    protected ActorSizeFunction asf;
    protected AbstractModalGraphMouse gm;
    protected PluggableRenderer pr;
    protected VertexStringerLabel vs;
    protected EdgeStringerWeight es;
    protected VertexStringer vsNone = new ConstantVertexStringer(null);
    protected EdgeStringer esNone = new ConstantEdgeStringer(null);
    protected JCheckBox aShowLabel;
    protected JCheckBox aShape;
    protected JRadioButton actSizeUniform;
    protected JRadioButton actSizePower;
    protected JRadioButton actSizeDependency;
    protected JRadioButton actSizeAutonomy;
    protected JRadioButton actSizeSubordination;
    protected JRadioButton actSizeSatisfactionMax;
    protected JRadioButton actSizeSatisfactionMin;
    protected JSliderSizeActors aSpinner;
    protected JRadioButton actLabelNone;
    protected JRadioButton actLabelPower;
    protected JRadioButton actLabelDependency;
    protected JRadioButton actLabelAutonomy;
    protected JRadioButton actLabelSubordination;
    protected JRadioButton actLabelSatisfactionMax;
    protected JRadioButton actLabelSatisfactionMin;
    private JRadioButton eSizeUniform;
    private JRadioButton eSizeDomination;
    private JRadioButton eSizeEffectiveDomination;
    private JRadioButton eLabelNone;
    private JRadioButton eLabelDomination;
    private JRadioButton eLabelEffectiveDomination;
    private JComboBox layoutCombo;
    private JComboBox modeBox;
    private ActorSizeFunctionPropToPower actorSizePower;
    private ActorSizeFunctionConstant actorSizeUniform;
    private ActorSizeFunctionPropToAut actorSizeAut;
    private ActorSizeFunctionPropToDep actorSizeDep;
    private ActorSizeFunctionPropToSub actorSizeSub;
    private ActorSizeFunctionPropToSatisMax actorSizeSatisMax;
    private ActorSizeFunctionPropToSatisMin actorSizeSatisMin;
    private EdgeWidthDomination edgeDomination;
    private EdgeWidthDomBornee edgeDomBornee;
    private ConstantEdgeStrokeFunction edgeConstant;
    private Controller ctrl;
    private AddDocPanel panelAddDoc;

    public IHMGraph(Graph graph, Organization org, Controller ctrlGenDoc) {
        this.g = graph;
        this.ctrl = ctrlGenDoc;
        FRLayout layout = new FRLayout(this.g);
        this.pr = new PluggableRenderer();
        this.pr.setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.Line());
        this.vs = new VertexStringerLabel(org);
        this.pr.setVertexStringer((VertexStringer)this.vs);
        this.es = new EdgeStringerWeight();
        this.pr.setEdgeStringer((EdgeStringer)this.es);
        this.edgeConstant = new ConstantEdgeStrokeFunction(1.0f);
        this.edgeDomination = new EdgeWidthDomination(this.g);
        this.edgeDomBornee = new EdgeWidthDomBornee(this.g);
        this.pr.setEdgeStrokeFunction((EdgeStrokeFunction)this.edgeConstant);
        this.actorSizePower = new ActorSizeFunctionPropToPower(org);
        this.actorSizeUniform = new ActorSizeFunctionConstant();
        this.actorSizeAut = new ActorSizeFunctionPropToAut(org);
        this.actorSizeDep = new ActorSizeFunctionPropToDep(org);
        this.actorSizeSub = new ActorSizeFunctionPropToSub(org);
        this.actorSizeSatisMax = new ActorSizeFunctionPropToSatisMax(org);
        this.actorSizeSatisMin = new ActorSizeFunctionPropToSatisMin(org);
        this.asf = this.actorSizeUniform;
        this.pr.setVertexShapeFunction((VertexShapeFunction)this.asf);
        this.vv = new VisualizationViewer((Layout)layout, (Renderer)this.pr);
        this.vv.setToolTipFunction((ToolTipFunction)new OrganizationTips(org));
        this.vv.setToolTipText("<html><center>Use the mouse wheel to zoom<p>Ctrl-click and Drag the mouse to pan<p>Shift-click and Drag to Rotate<p>Select Mouse Mode->Picking to move vertices<p>Select Mouse Mode->Transforming to move across the graph</center></html>");
        this.vv.setPickSupport((PickSupport)new ShapePickSupport());
        this.gm = new DefaultModalGraphMouse();
        this.gm.setZoomAtMouse(true);
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)this.gm);
        this.vv.setBackground(Color.WHITE);
        this.vv.setForeground(Color.darkGray);
        this.setLayout(new BorderLayout());
        GraphZoomScrollPane scrollPaneGraph = new GraphZoomScrollPane(this.vv);
        this.add((Component)scrollPaneGraph);
        this.addBottomControls(this);
    }

    protected void addBottomControls(JPanel jp) {
        JPanel controlPanel = new JPanel();
        jp.add((Component)controlPanel, "South");
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        Box actorPanel = Box.createVerticalBox();
        actorPanel.setBorder(BorderFactory.createTitledBorder("Actors"));
        Box edgePanel = Box.createVerticalBox();
        edgePanel.setBorder(BorderFactory.createTitledBorder("Edges"));
        Box graphPanel = Box.createVerticalBox();
        JPanel jpGraphEdge = new JPanel();
        jpGraphEdge.setLayout(new BoxLayout(jpGraphEdge, 0));
        jpGraphEdge.add(graphPanel);
        jpGraphEdge.add(edgePanel);
        JPanel jpDroite = new JPanel();
        jpDroite.setLayout(new BoxLayout(jpDroite, 1));
        jpDroite.add(jpGraphEdge);
        this.panelAddDoc = this.addDocPanel();
        jpDroite.add(this.panelAddDoc);
        controlPanel.add(actorPanel);
        controlPanel.add(jpDroite);
        Box actorSizePanel = this.sizeActorControl();
        Box actorLabelPanel = this.labelActorControl();
        JPanel jpActors = new JPanel();
        jpActors.setLayout(new FlowLayout());
        jpActors.add(actorSizePanel);
        jpActors.add(actorLabelPanel);
        actorPanel.add(jpActors);
        Box edgeSizePanel = this.sizeEdgeControl();
        Box edgeLabelPanel = this.labelEdgeControl();
        JPanel jpEdges = new JPanel();
        jpEdges.setLayout(new FlowLayout());
        jpEdges.add(edgeSizePanel);
        jpEdges.add(edgeLabelPanel);
        edgePanel.add(jpEdges);
        this.modeBox = this.gm.getModeComboBox();
        this.modeBox.setAlignmentX(0.5f);
        JPanel modePanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(this.modeBox);
        graphPanel.add(modePanel);
        Class[] combos = IHMGraph.getCombos();
        this.layoutCombo = new JComboBox<Class>(combos);
        this.layoutCombo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent((JList<?>)list, valueString, index, isSelected, cellHasFocus);
            }
        });
        this.layoutCombo.addActionListener(new LayoutChooser(this.layoutCombo, this.vv));
        this.layoutCombo.setSelectedItem(FRLayout.class);
        JPanel layoutPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        layoutPanel.setBorder(BorderFactory.createTitledBorder("Layout"));
        layoutPanel.add(this.layoutCombo);
        graphPanel.add(layoutPanel);
    }

    private AddDocPanel addDocPanel() {
        AddDocPanel docPanel = new AddDocPanel(this.ctrl, "Add the graph to the results document"){
            private static final long serialVersionUID = 1L;

            @Override
            public JPanel getDoc() {
                return IHMGraph.this.vv;
            }
        };
        docPanel.setTitle("Graph of dependences between actors");
        return docPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.actSizeUniform) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizeUniform);
                this.aSpinner.setActorSizeFunction(this.actorSizeUniform);
                this.actLabelNone.doClick();
            }
        } else if (source == this.actSizeDependency) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizeDep);
                this.aSpinner.setActorSizeFunction(this.actorSizeDep);
                this.actLabelDependency.doClick();
            }
        } else if (source == this.actSizePower) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizePower);
                this.aSpinner.setActorSizeFunction(this.actorSizePower);
                this.actLabelPower.doClick();
            }
        } else if (source == this.actSizeAutonomy) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizeAut);
                this.aSpinner.setActorSizeFunction(this.actorSizeAut);
                this.actLabelAutonomy.doClick();
            }
        } else if (source == this.actSizeSubordination) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizeSub);
                this.aSpinner.setActorSizeFunction(this.actorSizeSub);
                this.actLabelSubordination.doClick();
            }
        } else if (source == this.actSizeSatisfactionMax) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizeSatisMax);
                this.aSpinner.setActorSizeFunction(this.actorSizeSatisMax);
                this.actLabelSatisfactionMax.doClick();
            }
        } else if (source == this.actSizeSatisfactionMin) {
            if (source.isSelected()) {
                this.pr.setVertexShapeFunction((VertexShapeFunction)this.actorSizeSatisMin);
                this.aSpinner.setActorSizeFunction(this.actorSizeSatisMin);
                this.actLabelSatisfactionMin.doClick();
            }
        } else if (source == this.actLabelNone) {
            if (source.isSelected()) {
                this.vs.setLabel(0);
            }
        } else if (source == this.actLabelDependency) {
            if (source.isSelected()) {
                this.vs.setLabel(2);
            }
        } else if (source == this.actLabelPower) {
            if (source.isSelected()) {
                this.vs.setLabel(1);
            }
        } else if (source == this.actLabelAutonomy) {
            if (source.isSelected()) {
                this.vs.setLabel(3);
            }
        } else if (source == this.actLabelSubordination) {
            if (source.isSelected()) {
                this.vs.setLabel(4);
            }
        } else if (source == this.actLabelSatisfactionMax) {
            if (source.isSelected()) {
                this.vs.setLabel(5);
            }
        } else if (source == this.actLabelSatisfactionMin) {
            if (source.isSelected()) {
                this.vs.setLabel(6);
            }
        } else if (source == this.eSizeUniform) {
            if (source.isSelected()) {
                this.pr.setEdgeStrokeFunction((EdgeStrokeFunction)this.edgeConstant);
                this.eLabelNone.doClick();
            }
        } else if (source == this.eSizeDomination) {
            if (source.isSelected()) {
                this.pr.setEdgeStrokeFunction((EdgeStrokeFunction)this.edgeDomination);
                this.eLabelDomination.doClick();
            }
        } else if (source == this.eSizeEffectiveDomination) {
            if (source.isSelected()) {
                this.pr.setEdgeStrokeFunction((EdgeStrokeFunction)this.edgeDomBornee);
                this.eLabelEffectiveDomination.doClick();
            }
        } else if (source == this.eLabelNone) {
            if (source.isSelected()) {
                this.es.setTypeWeight(0);
            }
        } else if (source == this.eLabelDomination) {
            if (source.isSelected()) {
                this.es.setTypeWeight(1);
            }
        } else if (source == this.eLabelEffectiveDomination && source.isSelected()) {
            this.es.setTypeWeight(2);
        }
        this.vv.repaint();
    }

    private Box sizeActorControl() {
        Box actorSizePanel = Box.createVerticalBox();
        actorSizePanel.setBorder(BorderFactory.createTitledBorder("Actors Size Proportion"));
        this.actSizeUniform = new JRadioButton("Uniform", true);
        this.actSizeUniform.addActionListener(this);
        actorSizePanel.add(this.actSizeUniform);
        this.actSizePower = new JRadioButton("Power");
        this.actSizePower.addActionListener(this);
        actorSizePanel.add(this.actSizePower);
        this.actSizeDependency = new JRadioButton("Dependency");
        this.actSizeDependency.addActionListener(this);
        actorSizePanel.add(this.actSizeDependency);
        this.actSizeAutonomy = new JRadioButton("Autonomy");
        this.actSizeAutonomy.addActionListener(this);
        actorSizePanel.add(this.actSizeAutonomy);
        this.actSizeSubordination = new JRadioButton("Subordination");
        this.actSizeSubordination.addActionListener(this);
        actorSizePanel.add(this.actSizeSubordination);
        this.actSizeSatisfactionMax = new JRadioButton("Satisfaction Maximum");
        this.actSizeSatisfactionMax.addActionListener(this);
        actorSizePanel.add(this.actSizeSatisfactionMax);
        this.actSizeSatisfactionMin = new JRadioButton("Satisfaction Minimum");
        this.actSizeSatisfactionMin.addActionListener(this);
        actorSizePanel.add(this.actSizeSatisfactionMin);
        ButtonGroup bgSize = new ButtonGroup();
        bgSize.add(this.actSizeUniform);
        bgSize.add(this.actSizePower);
        bgSize.add(this.actSizeDependency);
        bgSize.add(this.actSizeAutonomy);
        bgSize.add(this.actSizeSubordination);
        bgSize.add(this.actSizeSatisfactionMax);
        bgSize.add(this.actSizeSatisfactionMin);
        try {
            this.aSpinner = new JSliderSizeActors(this.asf, this.vv, 2.0f, 0.5f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.aSpinner.setActorSizeFunction(this.actorSizeUniform);
        actorSizePanel.add(this.aSpinner);
        actorSizePanel.setAlignmentX(0.5f);
        return actorSizePanel;
    }

    private Box labelActorControl() {
        Box actorLabelPanel = Box.createVerticalBox();
        actorLabelPanel.setBorder(BorderFactory.createTitledBorder("Show labels"));
        this.actLabelNone = new JRadioButton("None", true);
        this.actLabelNone.addActionListener(this);
        actorLabelPanel.add(this.actLabelNone);
        this.actLabelPower = new JRadioButton("Power");
        this.actLabelPower.addActionListener(this);
        actorLabelPanel.add(this.actLabelPower);
        this.actLabelDependency = new JRadioButton("Dependency");
        this.actLabelDependency.addActionListener(this);
        actorLabelPanel.add(this.actLabelDependency);
        this.actLabelAutonomy = new JRadioButton("Autonomy");
        this.actLabelAutonomy.addActionListener(this);
        actorLabelPanel.add(this.actLabelAutonomy);
        this.actLabelSubordination = new JRadioButton("Subordination");
        this.actLabelSubordination.addActionListener(this);
        actorLabelPanel.add(this.actLabelSubordination);
        this.actLabelSatisfactionMax = new JRadioButton("Satisfaction Maximum");
        this.actLabelSatisfactionMax.addActionListener(this);
        actorLabelPanel.add(this.actLabelSatisfactionMax);
        this.actLabelSatisfactionMin = new JRadioButton("Satisfaction Minimum");
        this.actLabelSatisfactionMin.addActionListener(this);
        actorLabelPanel.add(this.actLabelSatisfactionMin);
        ButtonGroup bgSize = new ButtonGroup();
        bgSize.add(this.actLabelNone);
        bgSize.add(this.actLabelPower);
        bgSize.add(this.actLabelDependency);
        bgSize.add(this.actLabelAutonomy);
        bgSize.add(this.actLabelSubordination);
        bgSize.add(this.actLabelSatisfactionMax);
        bgSize.add(this.actLabelSatisfactionMin);
        return actorLabelPanel;
    }

    private Box sizeEdgeControl() {
        Box edgeSizePanel = Box.createVerticalBox();
        edgeSizePanel.setBorder(BorderFactory.createTitledBorder("Edge Width Proportion"));
        this.eSizeUniform = new JRadioButton("Uniform", true);
        this.eSizeUniform.addActionListener(this);
        edgeSizePanel.add(this.eSizeUniform);
        this.eSizeDomination = new JRadioButton("Domination");
        this.eSizeDomination.addActionListener(this);
        edgeSizePanel.add(this.eSizeDomination);
        this.eSizeEffectiveDomination = new JRadioButton("Effective Domination");
        this.eSizeEffectiveDomination.addActionListener(this);
        edgeSizePanel.add(this.eSizeEffectiveDomination);
        ButtonGroup bgSize = new ButtonGroup();
        bgSize.add(this.eSizeUniform);
        bgSize.add(this.eSizeDomination);
        bgSize.add(this.eSizeEffectiveDomination);
        edgeSizePanel.setAlignmentX(0.5f);
        return edgeSizePanel;
    }

    private Box labelEdgeControl() {
        Box edgeLabelPanel = Box.createVerticalBox();
        edgeLabelPanel.setBorder(BorderFactory.createTitledBorder("Edge label"));
        this.eLabelNone = new JRadioButton("None", true);
        this.eLabelNone.addActionListener(this);
        edgeLabelPanel.add(this.eLabelNone);
        this.eLabelDomination = new JRadioButton("Domination");
        this.eLabelDomination.addActionListener(this);
        edgeLabelPanel.add(this.eLabelDomination);
        this.eLabelEffectiveDomination = new JRadioButton("Effective Domination");
        this.eLabelEffectiveDomination.addActionListener(this);
        edgeLabelPanel.add(this.eLabelEffectiveDomination);
        ButtonGroup bgLabel = new ButtonGroup();
        bgLabel.add(this.eLabelNone);
        bgLabel.add(this.eLabelDomination);
        bgLabel.add(this.eLabelEffectiveDomination);
        edgeLabelPanel.setAlignmentX(0.5f);
        return edgeLabelPanel;
    }

    private static Class[] getCombos() {
        ArrayList<Class<ISOMLayout>> layouts = new ArrayList<Class<ISOMLayout>>();
        layouts.add(KKLayout.class);
        layouts.add(FRLayout.class);
        layouts.add(CircleLayout.class);
        layouts.add(SpringLayout.class);
        layouts.add(ISOMLayout.class);
        return layouts.toArray(new Class[0]);
    }

    private final class LayoutChooser
    implements ActionListener {
        private final JComboBox jcb;
        private final VisualizationViewer vv;

        private LayoutChooser(JComboBox jcb, VisualizationViewer vv) {
            this.jcb = jcb;
            this.vv = vv;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Class layoutC;
            Object[] constructorArgs = new Object[]{IHMGraph.this.g};
            Class lay = layoutC = (Class)this.jcb.getSelectedItem();
            try {
                Constructor constructor = lay.getConstructor(Graph.class);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                this.vv.stop();
                this.vv.setGraphLayout(l, false);
                this.vv.restart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

