/*
 * Decompiled with CFR 0.152.
 */
package graphGen;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import graphGen.DependenceNetwork;
import java.util.Iterator;
import organization.Actor;
import organization.Organization;
import staticParameters.StaticMath;

public class OrganizationTips
extends DefaultToolTipFunction {
    private Organization org;

    public OrganizationTips(Organization o) {
        this.org = o;
    }

    public String getToolTipText(Vertex v) {
        Actor a = (Actor)v.getUserDatum((Object)DependenceNetwork.actorKey);
        String txt = "";
        txt = "<html><center>Name : " + a.getName() + "<p>Autonomy : " + StaticMath.autonomy(this.org, a) + "<p>Subordination : " + StaticMath.subordination(this.org, a) + "<p>Satisfaction max : " + StaticMath.satisfactionMax(this.org, a).getValue() + "<p>Satisfaction min : " + StaticMath.satisfactionMin(this.org, a).getValue() + "<p>Power : " + StaticMath.power(this.org, a, false) + "<p>Dependency : " + StaticMath.dependency(this.org, a) + "</center></html>";
        return txt;
    }

    public String getToolTipText(Edge edge) {
        Iterator it = edge.getIncidentVertices().iterator();
        Vertex v1 = (Vertex)it.next();
        Vertex v2 = (Vertex)it.next();
        String a1 = ((Actor)v1.getUserDatum((Object)DependenceNetwork.actorKey)).getName();
        String a2 = ((Actor)v2.getUserDatum((Object)DependenceNetwork.actorKey)).getName();
        return "bind " + a1 + " with " + a2;
    }
}

