/*
 * Decompiled with CFR 0.152.
 */
package gui.staticAnalysis;

import controller.staticAnalysis.Controller;
import gui.staticAnalysis.TableModelCellNotEditable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class RelationJPanel {
    private JTable relationTable;
    private JPanel relationPanel;
    private Controller controller;
    private int nbParameters = 5;

    public RelationJPanel(Controller controller_) {
        this.controller = controller_;
    }

    public void createRelationJTable() {
        String[] relationParameters = new String[]{"Relation", "Force Max", "Effective Force Max", "Total Force", "Effective Total Force", "Relevance"};
        Vector<String> relationsName = this.controller.getRelationsName();
        String[][] relationData = new String[relationsName.size()][relationParameters.length];
        int i = 0;
        while (i < relationsName.size()) {
            String relationName;
            relationData[i][0] = relationName = relationsName.get(i);
            float forceMax = this.controller.getForceMax(relationName);
            relationData[i][1] = Float.toString(forceMax);
            float forceMaxEffective = this.controller.getForceMaxEffective(relationName);
            relationData[i][2] = Float.toString(forceMaxEffective);
            float totalForce = this.controller.getForceTotal(relationName);
            relationData[i][3] = Float.toString(totalForce);
            float totalForceEff = this.controller.getForceTotalEffective(relationName);
            relationData[i][4] = Float.toString(totalForceEff);
            float relevance = this.controller.getRelevance(relationName);
            relationData[i][5] = Float.toString(relevance);
            ++i;
        }
        TableModelCellNotEditable dataModel = new TableModelCellNotEditable(relationData, relationParameters);
        this.relationTable = new JTable(dataModel);
    }

    public JTable getRelationJTable() {
        return this.relationTable;
    }

    public JPanel getRelationJPanel() {
        if (this.relationPanel == null) {
            this.relationPanel = new JPanel();
            this.relationPanel.setLayout(new BorderLayout());
            TableColumn column = null;
            int i = 0;
            while (i <= this.nbParameters) {
                column = this.relationTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(130);
                ++i;
            }
            this.relationPanel.add((Component)this.relationTable.getTableHeader(), "North");
            this.relationPanel.add((Component)this.relationTable, "South");
        }
        return this.relationPanel;
    }
}

