/*
 * Decompiled with CFR 0.152.
 */
package gui.synthesis;

import SocLab.core.SocLabToolkit;
import SocLab.tools.RTFReports;
import controller.EmptyException;
import controller.simuSynthesis.AnyObservationIsConvergingException;
import controller.simuSynthesis.Controller;
import gui.help.Help;
import gui.synthesis.FileFilterByExt;
import gui.synthesis.Gui;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jdesktop.layout.GroupLayout;

public class GuiImpl
extends JInternalFrame
implements Gui {
    private static final long serialVersionUID = 1L;
    private Controller control;
    private JButton bouAddToDocD;
    private JButton bouAddToDocG;
    private JButton bouClearDocD;
    private JButton bouClearDocG;
    private JButton bouValidD;
    private JButton bouValidG;
    private JComboBox comboExperimentD;
    private JComboBox comboExperimentG;
    private JComboBox comboGraphD;
    private JComboBox comboGraphG;
    private JComboBox comboTypeD;
    private JComboBox comboTypeG;
    private JComboBox comboVariableD;
    private JComboBox comboVariableG;
    private JLabel jLabelTitreGrapheD;
    private JLabel jLabelTitreGrapheG;
    private JMenuBar jMenuBar1;
    private JLabel labelAddToDocD;
    private JLabel labelAddToDocG;
    private JLabel labelCommentD;
    private JLabel labelCommentG;
    private JLabel labelExperimentD;
    private JLabel labelExperimentG;
    private JLabel labelGraphD;
    private JLabel labelGraphG;
    private JLabel labelTitleD;
    private JLabel labelTitleG;
    private JLabel labelVariableD;
    private JLabel labelVariableG;
    private JMenu menuExport;
    private JMenuItem menuExportFile;
    private JMenuItem menuExportResults;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuHelpManual;
    private JMenuItem menuOpen;
    private JPanel panelD;
    private JPanel panelG;
    private JPanel panelStatD;
    private JPanel panelStatG;
    private JRadioButton radioActorD;
    private JRadioButton radioActorG;
    private JRadioButton radioConvergenceD;
    private JRadioButton radioConvergenceG;
    private ButtonGroup radioD;
    private ButtonGroup radioG;
    private JRadioButton radioRelationD;
    private JRadioButton radioRelationG;
    private JRadioButton radioSimulationD;
    private JRadioButton radioSimulationG;
    private JScrollPane scrollCommentD;
    private JScrollPane scrollCommentG;
    private JSeparator separatorMenuExport;
    private JTextPane txtCommentD;
    private JTextPane txtCommentG;
    private JTextField txtTitleD;
    private JTextField txtTitleG;
    int priorite = -1;

    public GuiImpl(Controller control_) {
        this.setName("GUI Simulation Synthesis");
        this.setDefaultCloseOperation(1);
        this.control = control_;
        this.initComponents();
        this.disableOption();
        this.disableSaisie();
        this.setMinimumSize(new Dimension(1111, 700));
    }

    private void initComponents() {
        this.radioG = new ButtonGroup();
        this.panelG = new JPanel();
        this.comboExperimentG = new JComboBox();
        this.comboVariableG = new JComboBox();
        this.radioActorG = new JRadioButton();
        this.radioRelationG = new JRadioButton();
        this.labelExperimentG = new JLabel();
        this.labelVariableG = new JLabel();
        this.labelGraphG = new JLabel();
        this.comboGraphG = new JComboBox();
        this.bouValidG = new JButton();
        this.panelStatG = new JPanel();
        this.radioSimulationG = new JRadioButton();
        this.radioConvergenceG = new JRadioButton();
        this.comboTypeG = new JComboBox();
        this.bouClearDocG = new JButton();
        this.bouAddToDocG = new JButton();
        this.txtTitleG = new JTextField();
        this.labelTitleG = new JLabel();
        this.labelCommentG = new JLabel();
        this.scrollCommentG = new JScrollPane();
        this.txtCommentG = new JTextPane();
        this.labelAddToDocG = new JLabel();
        this.jLabelTitreGrapheG = new JLabel();
        this.radioD = new ButtonGroup();
        this.panelD = new JPanel();
        this.comboExperimentD = new JComboBox();
        this.comboVariableD = new JComboBox();
        this.radioActorD = new JRadioButton();
        this.radioRelationD = new JRadioButton();
        this.labelExperimentD = new JLabel();
        this.labelVariableD = new JLabel();
        this.labelGraphD = new JLabel();
        this.comboGraphD = new JComboBox();
        this.bouValidD = new JButton();
        this.panelStatD = new JPanel();
        this.radioSimulationD = new JRadioButton();
        this.radioConvergenceD = new JRadioButton();
        this.comboTypeD = new JComboBox();
        this.bouClearDocD = new JButton();
        this.bouAddToDocD = new JButton();
        this.txtTitleD = new JTextField();
        this.labelTitleD = new JLabel();
        this.labelCommentD = new JLabel();
        this.scrollCommentD = new JScrollPane();
        this.txtCommentD = new JTextPane();
        this.labelAddToDocD = new JLabel();
        this.jLabelTitreGrapheD = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuOpen = new JMenuItem();
        this.menuExport = new JMenu();
        this.menuExportFile = new JMenuItem();
        this.separatorMenuExport = new JSeparator();
        this.menuExportResults = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuHelpManual = new JMenuItem();
        this.getContentPane().setLayout(new GridLayout(1, 2));
        this.setTitle("Result analysis " + SocLabToolkit.currentOrgNew.getCurrentSimulationPath());
        this.panelG.setBorder(BorderFactory.createEtchedBorder());
        this.comboExperimentG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboExperimentGActionPerformed(evt);
            }
        });
        this.comboVariableG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboVariableGActionPerformed(evt);
            }
        });
        this.radioG.add(this.radioActorG);
        this.radioActorG.setSelected(true);
        this.radioActorG.setText("Actor");
        this.radioActorG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioActorG.setMargin(new Insets(0, 0, 0, 0));
        this.radioActorG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioActorGActionPerformed(evt);
            }
        });
        this.radioG.add(this.radioRelationG);
        this.radioRelationG.setText("Relation");
        this.radioRelationG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioRelationG.setMargin(new Insets(0, 0, 0, 0));
        this.radioRelationG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioRelationGActionPerformed(evt);
            }
        });
        this.labelExperimentG.setText("Experiment :");
        this.labelVariableG.setText("Variable :");
        this.labelGraphG.setText("Graph :");
        this.bouValidG.setText("Draw it");
        this.bouValidG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouValidGActionPerformed(evt);
            }
        });
        this.panelStatG.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout panelStatGLayout = new GroupLayout((Container)this.panelStatG);
        this.panelStatG.setLayout((LayoutManager)panelStatGLayout);
        panelStatGLayout.setHorizontalGroup((GroupLayout.Group)panelStatGLayout.createParallelGroup(1).add(0, 439, Short.MAX_VALUE));
        panelStatGLayout.setVerticalGroup((GroupLayout.Group)panelStatGLayout.createParallelGroup(1).add(0, 184, Short.MAX_VALUE));
        this.radioG.add(this.radioSimulationG);
        this.radioSimulationG.setText("Simulation");
        this.radioSimulationG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioSimulationG.setMargin(new Insets(0, 0, 0, 0));
        this.radioSimulationG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioSimulationGActionPerformed(evt);
            }
        });
        this.radioG.add(this.radioConvergenceG);
        this.radioConvergenceG.setText("Convergence");
        this.radioConvergenceG.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioConvergenceG.setMargin(new Insets(0, 0, 0, 0));
        this.radioConvergenceG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioConvergenceGActionPerformed(evt);
            }
        });
        this.comboTypeG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboTypeGActionPerformed(evt);
            }
        });
        this.bouClearDocG.setText("Clear report");
        this.bouClearDocG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouClearDocGActionPerformed(evt);
            }
        });
        this.bouAddToDocG.setText("Add to report");
        this.bouAddToDocG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouAddToDocGActionPerformed(evt);
            }
        });
        this.labelTitleG.setText("Title :");
        this.labelCommentG.setText("Comment :");
        this.scrollCommentG.setViewportView(this.txtCommentG);
        this.labelAddToDocG.setForeground(Color.red);
        this.jLabelTitreGrapheG.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitreGrapheG.setForeground(Color.red);
        this.jLabelTitreGrapheG.setHorizontalAlignment(0);
        GroupLayout panelGLayout = new GroupLayout((Container)this.panelG);
        this.panelG.setLayout((LayoutManager)panelGLayout);
        panelGLayout.setHorizontalGroup((GroupLayout.Group)panelGLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panelGLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelGLayout.createParallelGroup(2).add(1, (Component)this.panelStatG, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelTitreGrapheG, -2, 443, -2).add(1, (GroupLayout.Group)panelGLayout.createSequentialGroup().add((GroupLayout.Group)panelGLayout.createParallelGroup(2, false).add((Component)this.labelGraphG, -1, -1, Short.MAX_VALUE).add((Component)this.labelVariableG, -1, -1, Short.MAX_VALUE).add((Component)this.labelExperimentG, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(2).add((Component)this.comboGraphG, 0, 378, Short.MAX_VALUE).add((Component)this.comboVariableG, 0, 378, Short.MAX_VALUE).add(1, (GroupLayout.Group)panelGLayout.createSequentialGroup().add((Component)this.radioActorG).addPreferredGap(0).add((Component)this.radioRelationG).addPreferredGap(0).add((Component)this.radioSimulationG).addPreferredGap(0).add((Component)this.radioConvergenceG)).add((Component)this.comboExperimentG, 0, 378, Short.MAX_VALUE).add((Component)this.comboTypeG, 0, 378, Short.MAX_VALUE))).add(1, (GroupLayout.Group)panelGLayout.createSequentialGroup().add((GroupLayout.Group)panelGLayout.createParallelGroup(2, false).add(1, (Component)this.labelCommentG, -1, -1, Short.MAX_VALUE).add(1, (Component)this.labelTitleG, -1, 60, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(1).add((Component)this.scrollCommentG, -1, 379, Short.MAX_VALUE).add((Component)this.txtTitleG, -1, 379, Short.MAX_VALUE))).add((GroupLayout.Group)panelGLayout.createSequentialGroup().add((Component)this.labelAddToDocG, -2, 322, -2).addPreferredGap(0, 6, Short.MAX_VALUE).add((Component)this.bouClearDocG).add((Component)this.bouAddToDocG)).add((Component)this.bouValidG)).addContainerGap()));
        panelGLayout.setVerticalGroup((GroupLayout.Group)panelGLayout.createParallelGroup(1).add((GroupLayout.Group)panelGLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.labelExperimentG).add((Component)this.comboExperimentG, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.radioActorG).add((Component)this.radioRelationG).add((Component)this.radioSimulationG).add((Component)this.radioConvergenceG)).addPreferredGap(0).add((Component)this.comboTypeG, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.labelVariableG).add((Component)this.comboVariableG, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.labelGraphG).add((Component)this.comboGraphG, -2, -1, -2)).addPreferredGap(0).add((Component)this.bouValidG).addPreferredGap(0).add((Component)this.jLabelTitreGrapheG, -2, 30, -2).addPreferredGap(0).add((Component)this.panelStatG, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.txtTitleG, -2, -1, -2).add((Component)this.labelTitleG)).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(1).add((GroupLayout.Group)panelGLayout.createSequentialGroup().add((Component)this.scrollCommentG, -2, 67, -2).addPreferredGap(0).add((GroupLayout.Group)panelGLayout.createParallelGroup(3).add((Component)this.bouClearDocG).add((Component)this.bouAddToDocG).add((Component)this.labelAddToDocG, -2, 11, -2))).add((Component)this.labelCommentG)).addContainerGap()));
        this.getContentPane().add(this.panelG);
        this.panelD.setBorder(BorderFactory.createEtchedBorder());
        this.comboVariableD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboVariableDActionPerformed(evt);
            }
        });
        this.radioD.add(this.radioActorD);
        this.radioActorD.setSelected(true);
        this.radioActorD.setText("Actor");
        this.radioActorD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioActorD.setMargin(new Insets(0, 0, 0, 0));
        this.radioActorD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioActorDActionPerformed(evt);
            }
        });
        this.radioD.add(this.radioRelationD);
        this.radioRelationD.setText("Relation");
        this.radioRelationD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioRelationD.setMargin(new Insets(0, 0, 0, 0));
        this.radioRelationD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioRelationDActionPerformed(evt);
            }
        });
        this.labelExperimentD.setText("Experiment :");
        this.labelVariableD.setText("Variable :");
        this.labelGraphD.setText("Graph :");
        this.bouValidD.setText("Draw it");
        this.bouValidD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouValidDActionPerformed(evt);
            }
        });
        this.panelStatD.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout panelStatDLayout = new GroupLayout((Container)this.panelStatD);
        this.panelStatD.setLayout((LayoutManager)panelStatDLayout);
        panelStatDLayout.setHorizontalGroup((GroupLayout.Group)panelStatDLayout.createParallelGroup(1).add(0, 439, Short.MAX_VALUE));
        panelStatDLayout.setVerticalGroup((GroupLayout.Group)panelStatDLayout.createParallelGroup(1).add(0, 311, Short.MAX_VALUE));
        this.radioD.add(this.radioSimulationD);
        this.radioSimulationD.setText("Simulation");
        this.radioSimulationD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioSimulationD.setMargin(new Insets(0, 0, 0, 0));
        this.radioSimulationD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioSimulationDActionPerformed(evt);
            }
        });
        this.radioD.add(this.radioConvergenceD);
        this.radioConvergenceD.setText("Convergence");
        this.radioConvergenceD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioConvergenceD.setMargin(new Insets(0, 0, 0, 0));
        this.radioConvergenceD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.radioConvergenceDActionPerformed(evt);
            }
        });
        this.comboTypeD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboTypeDActionPerformed(evt);
            }
        });
        this.comboExperimentD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.comboExperimentDActionPerformed(evt);
            }
        });
        this.bouClearDocD.setText("Clear report");
        this.bouClearDocD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouClearDocDActionPerformed(evt);
            }
        });
        this.bouAddToDocD.setText("Add to report");
        this.bouAddToDocD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.bouAddToDocDActionPerformed(evt);
            }
        });
        this.labelTitleD.setText("Title :");
        this.labelCommentD.setText("Comment :");
        this.scrollCommentD.setViewportView(this.txtCommentD);
        this.labelAddToDocD.setForeground(Color.red);
        this.jLabelTitreGrapheD.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitreGrapheD.setForeground(Color.red);
        this.jLabelTitreGrapheD.setHorizontalAlignment(0);
        GroupLayout panelDLayout = new GroupLayout((Container)this.panelD);
        this.panelD.setLayout((LayoutManager)panelDLayout);
        panelDLayout.setHorizontalGroup((GroupLayout.Group)panelDLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panelDLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelDLayout.createParallelGroup(2).add(1, (Component)this.panelStatD, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabelTitreGrapheD, -2, 443, -2).add(1, (GroupLayout.Group)panelDLayout.createSequentialGroup().add((GroupLayout.Group)panelDLayout.createParallelGroup(2, false).add((Component)this.labelGraphD, -1, -1, Short.MAX_VALUE).add((Component)this.labelVariableD, -1, -1, Short.MAX_VALUE).add((Component)this.labelExperimentD, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(2).add((Component)this.comboGraphD, 0, 378, Short.MAX_VALUE).add((Component)this.comboVariableD, 0, 378, Short.MAX_VALUE).add(1, (GroupLayout.Group)panelDLayout.createSequentialGroup().add((Component)this.radioActorD).addPreferredGap(0).add((Component)this.radioRelationD).addPreferredGap(0).add((Component)this.radioSimulationD).addPreferredGap(0).add((Component)this.radioConvergenceD)).add((Component)this.comboExperimentD, 0, 378, Short.MAX_VALUE).add((Component)this.comboTypeD, 0, 378, Short.MAX_VALUE))).add(1, (GroupLayout.Group)panelDLayout.createSequentialGroup().add((GroupLayout.Group)panelDLayout.createParallelGroup(2, false).add(1, (Component)this.labelCommentD, -1, -1, Short.MAX_VALUE).add(1, (Component)this.labelTitleD, -1, 60, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(1).add((Component)this.scrollCommentD, -1, 379, Short.MAX_VALUE).add((Component)this.txtTitleD, -1, 379, Short.MAX_VALUE))).add((GroupLayout.Group)panelDLayout.createSequentialGroup().add((Component)this.labelAddToDocD, -2, 322, -2).addPreferredGap(0, 6, Short.MAX_VALUE).add((Component)this.bouClearDocD).add((Component)this.bouAddToDocD)).add((Component)this.bouValidD)).addContainerGap()));
        panelDLayout.setVerticalGroup((GroupLayout.Group)panelDLayout.createParallelGroup(1).add((GroupLayout.Group)panelDLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.labelExperimentD).add((Component)this.comboExperimentD, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.radioActorD).add((Component)this.radioRelationD).add((Component)this.radioSimulationD).add((Component)this.radioConvergenceD)).addPreferredGap(0).add((Component)this.comboTypeD, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.labelVariableD).add((Component)this.comboVariableD, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.labelGraphD).add((Component)this.comboGraphD, -2, -1, -2)).addPreferredGap(0).add((Component)this.bouValidD).addPreferredGap(0).add((Component)this.jLabelTitreGrapheD, -2, 30, -2).addPreferredGap(0).add((Component)this.panelStatD, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.txtTitleD, -2, -1, -2).add((Component)this.labelTitleD)).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(1).add((GroupLayout.Group)panelDLayout.createSequentialGroup().add((Component)this.scrollCommentD, -2, 67, -2).addPreferredGap(0).add((GroupLayout.Group)panelDLayout.createParallelGroup(3).add((Component)this.bouClearDocD).add((Component)this.bouAddToDocD).add((Component)this.labelAddToDocD, -2, 11, -2))).add((Component)this.labelCommentD)).addContainerGap()));
        this.getContentPane().add(this.panelD);
        this.menuFile.setText("File");
        this.menuOpen.setText("Open...");
        this.menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuOpen);
        this.jMenuBar1.add(this.menuFile);
        this.menuExport.setText("Export");
        this.menuExportFile.setText("Export into a file");
        this.menuExportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuExportFileActionPerformed(evt);
            }
        });
        this.menuExport.add(this.menuExportFile);
        this.menuExport.add(this.separatorMenuExport);
        this.menuExportResults.setText("Export results");
        this.menuExportResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuExportResultsActionPerformed(evt);
            }
        });
        this.menuExport.add(this.menuExportResults);
        this.menuHelp.setText("?");
        this.menuHelpManual.setText("Help");
        this.menuHelpManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiImpl.this.menuHelpManualActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuHelpManual);
        this.jMenuBar1.add(this.menuHelp);
        this.pack();
    }

    private void menuHelpManualActionPerformed(ActionEvent evt) {
        String txt = "1   Importer les r\u00e9sultats bruts \n================================ \n \nPour importer les rsultats bruts, il faut choisir le dossier o se trouvent ces rsultats. \nPour cela il faut dabord cliquer sur File, puis sur Open\u9485 \nEnsuite, slectionnez le dossier contenant uniquement des rsultats bruts, puis cliquez sur Select \nAttention, il ne faut pas rentrer  lintrieur du dossier, il suffit de cliquer sur ce dossier et \nensuite de cliquer sur select. \n \n \n2   Afficher les graphiques \n=========================== \n \nPour afficher les diffrents graphiques, il faut dabord choisir les paramtres du graphique  \nafficher, cest--dire : \n-\tune observation en particulier ou toutes les simulations \n-\tla catgorie : acteur, relation, simulation ou convergence \n-\tla ou les variables selon la catgorie choisie \n-\tle graphique parmi les graphiques possibles selon les choix prcdents \nEnfin, lorsque toutes ces oprations ont t effectues, il suffit de cliquer sur le bouton Draw it. \nPour plus de facilit, les menus droulants sont mis  jour  chaque modification dun paramtre, \nen fonction des valeurs des autres paramtres, il est donc prfrable de choisir les paramtres de haut en bas. \n \n \n3   Cration du document RTF \n============================ \n \n3.1 Ajout dun graphique au document \n------------------------------------ \n \nPour ajouter un graphique au document, ce graphique doit tre visible dans la vue de gauche, ensuite \nchoisissez un titre et un commentaire pour ce graphique, puis cliquez sur le bouton Add to report. \nLe nombre de graphiques pouvant tre ajout est illimit. \n \n3.2 Edition du document \n----------------------- \n \nUne fois que tous les graphiques dsirs sont ajouts au document, il faut choisir le nom du fichier et \nle rpertoire o enregistrer le document. \nPour cela il faut dabord cliquer sur Export, puis sur Export into a file. \nEnsuite il suffit de se placer dans le dossier o enregistrer le document, de choisir un nom et de cliquer \nsur le bouton Create. \nUn document au format RTF peut tre lu avec Word et OpenOffice. \n \n \n4   Cration du fichier de rsultats \n==================================== \n \nPour exporter les rsultats des simulations, il faut dabord cliquer sur Export, puis sur Export results. \nEnsuite il suffit de se placer dans le dossier o enregistrer le fichier de rsultats, de choisir un nom (sans \noublier dajouter l\u9492extension .txt) et de cliquer sur le bouton Create.  \n";
        new Help("Help", txt, this);
    }

    private void menuExportResultsActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.control.getCurrentDir()));
            chooser.setSelectedFile(new File(this.control.getResultsFileName()));
            int ret = chooser.showDialog(this, "Create");
            File file = chooser.getSelectedFile();
            if (ret != 1 && file != null) {
                String dirName = file.getParent();
                String fileName = file.getName();
                String docName = this.control.createSummaryFiles(dirName, fileName);
                JOptionPane.showConfirmDialog(this, "A new file is generated\n" + docName, "New file", -1, 1);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Error during the file generation.", "Error", -1, 0);
        }
        catch (AnyObservationIsConvergingException aoice) {
            aoice.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Error during the file generation.\nThere is not converging observation.", "Error", -1, 0);
        }
    }

    private void comboExperimentDActionPerformed(ActionEvent evt) {
        this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void bouClearDocGActionPerformed(ActionEvent evt) {
        RTFReports.simuSynImages.clear();
    }

    private void bouAddToDocGActionPerformed(ActionEvent evt) {
        String title = this.txtTitleG.getText();
        String comment = this.txtCommentG.getText();
        JPanel panel = (JPanel)this.panelStatG.getComponent(0);
        if (title.equals("")) {
            title = this.jLabelTitreGrapheG.getText();
        }
        this.control.addGraphToReport(panel, title, comment);
        this.txtCommentG.setText("");
        this.txtTitleG.setText("");
        this.labelAddToDocG.setText("The chart \"" + title + "\" is add to the future document");
    }

    private void bouClearDocDActionPerformed(ActionEvent evt) {
        RTFReports.simuSynImages.clear();
    }

    private void bouAddToDocDActionPerformed(ActionEvent evt) {
        String title = this.txtTitleD.getText();
        String comment = this.txtCommentD.getText();
        JPanel panel = (JPanel)this.panelStatD.getComponent(0);
        if (title.equals("")) {
            title = this.jLabelTitreGrapheD.getText();
        }
        this.control.addGraphToReport(panel, title, comment);
        this.txtCommentD.setText("");
        this.txtTitleD.setText("");
        this.labelAddToDocD.setText("The chart \"" + title + "\" is add to the future document");
    }

    private void radioConvergenceDActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentD, true);
        this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void radioSimulationDActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentD, true);
        this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void radioConvergenceGActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentG, true);
        this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void radioSimulationGActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentG, true);
        this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void comboTypeDActionPerformed(ActionEvent evt) {
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void comboTypeGActionPerformed(ActionEvent evt) {
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void menuExportFileActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.control.getCurrentDir()));
            chooser.setFileFilter(new FileFilterByExt("rtf"));
            int ret = chooser.showDialog(this, "Create");
            File file = chooser.getSelectedFile();
            if (ret != 1 && file != null) {
                String dirName = file.getParent();
                String fileName = file.getName();
                this.control.setDocName(dirName, fileName);
                String docName = this.control.createDoc();
                JOptionPane.showConfirmDialog(this, "A new file is generated\n" + docName, "New file", -1, 1);
            }
        }
        catch (EmptyException e) {
            e.printStackTrace();
            JOptionPane.showConfirmDialog(this, "The document is empty", "Error", -1, 0);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Error during the generation", "New file", -1, 0);
            return;
        }
    }

    private void comboExperimentGActionPerformed(ActionEvent evt) {
        this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void menuOpenActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int ret = chooser.showDialog(this, "Select");
        if (ret != 1 && chooser.getSelectedFile() != null) {
            this.setTitle("Result analysis" + chooser.getSelectedFile().getAbsolutePath());
            try {
                this.control.loadResults(chooser.getSelectedFile().getAbsolutePath());
                this.updateGUI();
                this.control.createSummaryFiles(SocLabToolkit.currentOrgNew.getCurrentSimulationPath(), "synthesis." + SocLabToolkit.orgFileNew.getName() + ".xls");
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showConfirmDialog(this, "Error", "Error", -1, 0);
                return;
            }
            this.enableOption();
            this.updateExperiment(this.comboExperimentG, false);
            this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
            this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
            this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
            this.updateExperiment(this.comboExperimentD, false);
            this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
            this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
            this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
        }
    }

    public void updateGUI() {
        this.enableOption();
        this.updateExperiment(this.comboExperimentG, false);
        this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
        this.updateExperiment(this.comboExperimentD, false);
        this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void bouValidDActionPerformed(ActionEvent evt) {
        this.updateGraphic(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD, this.panelStatD, this.jLabelTitreGrapheD, null);
    }

    private void bouValidGActionPerformed(ActionEvent evt) {
        this.updateGraphic(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG, this.panelStatG, this.jLabelTitreGrapheG, this.txtTitleG);
    }

    private void comboVariableDActionPerformed(ActionEvent evt) {
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void comboVariableGActionPerformed(ActionEvent evt) {
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void radioRelationDActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentD, false);
        this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void radioActorDActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentD, false);
        this.updateType(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD);
        this.updateVariable(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD);
        this.updateGraph(this.comboExperimentD, this.radioActorD, this.radioRelationD, this.radioSimulationD, this.radioConvergenceD, this.comboTypeD, this.comboVariableD, this.comboGraphD);
    }

    private void radioRelationGActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentG, false);
        this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void radioActorGActionPerformed(ActionEvent evt) {
        this.updateExperiment(this.comboExperimentG, false);
        this.updateType(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG);
        this.updateVariable(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG);
        this.updateGraph(this.comboExperimentG, this.radioActorG, this.radioRelationG, this.radioSimulationG, this.radioConvergenceG, this.comboTypeG, this.comboVariableG, this.comboGraphG);
    }

    private void enableOption() {
        this.comboExperimentG.setEnabled(true);
        this.comboGraphG.setEnabled(true);
        this.comboVariableG.setEnabled(true);
        this.comboTypeG.setEnabled(true);
        this.bouValidG.setEnabled(true);
        this.radioActorG.setEnabled(true);
        this.radioRelationG.setEnabled(true);
        this.radioSimulationG.setEnabled(true);
        this.radioConvergenceG.setEnabled(true);
        this.labelExperimentG.setEnabled(true);
        this.labelGraphG.setEnabled(true);
        this.labelVariableG.setEnabled(true);
        this.comboExperimentD.setEnabled(true);
        this.comboGraphD.setEnabled(true);
        this.comboVariableD.setEnabled(true);
        this.comboTypeD.setEnabled(true);
        this.bouValidD.setEnabled(true);
        this.radioActorD.setEnabled(true);
        this.radioRelationD.setEnabled(true);
        this.radioConvergenceD.setEnabled(true);
        this.radioSimulationD.setEnabled(true);
        this.labelExperimentD.setEnabled(true);
        this.labelGraphD.setEnabled(true);
        this.labelVariableD.setEnabled(true);
        this.menuExport.setEnabled(true);
    }

    private void disableOption() {
        this.comboExperimentG.setEnabled(false);
        this.comboGraphG.setEnabled(false);
        this.comboVariableG.setEnabled(false);
        this.comboTypeG.setEnabled(false);
        this.bouValidG.setEnabled(false);
        this.radioActorG.setEnabled(false);
        this.radioRelationG.setEnabled(false);
        this.radioConvergenceG.setEnabled(false);
        this.radioSimulationG.setEnabled(false);
        this.labelExperimentG.setEnabled(false);
        this.labelGraphG.setEnabled(false);
        this.labelVariableG.setEnabled(false);
        this.comboExperimentD.setEnabled(false);
        this.comboGraphD.setEnabled(false);
        this.comboVariableD.setEnabled(false);
        this.comboTypeD.setEnabled(false);
        this.bouValidD.setEnabled(false);
        this.radioActorD.setEnabled(false);
        this.radioRelationD.setEnabled(false);
        this.radioConvergenceD.setEnabled(false);
        this.radioSimulationD.setEnabled(false);
        this.labelExperimentD.setEnabled(false);
        this.labelGraphD.setEnabled(false);
        this.labelVariableD.setEnabled(false);
        this.menuExport.setEnabled(false);
    }

    private void enableSaisie() {
        this.bouClearDocG.setEnabled(true);
        this.bouAddToDocG.setEnabled(true);
        this.labelTitleG.setEnabled(true);
        this.labelCommentG.setEnabled(true);
        this.scrollCommentG.setEnabled(true);
        this.txtCommentG.setEnabled(true);
        this.txtTitleG.setEnabled(true);
        this.bouClearDocD.setEnabled(true);
        this.bouAddToDocD.setEnabled(true);
        this.labelTitleD.setEnabled(true);
        this.labelCommentD.setEnabled(true);
        this.scrollCommentD.setEnabled(true);
        this.txtCommentD.setEnabled(true);
        this.txtTitleD.setEnabled(true);
    }

    private void disableSaisie() {
        this.bouClearDocG.setEnabled(false);
        this.bouAddToDocG.setEnabled(false);
        this.labelTitleG.setEnabled(false);
        this.labelCommentG.setEnabled(false);
        this.txtCommentG.setEnabled(false);
        this.scrollCommentG.setEnabled(false);
        this.txtTitleG.setEnabled(false);
        this.bouClearDocD.setEnabled(false);
        this.bouAddToDocD.setEnabled(false);
        this.labelTitleD.setEnabled(false);
        this.labelCommentD.setEnabled(false);
        this.txtCommentD.setEnabled(false);
        this.scrollCommentD.setEnabled(false);
        this.txtTitleD.setEnabled(false);
    }

    private void updateExperiment(JComboBox comboToUpdate, boolean type) {
        int i;
        if (this.priorite > 3) {
            return;
        }
        this.priorite = 3;
        String[] exp = this.control.getObservations(type);
        String temp = null;
        if (comboToUpdate.getItemCount() > 0) {
            temp = comboToUpdate.getSelectedItem().toString();
        }
        comboToUpdate.removeAllItems();
        if (exp != null) {
            i = 0;
            while (i < exp.length) {
                comboToUpdate.addItem(exp[i]);
                ++i;
            }
        }
        if (temp != null) {
            i = 0;
            while (i < exp.length) {
                if (comboToUpdate.getItemAt(i).toString().equals(temp)) {
                    comboToUpdate.setSelectedIndex(i);
                }
                ++i;
            }
        }
        comboToUpdate.setEnabled(comboToUpdate.getItemCount() > 1);
        this.priorite = -1;
    }

    private void updateType(JComboBox comboExp, JRadioButton radioActor, JRadioButton radioRelation, JRadioButton radioSimu, JRadioButton radioConverg, JComboBox comboToUpdate) {
        int i;
        if (this.priorite > 2) {
            return;
        }
        this.priorite = 2;
        String idExp = null;
        if (comboExp.getSelectedIndex() >= 0) {
            idExp = (String)comboExp.getSelectedItem();
        }
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        } else if (radioSimu.isSelected()) {
            type = 3;
        } else if (radioConverg.isSelected()) {
            type = 4;
        }
        String[] exp = this.control.getNameCategory(idExp, type);
        String temp = null;
        if (comboToUpdate.getItemCount() > 0) {
            temp = comboToUpdate.getSelectedItem().toString();
        }
        comboToUpdate.removeAllItems();
        if (exp != null) {
            i = 0;
            while (i < exp.length) {
                comboToUpdate.addItem(exp[i]);
                ++i;
            }
        }
        if (temp != null) {
            i = 0;
            while (i < exp.length) {
                if (comboToUpdate.getItemAt(i).toString().equals(temp)) {
                    comboToUpdate.setSelectedIndex(i);
                }
                ++i;
            }
        }
        comboToUpdate.setEnabled(comboToUpdate.getItemCount() > 1);
        this.priorite = -1;
    }

    private void updateVariable(JComboBox comboExp, JRadioButton radioActor, JRadioButton radioRelation, JRadioButton radioSimu, JRadioButton radioConverg, JComboBox comboType, JComboBox comboToUpdate) {
        int i;
        if (this.priorite > 1) {
            return;
        }
        this.priorite = 1;
        String idExp = null;
        if (comboExp.getSelectedIndex() >= 0) {
            idExp = (String)comboExp.getSelectedItem();
        }
        String idType = null;
        if (comboType.getSelectedIndex() >= 0) {
            idType = (String)comboType.getSelectedItem();
        }
        boolean all = false;
        if (comboType.getSelectedIndex() == 0) {
            all = true;
        }
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        } else if (radioSimu.isSelected()) {
            type = 3;
        } else if (radioConverg.isSelected()) {
            type = 4;
        }
        String[] exp = this.control.getVariables(idExp, type, all, idType);
        String temp = null;
        if (comboToUpdate.getItemCount() > 0) {
            temp = comboToUpdate.getSelectedItem().toString();
        }
        comboToUpdate.removeAllItems();
        if (exp != null) {
            i = 0;
            while (i < exp.length) {
                comboToUpdate.addItem(exp[i]);
                ++i;
            }
        }
        if (temp != null) {
            i = 0;
            while (i < exp.length) {
                if (comboToUpdate.getItemAt(i).toString().equals(temp)) {
                    comboToUpdate.setSelectedIndex(i);
                }
                ++i;
            }
        }
        comboToUpdate.setEnabled(comboToUpdate.getItemCount() > 1);
        this.priorite = -1;
    }

    private void updateGraph(JComboBox comboExp, JRadioButton radioActor, JRadioButton radioRelation, JRadioButton radioSimu, JRadioButton radioConverg, JComboBox comboType, JComboBox comboVar, JComboBox comboToUpdate) {
        int i;
        if (this.priorite > 0) {
            return;
        }
        String idExp = null;
        if (comboExp.getSelectedIndex() >= 0) {
            idExp = (String)comboExp.getSelectedItem();
        }
        String idType = null;
        if (comboType.getSelectedIndex() >= 0) {
            idType = (String)comboType.getSelectedItem();
        }
        int idVar = comboVar.getSelectedIndex();
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        } else if (radioSimu.isSelected()) {
            type = 3;
        } else if (radioConverg.isSelected()) {
            type = 4;
        }
        String[] exp = this.control.getGraph(idExp, type, idType, idVar);
        String temp = null;
        if (comboToUpdate.getItemCount() > 0) {
            temp = comboToUpdate.getSelectedItem().toString();
        }
        comboToUpdate.removeAllItems();
        if (exp != null) {
            i = 0;
            while (i < exp.length) {
                comboToUpdate.addItem(exp[i]);
                ++i;
            }
        }
        if (temp != null) {
            i = 0;
            while (i < exp.length) {
                if (comboToUpdate.getItemAt(i).toString().equals(temp)) {
                    comboToUpdate.setSelectedIndex(i);
                }
                ++i;
            }
        }
        comboToUpdate.setEnabled(comboToUpdate.getItemCount() > 0);
        this.priorite = -1;
    }

    private void updateGraphic(JComboBox comboExp, JRadioButton radioActor, JRadioButton radioRelation, JRadioButton radioSimu, JRadioButton radioConverg, JComboBox comboType, JComboBox comboVar, JComboBox comboGraph, JPanel toShow, JLabel jLabelToTitle, JTextField title) {
        String idExp = null;
        if (comboExp.getSelectedIndex() >= 0) {
            idExp = (String)comboExp.getSelectedItem();
        }
        String idType = null;
        if (comboType.getSelectedIndex() >= 0) {
            idType = (String)comboType.getSelectedItem();
        }
        int idVar = comboVar.getSelectedIndex();
        String idGraph = null;
        if (comboGraph.getSelectedIndex() >= 0) {
            idGraph = (String)comboGraph.getSelectedItem();
        }
        int type = 0;
        if (radioActor.isSelected()) {
            type = 1;
        } else if (radioRelation.isSelected()) {
            type = 2;
        } else if (radioSimu.isSelected()) {
            type = 3;
        } else if (radioConverg.isSelected()) {
            type = 4;
        }
        JPanel panel = this.control.getGraphic(idExp, type, idType, idVar, idGraph);
        if (idExp.equals("toutes les simulations")) {
            if (((String)comboVar.getSelectedItem()).equals("Satisfaction")) {
                if (idType.equals("tous les acteurs")) {
                    jLabelToTitle.setText("value of " + idVar + " for all actors during all Experiments.");
                } else {
                    jLabelToTitle.setText("value of " + idVar + " for actor " + idType + " during all Experiments.");
                }
            } else if (((String)comboVar.getSelectedItem()).equals("State")) {
                if (idType.equals("toutes les relations")) {
                    jLabelToTitle.setText("value of " + idVar + " for all relations during all Experiments.");
                } else {
                    jLabelToTitle.setText("value of " + idVar + " for relation " + idType + " during all Experiments.");
                }
            }
        } else if (((String)comboVar.getSelectedItem()).equals("Satisfaction")) {
            if (idType.equals("tous les acteurs")) {
                jLabelToTitle.setText("value of " + idVar + " for all actors in " + idExp + ".");
            } else {
                jLabelToTitle.setText("value of " + idVar + " for actor " + idType + " in " + idExp + ".");
            }
        } else if (((String)comboVar.getSelectedItem()).equals("State")) {
            if (idType.equals("toutes les relations")) {
                jLabelToTitle.setText("value of " + idVar + " for all relations in " + idExp + ".");
            } else {
                jLabelToTitle.setText("value of " + idVar + " for relation " + idType + " in " + idExp + ".");
            }
        }
        toShow.removeAll();
        panel.setSize(toShow.getSize());
        toShow.add(panel);
        toShow.repaint();
        if (title != null) {
            title.setText(jLabelToTitle.getText());
        }
        this.enableSaisie();
    }

    @Override
    public void launch() {
        this.setVisible(true);
    }
}

