/*
 * Decompiled with CFR 0.152.
 */
package input.sensitiveness;

import input.WrongFormException;
import input.sensitiveness.Correspondence;
import input.sensitiveness.Experiment;
import input.sensitiveness.ExperimentPlan;
import input.sensitiveness.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ExperimentPlanImpl
implements ExperimentPlan {
    public HashMap<String, Experiment> experimentPlan = new HashMap();
    public HashMap<String, Parameters> parameterPlan = new HashMap();

    @Override
    public void loadResults(String directoryName) throws WrongFormException, IOException {
        File directory = new File(directoryName);
        if (!directory.exists()) {
            throw new IOException("Wrong directory path :" + directoryName + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IOException("Wrong directory path :" + directoryName + " is not a directory");
        }
        File[] listFiles = directory.listFiles();
        int i = 0;
        while (i < listFiles.length) {
            String nameFile = listFiles[i].getName();
            if (nameFile.endsWith("xml")) {
                Parameters param = new Parameters();
                try {
                    param.loadParameters(listFiles[i].getAbsolutePath());
                    this.parameterPlan.put(nameFile.substring(6, nameFile.length() - 4), param);
                }
                catch (Exception e) {
                    throw new WrongFormException("Error in reading XML param file: " + nameFile);
                }
            }
            if (nameFile.endsWith("txt")) {
                Experiment exp = new Experiment(listFiles[i].getAbsolutePath());
                exp.getDatas();
                this.experimentPlan.put(nameFile.substring(8, nameFile.length() - 4), exp);
            }
            ++i;
        }
    }

    @Override
    public HashMap<String, Experiment> getExperimentPlan() {
        return this.experimentPlan;
    }

    @Override
    public String[] getVariableNames() {
        Collection<Parameters> collParam = this.parameterPlan.values();
        Iterator<Parameters> itParam = collParam.iterator();
        Parameters param = itParam.next();
        HashMap<String, Double> hashParam = param.getParameters();
        Set<String> keySet = hashParam.keySet();
        Iterator<String> iteratorKey = keySet.iterator();
        String[] variableNames = new String[hashParam.size()];
        int i = 0;
        while (i < hashParam.size()) {
            variableNames[i] = iteratorKey.next();
            ++i;
        }
        return variableNames;
    }

    @Override
    public String[] getExpNames() {
        String[] expName = new String[this.experimentPlan.size()];
        Set<String> keySet = this.experimentPlan.keySet();
        Iterator<String> iteratorKey = keySet.iterator();
        int i = 0;
        while (i < this.experimentPlan.size()) {
            expName[i] = iteratorKey.next();
            ++i;
        }
        return expName;
    }

    @Override
    public boolean isVariable(String var) {
        String[] varName = this.getVariableNames();
        int i = 0;
        boolean res = false;
        while (!res && i < varName.length) {
            if (var.equals(varName[i])) {
                res = true;
            }
            ++i;
        }
        return res;
    }

    @Override
    public double getValue(String variable, String exp, Correspondence corresp) throws Exception {
        Parameters param = this.parameterPlan.get(exp);
        if (param != null) {
            String str = corresp.get(variable);
            if (str == null) {
                str = variable;
            }
            return param.getValue(str);
        }
        throw new Exception(String.valueOf(exp) + " is not the name of an experiment");
    }

    @Override
    public String[] getOutputNames() {
        Collection<Experiment> collParam = this.experimentPlan.values();
        Iterator<Experiment> itParam = collParam.iterator();
        Experiment exp = itParam.next();
        HashMap<String, Double> hashExp = exp.getExperiment();
        Set<String> keySet = hashExp.keySet();
        Iterator<String> iteratorKey = keySet.iterator();
        String[] outputNames = new String[hashExp.size()];
        int i = 0;
        while (i < hashExp.size()) {
            outputNames[i] = iteratorKey.next();
            ++i;
        }
        return outputNames;
    }

    @Override
    public double getOutputValue(String exp, String output) throws Exception {
        Experiment param = this.experimentPlan.get(exp);
        if (param != null) {
            return param.getOutputValue(output);
        }
        throw new Exception(String.valueOf(exp) + " is not the name of an experiment");
    }
}

