/*
 * Decompiled with CFR 0.152.
 */
package input.unmarshalling;

import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private Vector<SAXParseException> saxParseFatalErrors = new Vector();
    private Vector<SAXParseException> saxParseErrors = new Vector();
    private Vector<SAXParseException> saxParseWarnings = new Vector();
    private String xmlFilename = "";

    public ErrorHandlerImpl() {
    }

    public ErrorHandlerImpl(String xmlFilename_) {
        this();
        this.xmlFilename = xmlFilename_;
    }

    public Vector<SAXParseException> getSAXParseFatalErrors() {
        return this.saxParseFatalErrors;
    }

    public Vector<SAXParseException> getSAXParseErrors() {
        return this.saxParseErrors;
    }

    public Vector<SAXParseException> getSAXParseWarnings() {
        return this.saxParseWarnings;
    }

    public int getNbFatalErrors() {
        return this.saxParseFatalErrors.size();
    }

    public int getNbErrors() {
        return this.saxParseErrors.size();
    }

    public int getNbWarnings() {
        return this.saxParseWarnings.size();
    }

    public int getNbExceptions() {
        return this.getNbFatalErrors() + this.getNbErrors() + this.getNbWarnings();
    }

    public boolean isExceptions() {
        return this.getNbExceptions() != 0;
    }

    @Override
    public void fatalError(SAXParseException fatalError) throws SAXException {
        this.saxParseFatalErrors.add(fatalError);
    }

    @Override
    public void error(SAXParseException error) throws SAXException {
        this.saxParseErrors.add(error);
    }

    @Override
    public void warning(SAXParseException warning) throws SAXException {
        this.saxParseWarnings.add(warning);
    }

    public static String saxParseExceptionToString(SAXParseException ex) {
        return "URI=" + ex.getSystemId() + "\n" + "\tLine=" + ex.getLineNumber() + ", Column=" + ex.getColumnNumber() + "\n" + "\t" + ex.getMessage() + "\n";
    }

    public String toString() {
        String allErrors;
        if (this.isExceptions()) {
            allErrors = !this.xmlFilename.equals("") ? "Errors encountered during the parsing of " + this.xmlFilename + ":\n" : "";
            for (SAXParseException ex : this.saxParseFatalErrors) {
                allErrors = String.valueOf(allErrors) + "fatalError: " + ErrorHandlerImpl.saxParseExceptionToString(ex);
            }
            for (SAXParseException ex : this.saxParseErrors) {
                allErrors = String.valueOf(allErrors) + "Error: " + ErrorHandlerImpl.saxParseExceptionToString(ex);
            }
            for (SAXParseException ex : this.saxParseWarnings) {
                allErrors = String.valueOf(allErrors) + "Warning: " + ErrorHandlerImpl.saxParseExceptionToString(ex);
            }
        } else {
            allErrors = "No exceptions found during this parsing\n";
        }
        return allErrors;
    }
}

