/*
 * Decompiled with CFR 0.152.
 */
package org.cloner.serialized;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.cloner.CloneException;

public class SerializationCloner {
    public static Object clone(Object bean) {
        try {
            ThreadUnsafeByteArrayOutputStream bos = new ThreadUnsafeByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(bean);
            ThreadUnsafeByteArrayinputStream bin = new ThreadUnsafeByteArrayinputStream(bos.data);
            ObjectInputStream ois = new ObjectInputStream(bin);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new CloneException(e);
        }
    }

    private static class ThreadUnsafeByteArrayinputStream
    extends InputStream {
        byte[] data;
        int pos;

        ThreadUnsafeByteArrayinputStream(byte[] array) {
            this.data = array;
            this.pos = 0;
        }

        public int read() throws IOException {
            if (this.pos < this.data.length) {
                return this.data[this.pos++];
            }
            throw new IOException();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.data.length < this.pos + len) {
                len = this.data.length - this.pos;
            }
            System.arraycopy(this.data, this.pos, b, off, len);
            return len;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    private static class ThreadUnsafeByteArrayOutputStream
    extends OutputStream {
        byte[] data = new byte[1024];
        int count = 0;
        int size = 1024;

        ThreadUnsafeByteArrayOutputStream() {
        }

        public void write(int b) throws IOException {
            this.checkSize(this.count + 1);
            this.data[this.count++] = (byte)b;
        }

        public void write(byte[] b) throws IOException {
            this.checkSize(this.count + b.length);
            System.arraycopy(b, 0, this.data, this.count, b.length);
            this.count += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.checkSize(this.count + len);
            System.arraycopy(b, off, this.data, this.count, len);
            this.count += len;
        }

        private void checkSize(int new_count) {
            if (new_count > this.size) {
                this.size = 2 * this.size > new_count ? 2 * this.size : 2 * new_count;
                byte[] ndata = new byte[this.size];
                System.arraycopy(this.data, 0, ndata, 0, this.count);
                this.data = ndata;
            }
        }
    }
}

