/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.goldang.qaparadigm.Alert;
import org.goldang.qaparadigm.Application;
import org.goldang.qaparadigm.Strings;

class SentenceFile
extends File {
    private final Application myApp;
    private final NumberedSentences numberedSentences;
    private int mySequenceIndex = 0;
    public static final int TEXT = 1;
    public static final int PICTURE = 2;
    private int myType = 1;
    private final Pattern HEADER_PATTERN = Pattern.compile("^([\\w\\.]+)\\t([\\w\\.]+)$");
    private final Pattern LINE_PATTERN = Pattern.compile("^(\\d+)\\t(.+)$");

    private final void setType(int type) {
        this.myType = type;
    }

    public final boolean isType(int type) {
        return type == this.myType;
    }

    int sequenceIndex() {
        return this.mySequenceIndex;
    }

    String getCurrentSentence() {
        NumberedSentence ns = this.currentNumberedSentence();
        if (ns instanceof NumberedSentence) {
            return ns.sentence;
        }
        return "";
    }

    int getCurrentSentenceNumber() {
        NumberedSentence ns = this.currentNumberedSentence();
        if (ns instanceof NumberedSentence) {
            return ns.number;
        }
        return 0;
    }

    void doNextSentence() {
        ++this.mySequenceIndex;
    }

    private NumberedSentence currentNumberedSentence() {
        if (this.mySequenceIndex < this.numberOfSentences()) {
            return (NumberedSentence)this.numberedSentences.get(this.mySequenceIndex);
        }
        return null;
    }

    boolean isFinished() {
        return this.mySequenceIndex >= this.numberOfSentences();
    }

    boolean moreSentencesYet() {
        return this.mySequenceIndex + 1 < this.numberOfSentences();
    }

    void doPrevSentence() {
        if (this.mySequenceIndex > 0) {
            --this.mySequenceIndex;
        }
    }

    void goToSentenceIndexed(int n) {
        if (n > 0 && n < this.numberOfSentences()) {
            this.mySequenceIndex = n;
        }
    }

    final int numberOfSentences() {
        return this.numberedSentences.size();
    }

    public NumberedSentences getNumberedSentences() {
        return this.numberedSentences;
    }

    private void randomize(NumberedSentences randomized) {
        int n = randomized.size();
        for (int i = 0; i < n; ++i) {
            NumberedSentence ns = (NumberedSentence)randomized.get(i);
            int j = (int)Math.floor(Math.random() * ((double)n - 1.0) + 0.5);
            randomized.set(i, randomized.get(j));
            randomized.set(j, ns);
        }
    }

    public SentenceFile(Application app, File file) {
        super(file.toURI());
        this.myApp = app;
        BufferedReader br = this.openFileAsText(file);
        this.numberedSentences = new NumberedSentences();
        this.fillNumberedSentencesFromFileLines(br);
        if (app.getPrefs().shouldRandomizeSentences()) {
            this.randomize(this.numberedSentences);
        }
    }

    private BufferedReader openFileAsText(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            return new BufferedReader(isr);
        }
        catch (IOException e) {
            new Alert(Strings.res(Strings.CANT_OPEN) + " " + e, (Frame)this.myApp);
            return null;
        }
    }

    File getFileForSoundNumber(int n) {
        File directory = this.getParentFile();
        String soundFileName = "q" + n + ".wav";
        return new File(directory, soundFileName);
    }

    private void fillNumberedSentencesFromFileLines(BufferedReader br) {
        try {
            String s = br.readLine();
            if (s != null) {
                this.interpretHeaderLine(s);
                while ((s = br.readLine()) != null) {
                    this.addMatchingLineToNumberedSentences(s);
                }
            }
            if (this.numberOfSentences() == 0) {
                new Alert(Strings.res(Strings.NO_SENTENCES_FOUND), (Frame)this.myApp);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    private void interpretHeaderLine(String s) {
        Matcher matcher = this.HEADER_PATTERN.matcher(s);
        if (matcher.find() && matcher.groupCount() == 2) {
            String col1 = matcher.group(1);
            String col2 = matcher.group(2);
            if ("number".equals(col1)) {
                if ("picture".equals(col2)) {
                    this.setType(2);
                } else if ("text".equals(col2)) {
                    this.setType(1);
                }
            }
        }
    }

    private void addMatchingLineToNumberedSentences(String s) {
        Matcher matcher = this.LINE_PATTERN.matcher(s);
        if (matcher.find() && matcher.groupCount() == 2) {
            String number = matcher.group(1);
            String sentence = matcher.group(2);
            int n = Integer.parseInt(number);
            this.numberedSentences.add(n, sentence);
        }
    }

    private void printAllNumberedSentences() {
        for (NumberedSentence ns : this.numberedSentences) {
            System.out.println(ns.number + " " + ns.sentence);
        }
    }

    public static void main(String[] arg) {
        if (arg.length == 1) {
            File file = new File(arg[0]);
            SentenceFile sfr = new SentenceFile(null, file);
            sfr.printAllNumberedSentences();
        } else {
            System.err.println(Strings.res(Strings.PLEASE_PROVIDE_FILE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NumberedSentences
    extends ArrayList<NumberedSentence> {
        NumberedSentences() {
        }

        NumberedSentences(List<NumberedSentence> ns) {
            super(ns);
        }

        @Override
        void add(int i, String s) {
            this.add(new NumberedSentence(i, s));
        }
    }

    class NumberedSentence {
        int number;
        String sentence;

        NumberedSentence(int i, String s) {
            this.number = i;
            this.sentence = s;
        }
    }
}

