/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.FontDialog;
import org.goldang.qaparadigm.Fontset;
import org.goldang.qaparadigm.FullFrame;
import org.goldang.qaparadigm.GraphicDisplay;
import org.goldang.qaparadigm.Strings;
import org.goldang.qaparadigm.TextDisplay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextDisplayPanel
extends DisplayPanel {
    private FontControlMenu myMenu;
    private final TextDisplay myTextDisplay;
    private final Pattern numPattern = Pattern.compile("^\\d+$");

    public TextDisplayPanel(FullFrame frame) throws Fontset.SupportException {
        super(frame);
        this.myTextDisplay = new TextDisplay(this.getInitialFont());
        this.add(this.myTextDisplay);
        this.add(this.myMenu);
    }

    private Font getInitialFont() throws Fontset.SupportException {
        List<Font> supported;
        Font font = null;
        String fontName = this.myApp.getPrefs().preferredFontFamily();
        if (fontName.length() != 0) {
            font = Font.decode(fontName);
        }
        if (font instanceof Font && !(supported = this.fontsSupportingSentences()).isEmpty()) {
            return supported.get(0);
        }
        return font;
    }

    protected final List<Font> fontsSupportingSentences() throws Fontset.SupportException {
        return Fontset.supporting(this.getSentenceFile().getNumberedSentences());
    }

    @Override
    protected void sizeToFit() {
        this.sizeFontToFit();
    }

    final int sizeFontToFit() {
        int size = this.myTextDisplay.sizeFontToFit(this.getSentenceFile().getNumberedSentences(), this.getFrameWidth());
        this.myTextDisplay.setFontSize(size);
        return size;
    }

    @Override
    public GraphicDisplay getGraphicDisplay() {
        return this.myTextDisplay;
    }

    final void showString(String s) {
        this.myTextDisplay.setString(s);
        this.doLayout();
    }

    @Override
    protected void showStimulus() {
        if (!this.sentencesAreFinished()) {
            this.setFontStyle(0, Color.BLACK);
            this.showString(this.getCurrentSentence());
            this.getLogFile().log(this.sequenceIndex(), this.getCurrentSentenceNumber(), this.getCurrentSentence());
        }
    }

    final void setFontStyle(int style, Color color) {
        Font fnt = this.myTextDisplay.getFont();
        Font newfnt = new Font(fnt.getName(), style, fnt.getSize());
        this.myTextDisplay.setFont(newfnt);
        this.myTextDisplay.setForeground(color);
    }

    private void fillFontDisplay(FontDialog dialog, List<Font> fonts) {
        ArrayList<String> names = new ArrayList<String>();
        for (Font font : fonts) {
            names.add(font.getName());
        }
        dialog.setFontNames(names);
        dialog.setSelectedFont(this.getFontName());
    }

    String getFontName() {
        return this.myTextDisplay.getFont().getName();
    }

    void setFontName(String name) {
        this.myTextDisplay.setFontName(name);
    }

    int getFontSize() {
        return this.myTextDisplay.getFont().getSize();
    }

    void setFontSize(int size) {
        this.myTextDisplay.setFontSize(size);
    }

    @Override
    public JMenu makeMenu() {
        if (!(this.myMenu instanceof JMenu)) {
            this.myMenu = new FontControlMenu();
        }
        return this.myMenu;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.makeMenu();
        return this.myMenu.getPopupMenu();
    }

    class ShowFontDialog
    extends AbstractAction {
        ShowFontDialog() {
        }

        public void actionPerformed(ActionEvent e) {
            TextDisplayPanel display = TextDisplayPanel.this;
            FontDialog fd = new FontDialog(TextDisplayPanel.this.getFrame(), display);
            try {
                List<Font> fonts = TextDisplayPanel.this.fontsSupportingSentences();
                TextDisplayPanel.this.fillFontDisplay(fd, fonts);
                fd.setVisible(true);
            }
            catch (Fontset.SupportException ex) {
                return;
            }
        }
    }

    private class FontControlMenu
    extends DisplayPanel.ControlMenu {
        FontControlMenu() {
            this.add((Component)new JPopupMenu.Separator(), 4);
            this.add(Strings.FONT_, new ShowFontDialog(), 5);
        }
    }

    class SetFontSizeAction
    extends AbstractAction {
        SetFontSizeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TextDisplayPanel display = TextDisplayPanel.this;
            String c = e.getActionCommand();
            Matcher numberMatch = TextDisplayPanel.this.numPattern.matcher(c);
            if (numberMatch.find()) {
                display.setFontSize(Integer.parseInt(c));
            }
        }
    }
}

