/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.TagListener;
import org.sourceforge.kga.plant.Tag;

public class TagList {
    private static Logger log = Logger.getLogger(PlantList.class.getName());
    private static TagList instance = null;
    private ArrayList<Tag> resources = null;
    private Set<TagListener> listeners = new HashSet<TagListener>();

    public static TagList getInstance() {
        if (instance == null) {
            instance = new TagList();
        }
        return instance;
    }

    public void addListener(TagListener tagListener) {
        this.listeners.add(tagListener);
    }

    public void removeListener(TagListener tagListener) {
        this.listeners.remove(tagListener);
    }

    public Collection<TagListener> getListeners() {
        return this.listeners;
    }

    public ArrayList<Tag> getTags() {
        if (this.resources == null) {
            this.loadResources();
        }
        return this.resources;
    }

    public Tag getTagByName(String string) {
        if (this.resources == null) {
            this.loadResources();
        }
        for (Tag tag : this.resources) {
            if (tag.getName().compareTo(string) != 0) continue;
            return tag;
        }
        return null;
    }

    public void addTag(Tag tag) {
        this.resources.add(tag);
        this.saveTag(tag);
        for (TagListener tagListener : this.listeners) {
            tagListener.tagAdded(tag);
        }
    }

    public void deleteTag(Tag tag) {
        tag.setSpecies(null);
        this.resources.remove(tag);
        this.deleteTagFromResources(tag);
        for (TagListener tagListener : this.listeners) {
            tagListener.tagDeleted(tag);
        }
    }

    public void changeTag(Tag tag, String string, Collection<Plant> collection) {
        tag.setName(string);
        tag.setSpecies(collection);
        this.saveTag(tag);
        for (TagListener tagListener : this.listeners) {
            tagListener.tagDeleted(tag);
        }
    }

    private void loadResources() {
        this.resources = new ArrayList();
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/tags");
        try {
            for (String string : preferences.keys()) {
                String string2 = preferences.get(string, "");
                log.info("Loading tag " + string + " with species " + string2);
                ArrayList<Plant> arrayList = new ArrayList<Plant>();
                for (String string3 : string2.split(":")) {
                    try {
                        Plant numberFormatException = PlantList.getResources().getPlant(Integer.parseInt(string3));
                        if (numberFormatException == null) {
                            log.warning("Invalid species id " + string3);
                            continue;
                        }
                        arrayList.add(numberFormatException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warning("Invalid species id " + numberFormatException.toString());
                    }
                }
                Tag object = new Tag(string, arrayList);
                this.resources.add(object);
            }
        }
        catch (BackingStoreException backingStoreException) {
            log.warning(backingStoreException.toString());
        }
    }

    private void saveTag(Tag tag) {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/tags");
        StringBuilder stringBuilder = new StringBuilder();
        for (Plant plant : tag.getSpecies()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(plant.getId());
        }
        log.info("Saving tag " + tag.getName() + " with species " + stringBuilder.toString());
        preferences.put(tag.getName(), stringBuilder.toString());
    }

    private void deleteTagFromResources(Tag tag) {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/tags");
        log.info("Deleting tag " + tag.getName());
        preferences.remove(tag.getName());
    }
}

