/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.Rectangle;
import org.sourceforge.kga.gui.desktop.EditableGarden;
import org.sourceforge.kga.gui.desktop.GardenView;
import org.sourceforge.kga.translation.Translation;

public class GardenController
extends MouseAdapter {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private int year;
    private EditableGarden garden;
    private GardenView view;
    Point lastPosition = null;

    public void setView(GardenView gardenView) {
        gardenView.addMouseListener(this);
        gardenView.addMouseMotionListener(this);
        gardenView.addMouseWheelListener(this);
        this.view = gardenView;
        this.garden = gardenView.getGarden();
        this.year = gardenView.getYear();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (this.garden.getOperation() != EditableGarden.Operation.PickPlant) {
            return;
        }
        Point point = this.view.LocationToGrid(mouseEvent.getPoint());
        List<Plant> list = this.garden.getSpeciesNoPreview(this.year, point);
        if (list == null || list.size() == 0) {
            return;
        }
        this.garden.removePreview();
        if (list.size() == 1) {
            if (this.garden.getSelectedPlant() != list.get(0)) {
                this.garden.setSelectedPlant(list.get(0));
            }
            this.garden.setOperation(EditableGarden.Operation.AddPlant);
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            if (this.garden.getSelectedPlant() != list.get(n)) continue;
            ++n;
            break;
        }
        this.garden.setSelectedPlant(list.get(n % list.size()));
        this.garden.setOperation(EditableGarden.Operation.AddPlant);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.view.LocationToGrid(mouseEvent.getPoint());
        Rectangle rectangle = this.garden.getBounds();
        if (point.x < rectangle.x || point.y < rectangle.y || point.x > rectangle.x + rectangle.width - 1 || point.y > rectangle.y + rectangle.height - 1) {
            return;
        }
        if (this.lastPosition != null && point.x == this.lastPosition.x && point.y == this.lastPosition.y) {
            return;
        }
        this.lastPosition = point;
        this.mousePressed(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.garden.removePreview();
        this.lastPosition = null;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = this.view.LocationToGrid(mouseEvent.getPoint());
        if (this.lastPosition != null && point.x == this.lastPosition.x && point.y == this.lastPosition.y) {
            return;
        }
        this.lastPosition = point;
        if (this.garden.getSelectedPlant() != null && this.garden.getOperation() == EditableGarden.Operation.AddPlant) {
            this.garden.addPreview(this.year, this.lastPosition, this.garden.getSelectedPlant());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        Point point;
        if (this.garden.getOperation() == EditableGarden.Operation.PickPlant) {
            return;
        }
        this.garden.removePreview();
        this.lastPosition = point = this.view.LocationToGrid(mouseEvent.getPoint());
        Rectangle rectangle = this.garden.getBounds();
        boolean bl2 = bl = point.x < rectangle.x || point.y < rectangle.y || point.x > rectangle.x + rectangle.width - 1 || point.y > rectangle.y + rectangle.height - 1;
        if (this.garden.getOperation() == EditableGarden.Operation.DeletePlant) {
            this.garden.removePlant(this.year, point, this.garden.getSelectedPlant());
        } else if (this.garden.getSelectedPlant() != null) {
            this.garden.addPlant(this.year, point, this.garden.getSelectedPlant());
            log.info("Adding square with " + this.garden.getSelectedPlant() + " at grid " + point);
            if (bl) {
                this.lastPosition = this.view.LocationToGrid(mouseEvent.getPoint());
                this.garden.addPreview(this.year, this.lastPosition, this.garden.getSelectedPlant());
            }
        } else {
            JOptionPane.showMessageDialog(null, Translation.getPreferred().select_species_first());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastPosition = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.isControlDown()) {
            this.garden.setZoomFactor(this.garden.getZoomFactor() - 5 * mouseWheelEvent.getWheelRotation());
        } else {
            this.view.getParent().dispatchEvent(mouseWheelEvent);
        }
    }
}

