/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantComparatorByName;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.gui.desktop.PlantComponent;
import org.sourceforge.kga.translation.Iso639_1;
import org.sourceforge.kga.translation.Translation;

public class PlantComboBox
extends JComboBox<SeedList.Entry.PlantOrUnregistered> {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    PlantListModel plantListModel = new PlantListModel();
    PlantComboBoxEditor editor = new PlantComboBoxEditor(this.plantListModel, this);

    public PlantComboBox() {
        this.setModel(this.plantListModel);
        this.setEditable(true);
        this.setRenderer(new ComboBoxRenderer());
        this.setEditor(this.editor);
        this.setSelectedItem(new SeedList.Entry.PlantOrUnregistered(""));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlantComboBox.this.showPopup();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlantComboBox.this.hidePopup();
                    }
                });
            }
        });
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlantComboBox.this.showPopup();
                    }
                });
            }
        });
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        SeedList.Entry.PlantOrUnregistered plantOrUnregistered = (SeedList.Entry.PlantOrUnregistered)object;
        if (plantOrUnregistered != null) {
            Translation translation = Translation.getPreferred();
            this.plantListModel.setFilter(plantOrUnregistered.unregisteredPlant != null ? plantOrUnregistered.unregisteredPlant : translation.translate(plantOrUnregistered.plant));
        } else {
            this.plantListModel.setFilter("");
        }
    }

    class PlantComboBoxEditor
    extends JPanel
    implements ComboBoxEditor,
    DocumentListener {
        SeedList.Entry.PlantOrUnregistered currentPlant;
        PlantListModel model;
        JComboBox<SeedList.Entry.PlantOrUnregistered> combo;
        JLabel image = new JLabel();
        JTextField textField = new JTextField();
        Icon emptyIcon = new ImageIcon(new BufferedImage(12, 12, 2));

        PlantComboBoxEditor(PlantListModel plantListModel, final JComboBox<SeedList.Entry.PlantOrUnregistered> jComboBox) {
            this.model = plantListModel;
            this.combo = jComboBox;
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jComboBox.getItemCount() > 0) {
                        jComboBox.setSelectedItem(jComboBox.getItemAt(0));
                    } else {
                        jComboBox.setSelectedItem(PlantComboBoxEditor.this.currentPlant);
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.image.setIcon(this.emptyIcon);
            this.image.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.add((Component)this.image, "West");
            this.add((Component)this.textField, "Center");
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlantComboBox.this.showPopup();
                        }
                    });
                }
            });
        }

        private void textChanged() {
            if (this.currentPlant == null || this.currentPlant.unregisteredPlant == null) {
                this.currentPlant = new SeedList.Entry.PlantOrUnregistered(this.textField.getText());
            } else {
                this.currentPlant.unregisteredPlant = this.textField.getText();
            }
            int n = this.model.getSize();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
            if (this.combo.getSelectedItem() != this.currentPlant) {
                this.combo.setSelectedItem(this.currentPlant);
            }
            this.model.setFilter(this.textField.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.textField.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.textField.removeActionListener(actionListener);
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            Translation translation = Translation.getPreferred();
            this.currentPlant = (SeedList.Entry.PlantOrUnregistered)object;
            if (object == null) {
                log.info("null");
            } else if (this.currentPlant == null) {
                log.info(object.toString());
            } else {
                log.info("unregisteredPlant=" + (this.currentPlant.unregisteredPlant == null ? "null" : this.currentPlant.unregisteredPlant) + " plant=" + (this.currentPlant.plant == null ? "null" : this.currentPlant.plant.toString()));
            }
            if (this.currentPlant == null) {
                this.textField.setText("");
                this.image.setIcon(this.emptyIcon);
            } else {
                String string = this.currentPlant.plant == null ? this.currentPlant.unregisteredPlant : translation.translate(this.currentPlant.plant);
                log.info("oldText=" + this.textField.getText() + " newText=" + string);
                if (string.compareTo(this.textField.getText()) != 0) {
                    this.textField.getDocument().removeDocumentListener(this);
                    this.textField.setText(string);
                    this.textField.getDocument().addDocumentListener(this);
                }
                if (this.currentPlant.plant != null) {
                    ImageIcon imageIcon = new ImageIcon(this.currentPlant.plant.getImage().get().getScaledInstance(12, 12, 4));
                    this.image.setIcon(imageIcon);
                } else {
                    this.image.setIcon(this.emptyIcon);
                }
            }
        }

        @Override
        public Object getItem() {
            log.info("getItem");
            return this.currentPlant;
        }

        @Override
        public void selectAll() {
            log.info("selectAll");
        }
    }

    class ComboBoxRenderer
    extends PlantComponent
    implements ListCellRenderer<SeedList.Entry.PlantOrUnregistered> {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList<? extends SeedList.Entry.PlantOrUnregistered> jList, SeedList.Entry.PlantOrUnregistered plantOrUnregistered, int n, boolean bl, boolean bl2) {
            SeedList.Entry.PlantOrUnregistered plantOrUnregistered2 = plantOrUnregistered;
            this.setPlant(plantOrUnregistered2.plant);
            this.setSelected(bl);
            return this;
        }
    }

    class PlantListModel
    extends DefaultComboBoxModel<SeedList.Entry.PlantOrUnregistered> {
        private static final long serialVersionUID = 1L;
        ArrayList<SeedList.Entry.PlantOrUnregistered> plants = new ArrayList();
        ArrayList<SeedList.Entry.PlantOrUnregistered> filtered = new ArrayList();

        public PlantListModel() {
            ArrayList<Plant> arrayList = new ArrayList<Plant>();
            for (Plant plant : PlantList.getResources().getPlants()) {
                if (plant.getImage() == null || plant.isItem()) continue;
                arrayList.add(plant);
            }
            Collections.sort(arrayList, new PlantComparatorByName());
            for (Plant plant : arrayList) {
                if (plant.getImage() == null) continue;
                SeedList.Entry.PlantOrUnregistered plantOrUnregistered = new SeedList.Entry.PlantOrUnregistered(plant);
                this.plants.add(plantOrUnregistered);
                this.filtered.add(plantOrUnregistered);
            }
        }

        public void setFilter(String string) {
            Translation translation = Translation.getPreferred();
            final int n = this.filtered.size();
            if (n != 0) {
                this.filtered.clear();
            }
            for (SeedList.Entry.PlantOrUnregistered plantOrUnregistered : this.plants) {
                if (string.length() != 0 && !Iso639_1.containsText(plantOrUnregistered.plant.getName(), string) && !Iso639_1.containsText(translation.translate(plantOrUnregistered.plant), string)) continue;
                this.filtered.add(plantOrUnregistered);
            }
            final int n2 = this.filtered.size();
            if (n != 0 || n2 != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlantListModel.this.fireContentsChanged(this, 0, Math.min(n2 - 1, n - 1));
                        if (n > n2) {
                            PlantListModel.this.fireIntervalRemoved(this, n2, n - 1);
                        }
                        if (n2 > n) {
                            PlantListModel.this.fireIntervalAdded(this, n, n2 - 1);
                        }
                    }
                });
            }
        }

        @Override
        public SeedList.Entry.PlantOrUnregistered getElementAt(int n) {
            return this.filtered.get(n);
        }

        @Override
        public int getSize() {
            return this.filtered.size();
        }
    }
}

